/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.init.Localization;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemWindmeter
extends ItemElectricTool {
    public ItemWindmeter() {
        super(ItemName.wind_meter, 50);
        this.func_77625_d(1);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = StackUtil.get(player, hand);
        if (!IC2.platform.isSimulating()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
        double windStrength = WorldData.get((World)world).windSim.getWindAt(player.field_70163_u);
        if (windStrength < 0.0) {
            windStrength = 0.0;
        }
        IC2.platform.messagePlayer(player, Localization.translate("ic2.itemwindmeter.info", Float.valueOf((float)Math.round(windStrength * 100.0) / 100.0f)), new Object[0]);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

