/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui;

import ic2.core.GuiIC2;
import ic2.core.gui.Button;
import ic2.core.gui.IClickHandler;

public class BasicButton
extends Button<BasicButton> {
    private final ButtonStyle style;

    public static BasicButton create(GuiIC2<?> gui, int x, int y, IClickHandler handler, ButtonStyle style) {
        return new BasicButton(gui, x, y, handler, style);
    }

    protected BasicButton(GuiIC2<?> gui, int x, int y, IClickHandler handler, ButtonStyle style) {
        super(gui, x, y, style.width, style.height, handler);
        this.style = style;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        BasicButton.bindCommonTexture();
        if (this.style.hasHover && this.contains(mouseX, mouseY)) {
            this.gui.drawTexturedRect(this.x, this.y, this.style.width, this.style.height, this.style.hoverU, this.style.hoverV);
        } else {
            this.gui.drawTexturedRect(this.x, this.y, this.style.width, this.style.height, this.style.u, this.style.v);
        }
        super.drawBackground(mouseX, mouseY);
    }

    public static enum ButtonStyle {
        AdvMinerReset(192, 32, 36, 15),
        AdvMinerMode(228, 32, 18, 15),
        AdvMinerSilkTouch(192, 47, 18, 15),
        IndustrialWorkbenchReset(192, 76, 192, 92, 16, 16);

        final int u;
        final int v;
        final int hoverU;
        final int hoverV;
        final int width;
        final int height;
        final boolean hasHover;

        private ButtonStyle(int u, int v, int width, int height) {
            this(u, v, u, v, width, height);
        }

        private ButtonStyle(int u, int v, int hoverU, int hoverV, int width, int height) {
            this.u = u;
            this.v = v;
            this.hoverU = hoverU;
            this.hoverV = hoverV;
            this.width = width;
            this.height = height;
            this.hasHover = u != hoverU || v != hoverV;
        }
    }
}

