/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Fluids;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.container.ContainerFluidDistributor;
import ic2.core.block.machine.gui.GuiFluidDistributor;
import ic2.core.network.GuiSynced;
import ic2.core.util.LiquidUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityFluidDistributor
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener {
    public final InvSlotConsumableLiquidByTank inputSlot;
    public final InvSlotOutput OutputSlot;
    @GuiSynced
    public final Fluids.InternalFluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));

    public TileEntityFluidDistributor() {
        this.fluidTank = this.fluids.addTank("fluidTank", 1000);
        this.inputSlot = new InvSlotConsumableLiquidByTank(this, "inputSlot", InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.fluidTank);
        this.OutputSlot = new InvSlotOutput(this, "OutputSlot", 1);
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        this.updateConnectivity();
    }

    @Override
    public void setActive(boolean val) {
        super.setActive(val);
        this.updateConnectivity();
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        this.updateConnectivity();
    }

    private void updateConnectivity() {
        EnumSet<EnumFacing> acceptingSides = EnumSet.of(this.getFacing());
        if (this.getActive()) {
            acceptingSides = EnumSet.complementOf(acceptingSides);
        }
        this.fluids.changeConnectivity(this.fluidTank, acceptingSides, Collections.<EnumFacing>emptySet());
    }

    @Override
    protected void updateEntityServer() {
        block10: {
            RecipeOutput outputinputSlot;
            super.updateEntityServer();
            if (this.fluidTank.getFluidAmount() > 0 && (outputinputSlot = this.processInputSlot(true)) != null) {
                this.processInputSlot(false);
                List<ItemStack> list = outputinputSlot.items;
                this.OutputSlot.add(list);
            }
            if (this.fluidTank.getFluidAmount() <= 0) break block10;
            World world = this.func_145831_w();
            if (this.getActive()) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    int amount;
                    EnumFacing side;
                    TileEntity target;
                    if (dir != this.getFacing() || !LiquidUtil.isFluidTile(target = world.func_175625_s(this.field_174879_c.func_177972_a(dir)), side = dir.func_176734_d()) || (amount = LiquidUtil.fillTile(target, side, this.fluidTank.getFluid(), false)) <= 0) continue;
                    this.fluidTank.drainInternal(amount, true);
                }
            } else {
                int amount;
                EnumSet<EnumFacing> enumSet = EnumSet.noneOf(EnumFacing.class);
                int acceptedVolume = 0;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    int amount2;
                    EnumFacing side;
                    TileEntity target;
                    if (dir == this.getFacing() || !LiquidUtil.isFluidTile(target = world.func_175625_s(this.field_174879_c.func_177972_a(dir)), side = dir.func_176734_d()) || (amount2 = LiquidUtil.fillTile(target, side, this.fluidTank.getFluid(), true)) <= 0) continue;
                    enumSet.add(dir);
                    acceptedVolume += amount2;
                }
                block2: while (!enumSet.isEmpty() && (amount = Math.min(acceptedVolume, this.fluidTank.getFluidAmount())) > 0) {
                    int cAmount;
                    FluidStack fs;
                    EnumFacing side;
                    TileEntity target;
                    if ((amount /= enumSet.size()) > 0) {
                        Iterator it = enumSet.iterator();
                        while (it.hasNext()) {
                            EnumFacing dir = (EnumFacing)it.next();
                            target = world.func_175625_s(this.field_174879_c.func_177972_a(dir));
                            side = dir.func_176734_d();
                            fs = this.fluidTank.getFluid();
                            if (fs == null) continue block2;
                            fs = fs.copy();
                            if (fs.amount <= 0) continue block2;
                            fs.amount = Math.min(amount, fs.amount);
                            cAmount = LiquidUtil.fillTile(target, side, fs, false);
                            this.fluidTank.drainInternal(cAmount, true);
                            acceptedVolume -= cAmount;
                            if (cAmount >= fs.amount) continue;
                            it.remove();
                        }
                        continue;
                    }
                    for (EnumFacing dir : enumSet) {
                        target = world.func_175625_s(this.field_174879_c.func_177972_a(dir));
                        side = dir.func_176734_d();
                        fs = this.fluidTank.getFluid();
                        if (fs == null) break block10;
                        fs = fs.copy();
                        fs.amount = Math.min(acceptedVolume, fs.amount);
                        if (fs.amount > 0) {
                            cAmount = LiquidUtil.fillTile(target, side, fs, false);
                            this.fluidTank.drainInternal(cAmount, true);
                            acceptedVolume -= cAmount;
                            continue;
                        }
                        break block10;
                    }
                    break;
                }
            }
        }
    }

    private RecipeOutput processInputSlot(boolean simulate) {
        MutableObject output;
        if (!this.inputSlot.isEmpty() && this.inputSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.OutputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.setActive(!this.getActive());
    }

    public ContainerBase<TileEntityFluidDistributor> getGuiContainer(EntityPlayer player) {
        return new ContainerFluidDistributor(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiFluidDistributor(new ContainerFluidDistributor(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }
}

