/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import ic2.api.event.TeBlockFinalCallEvent;
import ic2.core.IC2;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.ref.BlockName;
import ic2.core.ref.TeBlock;
import ic2.core.util.LogCategory;
import ic2.core.util.Tuple;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class TeBlockRegistry {
    private static final Map<String, ITeBlock> NAME_REGISTRY = new HashMap<String, ITeBlock>();
    private static final Map<Class<? extends TileEntityBlock>, ITeBlock> CLASS_REGISTRY = new IdentityHashMap<Class<? extends TileEntityBlock>, ITeBlock>();
    private static final Map<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>> RESOURCE_REGISTRY = new HashMap<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>>(5);
    private static boolean blocksBuilt;

    public static void add(ITeBlock teBlock) {
        if (!TeBlockRegistry.canBuildBlocks()) {
            throw new IllegalStateException("Cannot register additional ITeBlocks once block map built!");
        }
        assert (teBlock != null) : "Cannot register null ITeBlock!";
        TeBlockRegistry.addName(teBlock.getName(), teBlock);
        TeBlockRegistry.addClass(teBlock.getTeClass(), teBlock);
        ResourceLocation loc = teBlock.getIdentifier();
        if (!RESOURCE_REGISTRY.containsKey(loc)) {
            RESOURCE_REGISTRY.put(loc, new Tuple.T3(null, new LinkedHashSet(), new ArrayList()));
        }
        if (!((Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)loc).b).add(teBlock)) {
            throw new IllegalStateException("ITeBlock already registered!");
        }
        if (teBlock.getId() > -1) {
            TeBlockRegistry.addID((List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)loc).c, teBlock);
        }
    }

    public static <E extends Enum<E>> void addAll(Class<E> enumClass, ResourceLocation identifier) {
        if (!TeBlockRegistry.canBuildBlocks()) {
            throw new IllegalStateException("Cannot register additional ITeBlocks once block map built!");
        }
        EnumSet<ITeBlock> blocks = EnumSet.allOf(enumClass);
        assert (!blocks.isEmpty()) : "Cannot register empty enum!";
        assert (identifier != null) : "Cannot register a null identifier!";
        if (!RESOURCE_REGISTRY.containsKey(identifier)) {
            RESOURCE_REGISTRY.put(identifier, new Tuple.T3(null, new LinkedHashSet<ITeBlock>(blocks), new ArrayList()));
        } else {
            ((Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).b).addAll(blocks);
        }
        List map = (List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).c;
        for (ITeBlock block : blocks) {
            TeBlockRegistry.addName(block.getName(), block);
            TeBlockRegistry.addClass(block.getTeClass(), block);
            if (block.getId() <= -1) continue;
            TeBlockRegistry.addID(map, block);
        }
    }

    private static void addName(String name, ITeBlock teBlock) {
        if (NAME_REGISTRY.put(teBlock.getName(), teBlock) != null) {
            throw new IllegalStateException("Duplicate name for different ITeBlocks!");
        }
    }

    private static void addClass(Class<?> teClass, ITeBlock teBlock) {
        if (CLASS_REGISTRY.put(teBlock.getTeClass(), teBlock) != null) {
            throw new IllegalStateException("Duplicate class name for different ITeBlocks!");
        }
    }

    private static void addID(List<ITeBlock> map, ITeBlock teBlock) {
        int ID = teBlock.getId();
        while (map.size() < ID) {
            map.add(null);
        }
        if (map.size() == ID) {
            map.add(teBlock);
        } else {
            if (map.get(ID) != null) {
                throw new IllegalStateException("The id " + ID + " for " + teBlock + " is already in use by " + map.get(ID) + '.');
            }
            map.set(ID, teBlock);
        }
    }

    public static void buildBlocks() {
        if (!TeBlockRegistry.canBuildBlocks()) {
            throw new IllegalStateException("Cannot build blocks twice!");
        }
        MinecraftForge.EVENT_BUS.post((Event)new TeBlockFinalCallEvent());
        blocksBuilt = true;
        ResourceLocation ic2Loc = TeBlock.invalid.getIdentifier();
        for (ResourceLocation location : RESOURCE_REGISTRY.keySet()) {
            LinkedHashSet<Material> mats = new LinkedHashSet<Material>();
            for (ITeBlock teBlock : (Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)location).b) {
                mats.add(TeBlockRegistry.getMaterial(teBlock));
            }
            if (mats.size() > 8) {
                throw new RuntimeException("Cannot form a TeBlock with more than 8 different materials (attempted " + mats.size() + ')');
            }
            BlockTileEntity block = location == ic2Loc ? BlockTileEntity.create(BlockName.te, mats) : BlockTileEntity.create(location.func_110624_b() + "_te_" + location.func_110623_a(), location, mats);
            TeBlockRegistry.RESOURCE_REGISTRY.get((Object)location).a = block;
        }
    }

    public static Material getMaterial(ITeBlock teBlock) {
        try {
            return teBlock.getMaterial();
        }
        catch (AbstractMethodError e) {
            return Material.field_151573_f;
        }
    }

    public static boolean canBuildBlocks() {
        return !blocksBuilt;
    }

    public static ITeBlock get(String name) {
        ITeBlock ret = NAME_REGISTRY.get(name);
        return ret != null ? ret : TeBlock.invalid;
    }

    public static ITeBlock get(ResourceLocation identifier, int ID) {
        List items;
        if (ID >= 0 && RESOURCE_REGISTRY.containsKey(identifier) && ID < (items = (List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).c).size()) {
            return (ITeBlock)items.get(ID);
        }
        return null;
    }

    public static ITeBlock get(Class<? extends TileEntityBlock> cls) {
        return CLASS_REGISTRY.get(cls);
    }

    public static BlockTileEntity get(ResourceLocation identifier) {
        return RESOURCE_REGISTRY.containsKey(identifier) ? (BlockTileEntity)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).a : null;
    }

    public static Iterable<Map.Entry<ResourceLocation, Set<ITeBlock>>> getAll() {
        return Collections2.transform(RESOURCE_REGISTRY.entrySet(), (Function)new Function<Map.Entry<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>>, Map.Entry<ResourceLocation, Set<ITeBlock>>>(){

            public AbstractMap.SimpleImmutableEntry<ResourceLocation, Set<ITeBlock>> apply(Map.Entry<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>> input) {
                return new AbstractMap.SimpleImmutableEntry<ResourceLocation, Set<ITeBlock>>(input.getKey(), Collections.unmodifiableSet((Set)input.getValue().b));
            }
        });
    }

    public static Collection<BlockTileEntity> getAllBlocks() {
        return Collections2.transform(RESOURCE_REGISTRY.values(), (Function)new Function<Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>, BlockTileEntity>(){

            public BlockTileEntity apply(Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>> input) {
                return (BlockTileEntity)input.a;
            }
        });
    }

    public static Set<ITeBlock> getAll(ResourceLocation identifier) {
        return RESOURCE_REGISTRY.containsKey(identifier) ? Collections.unmodifiableSet((Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).b) : Collections.emptySet();
    }

    static List<ITeBlock> getItems(ResourceLocation identifier) {
        return RESOURCE_REGISTRY.containsKey(identifier) ? Collections.unmodifiableList((List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).c) : Collections.emptyList();
    }

    public static BlockTileEntity attemptToRemap(String resourcePath) {
        ArrayList possibleReplacements = new ArrayList();
        for (Map.Entry<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>> knownBlocks : RESOURCE_REGISTRY.entrySet()) {
            if (!knownBlocks.getKey().func_110623_a().equals(resourcePath)) continue;
            possibleReplacements.add(knownBlocks.getValue().a);
        }
        if (possibleReplacements.isEmpty()) {
            IC2.log.warn(LogCategory.Block, "Unable to find new mapping for " + resourcePath);
            return null;
        }
        if (possibleReplacements.size() == 1) {
            IC2.log.info(LogCategory.Block, "Found new mapping for " + resourcePath);
        } else {
            IC2.log.warn(LogCategory.Block, "Multiple entries found for " + resourcePath + ". Using the 1st of " + possibleReplacements.size());
        }
        return (BlockTileEntity)possibleReplacements.get(0);
    }

    private TeBlockRegistry() {
    }
}

