/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableOreDict;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.container.ContainerIndustrialWorkbench;
import ic2.core.block.machine.gui.GuiIndustrialWorkbench;
import ic2.core.ref.ItemName;
import ic2.core.util.IInventoryInvSlot;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityIndustrialWorkbench
extends TileEntityInventory
implements IHasGui {
    public final InvSlot craftingGrid = new InvSlot(this, "crafting", InvSlot.Access.NONE, 9);
    public final InvSlot craftingStorage = new InvSlot(this, "craftingStorage", InvSlot.Access.I, 18){
        private boolean skip;
        {
            this.skip = false;
        }

        @Override
        public void onChanged() {
            super.onChanged();
            if (!this.skip) {
                this.skip = true;
                int size = this.size();
                for (int slot = 0; slot < size; ++slot) {
                    ItemStack stack = this.get(slot);
                    if (stack == StackUtil.emptyStack || !StackUtil.isEmpty(stack)) continue;
                    this.clear(slot);
                }
                this.skip = false;
            }
        }
    };
    public final InvSlotCraftingCombo leftCrafting = new InvSlotCraftingCombo(this, "left", "craftingToolForgeHammer");
    public final InvSlotCraftingCombo rightCrafting = new InvSlotCraftingCombo(this, "right", "craftingToolWireCutter");

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("PLACED")) {
            this.leftCrafting.tool.put(ItemName.forge_hammer.getItemStack());
            this.rightCrafting.tool.put(ItemName.cutter.getItemStack());
        }
    }

    @Override
    protected ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        drop = super.adjustDrop(drop, wrench);
        if (wrench) {
            StackUtil.getOrCreateNbtData(drop).func_74757_a("PLACED", true);
        }
        return drop;
    }

    public void rebalance() {
        if (!this.craftingGrid.isEmpty()) {
            boolean changed = false;
            IInventoryInvSlot crafting = new IInventoryInvSlot(this.craftingGrid);
            for (ItemStack stack : this.craftingStorage) {
                if (stack == null) continue;
                changed |= !StackUtil.balanceStacks(crafting, stack).isEmpty();
            }
            if (changed) {
                super.func_70296_d();
            }
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.rebalance();
    }

    public ContainerBase<TileEntityIndustrialWorkbench> getGuiContainer(EntityPlayer player) {
        return new ContainerIndustrialWorkbench(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiIndustrialWorkbench(new ContainerIndustrialWorkbench(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public static class InvSlotCraftingCombo {
        protected boolean currentlyCrafting;
        protected IRecipe recipe;
        protected InventoryCrafting crafting = new InventoryCrafting(null, 0, 0){

            private boolean validIndex(int index) {
                return index >= 0 && index < this.func_70302_i_();
            }

            public int func_70302_i_() {
                return 2;
            }

            public ItemStack func_70463_b(int row, int column) {
                return row >= 0 && row < this.func_174923_h() && column >= 0 && column < this.func_174922_i() ? this.func_70301_a(column) : null;
            }

            private ItemStack get(int index) {
                switch (index) {
                    case 0: {
                        return InvSlotCraftingCombo.this.tool.get();
                    }
                    case 1: {
                        return InvSlotCraftingCombo.this.input.get();
                    }
                }
                throw new IllegalArgumentException("Invalid index: " + index);
            }

            private void put(int index, ItemStack stack) {
                switch (index) {
                    case 0: {
                        InvSlotCraftingCombo.this.tool.put(stack);
                        break;
                    }
                    case 1: {
                        InvSlotCraftingCombo.this.input.put(stack);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid index: " + index + " for " + StackUtil.toStringSafe(stack));
                    }
                }
            }

            public ItemStack func_70301_a(int index) {
                return !this.validIndex(index) ? null : this.get(index);
            }

            public ItemStack func_70304_b(int index) {
                if (this.validIndex(index)) {
                    ItemStack stack = this.get(index);
                    this.put(index, StackUtil.emptyStack);
                    return stack;
                }
                return null;
            }

            public ItemStack func_70298_a(int index, int count) {
                ItemStack stack;
                if (this.validIndex(index) && !StackUtil.isEmpty(stack = this.get(index))) {
                    ItemStack ret;
                    if (count >= StackUtil.getSize(stack)) {
                        ret = stack;
                        this.put(index, StackUtil.emptyStack);
                    } else {
                        ret = StackUtil.copyWithSize(stack, count);
                        this.put(index, StackUtil.decSize(stack, count));
                    }
                    return ret;
                }
                return StackUtil.emptyStack;
            }

            public void func_70299_a(int index, ItemStack stack) {
                if (this.validIndex(index)) {
                    this.put(index, stack);
                }
            }

            public void func_174888_l() {
                InvSlotCraftingCombo.this.input.clear();
                InvSlotCraftingCombo.this.tool.clear();
            }

            public int func_174922_i() {
                return 2;
            }

            public int func_174923_h() {
                return 1;
            }
        };
        public final InvSlotConsumable input;
        public final InvSlotConsumableOreDict tool;
        public final InvSlotOutput output;

        public InvSlotCraftingCombo(TileEntityInventory base, String name, String tool) {
            this.input = new InvSlotConsumable(base, name + "Input", InvSlot.Access.I, 1, InvSlot.InvSide.ANY){
                private boolean skip;

                @Override
                public void readFromNbt(NBTTagCompound nbt) {
                    this.skip = true;
                    super.readFromNbt(nbt);
                    this.skip = false;
                }

                @Override
                public boolean accepts(ItemStack stack) {
                    return true;
                }

                @Override
                public void onChanged() {
                    super.onChanged();
                    if (!this.skip && !InvSlotCraftingCombo.this.currentlyCrafting && InvSlotCraftingCombo.this.process()) {
                        InvSlotCraftingCombo.this.input.base.func_70296_d();
                    }
                }
            };
            this.tool = new InvSlotConsumableOreDict(base, name + "Tool", InvSlot.Access.I, 1, InvSlot.InvSide.ANY, tool){
                private boolean skip;

                @Override
                public void readFromNbt(NBTTagCompound nbt) {
                    this.skip = true;
                    super.readFromNbt(nbt);
                    this.skip = false;
                }

                @Override
                public void onChanged() {
                    super.onChanged();
                    if (!this.skip && !InvSlotCraftingCombo.this.currentlyCrafting && InvSlotCraftingCombo.this.process()) {
                        InvSlotCraftingCombo.this.input.base.func_70296_d();
                    }
                }
            };
            this.output = new InvSlotOutput(base, name + "Output", 1, InvSlot.InvSide.ANY);
        }

        public boolean canProcess() {
            if (!this.input.isEmpty() && !this.tool.isEmpty()) {
                if (this.recipe == null || !this.recipe.func_77569_a(this.crafting, this.tool.base.func_145831_w())) {
                    World world = this.tool.base.func_145831_w();
                    for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                        if (!recipe.func_77569_a(this.crafting, world)) continue;
                        this.recipe = recipe;
                        return this.output.canAdd(recipe.func_77571_b());
                    }
                    this.recipe = null;
                } else {
                    return this.output.canAdd(this.recipe.func_77571_b());
                }
            }
            return false;
        }

        public boolean process() {
            if (this.canProcess()) {
                this.currentlyCrafting = true;
                this.processOnce();
                while (this.canProcess()) {
                    this.processOnce();
                }
                this.currentlyCrafting = false;
                return true;
            }
            return false;
        }

        public void processOnce() {
            this.input.consume(1);
            this.tool.consume(1);
            this.output.add(this.recipe.func_77571_b());
        }
    }
}

