/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import ic2.api.energy.tile.IKineticSource;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.ContainerBase;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.kineticgenerator.container.ContainerSteamKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiSteamKineticGenerator;
import ic2.core.block.machine.tileentity.TileEntityCondenser;
import ic2.core.init.MainConfig;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.util.ConfigUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySteamKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IFluidHandler,
IHasGui,
IUpgradableBlock {
    protected final FluidTank steamTank = new FluidTank(21000);
    protected final FluidTank distilledWaterTank = new FluidTank(1000);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 1);
    public final InvSlotConsumable turbineSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "Turbineslot", 1, ItemName.crafting.getItemStack(CraftingItemType.steam_turbine));
    private static final float outputModifier = ConfigUtil.getFloat(MainConfig.get(), "balance/energy/kineticgenerator/steam");
    private int kUoutput;
    private boolean throttled;
    private boolean isTurbineFilledWithWater = false;
    private int condensationProgress = 0;
    private int updateTicker = IC2.random.nextInt(this.getTickRate());

    public TileEntitySteamKineticGenerator() {
        this.turbineSlot.setStackSizeLimit(1);
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.distilledWaterTank.getCapacity() - this.distilledWaterTank.getFluidAmount() >= 1 && this.isTurbineFilledWithWater) {
            this.isTurbineFilledWithWater = false;
        }
        if (this.steamTank.getFluidAmount() > 10 && !this.isTurbineFilledWithWater && !this.turbineSlot.isEmpty()) {
            if (!this.getActive()) {
                this.setActive(true);
                needsInvUpdate = true;
            }
            boolean turbineDoneWork = this.turbineDoWork();
            if (this.updateTicker++ >= this.getTickRate()) {
                if (turbineDoneWork) {
                    this.turbineSlot.damage(this.isHotSteam() ? 1 : 2, false);
                }
                this.updateTicker = 0;
            }
        } else if (this.getActive()) {
            this.setActive(false);
            needsInvUpdate = true;
            this.kUoutput = 0;
        }
        if (needsInvUpdate |= this.upgradeSlot.tickNoMark()) {
            super.func_70296_d();
        }
    }

    private int handleSteam(int amount) {
        this.steamTank.drainInternal(amount, true);
        int KUWorkbuffer = amount * 2 * (this.isHotSteam() ? 2 : 1);
        if (this.isHotSteam()) {
            this.outputSteam(amount);
        } else {
            int condensation = amount / 10;
            this.condensationProgress += condensation;
            this.outputSteam(amount - condensation);
        }
        return KUWorkbuffer;
    }

    private boolean turbineDoWork() {
        float throttle;
        int rawOutput = this.handleSteam(this.steamTank.getFluidAmount());
        int waterAmount = this.distilledWaterTank.getFluidAmount();
        if (waterAmount == 0) {
            this.throttled = false;
            throttle = 1.0f;
        } else {
            this.throttled = true;
            throttle = 1.0f - (float)waterAmount / (float)this.distilledWaterTank.getCapacity();
        }
        this.kUoutput = (int)((float)rawOutput * throttle * outputModifier);
        if (this.condensationProgress >= 100) {
            if (this.distilledWaterTank.fill(new FluidStack(FluidName.distilled_water.getInstance(), 1), false) == 1) {
                this.condensationProgress -= 100;
                this.distilledWaterTank.fill(new FluidStack(FluidName.distilled_water.getInstance(), 1), true);
            } else {
                this.isTurbineFilledWithWater = true;
            }
        }
        return this.kUoutput > 0;
    }

    private void outputSteam(int amount) {
        World world = this.func_145831_w();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = world.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (!this.isHotSteam() ? !(te instanceof TileEntityCondenser) : !(te instanceof TileEntityCondenser) && !(te instanceof TileEntitySteamKineticGenerator)) continue;
            IFluidHandler target = (IFluidHandler)te;
            int transAmount = target.fill(dir.func_176734_d(), new FluidStack(FluidName.steam.getInstance(), amount), false);
            if (transAmount <= 0) continue;
            if (amount > transAmount) {
                target.fill(dir.func_176734_d(), new FluidStack(FluidName.steam.getInstance(), amount), true);
                amount -= transAmount;
            } else {
                target.fill(dir.func_176734_d(), new FluidStack(FluidName.steam.getInstance(), amount), true);
                amount = 0;
            }
            if (amount == 0) break;
        }
        if (amount > 0 && world.field_73012_v.nextInt(10) == 0) {
            new ExplosionIC2(world, null, this.field_174879_c, 1, 1.0f, ExplosionIC2.Type.Heat).doExplosion();
        }
    }

    public int getKUoutput() {
        return this.kUoutput;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.condensationProgress = nbttagcompound.func_74762_e("condensationprogress");
        this.distilledWaterTank.readFromNBT(nbttagcompound.func_74775_l("distilledwaterTank"));
        this.steamTank.readFromNBT(nbttagcompound.func_74775_l("SteamTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("condensationprogress", this.condensationProgress);
        nbt.func_74782_a("distilledwaterTank", (NBTBase)this.distilledWaterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("SteamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public ContainerBase<TileEntitySteamKineticGenerator> getGuiContainer(EntityPlayer player) {
        return new ContainerSteamKineticGenerator(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiSteamKineticGenerator(new ContainerSteamKineticGenerator(player, this));
    }

    @Override
    public int maxrequestkineticenergyTick(EnumFacing directionFrom) {
        return directionFrom == this.getFacing() ? this.kUoutput : 0;
    }

    @Override
    public int requestkineticenergy(EnumFacing directionFrom, int requestkineticenergy) {
        return directionFrom == this.getFacing() ? this.kUoutput : 0;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        if (resource.getFluid() == FluidName.steam.getInstance() || resource.getFluid() == FluidName.superheated_steam.getInstance()) {
            if (this.steamTank.getFluid() != null && this.steamTank.getFluid().getFluid() != resource.getFluid()) {
                this.steamTank.drain(this.steamTank.getFluidAmount(), true);
            }
            return this.steamTank.fill(resource, doFill);
        }
        if (resource.getFluid() == FluidRegistry.WATER || resource.getFluid() == FluidName.distilled_water.getInstance()) {
            if (this.distilledWaterTank.getFluid() != null && this.distilledWaterTank.getFluid().getFluid() != resource.getFluid()) {
                this.distilledWaterTank.drain(this.distilledWaterTank.getFluidAmount(), true);
            }
            return this.distilledWaterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.distilledWaterTank.getFluid()) || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.distilledWaterTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.distilledWaterTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getFacing()) {
            return false;
        }
        if (fluid == FluidName.steam.getInstance() || fluid == FluidName.superheated_steam.getInstance()) {
            return this.steamTank.getFluidAmount() < this.steamTank.getCapacity();
        }
        if (fluid == FluidRegistry.WATER || fluid == FluidName.distilled_water.getInstance()) {
            return this.distilledWaterTank.getFluidAmount() < this.distilledWaterTank.getCapacity();
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from.func_176734_d() == this.getFacing() || from == this.getFacing()) {
            return false;
        }
        FluidStack fs = this.distilledWaterTank.getFluid();
        return fs != null && fs.getFluid() == fluid;
    }

    public int gaugeLiquidScaled(int i, int tank) {
        if (tank == 0 && this.distilledWaterTank.getFluidAmount() > 0) {
            return this.distilledWaterTank.getFluidAmount() * i / this.distilledWaterTank.getCapacity();
        }
        return 0;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.distilledWaterTank.getInfo(), this.steamTank.getInfo()};
    }

    @Override
    public double getEnergy() {
        return 0.0;
    }

    @Override
    public boolean useEnergy(double amount) {
        return false;
    }

    public int getDistilledWaterTankFill() {
        return this.distilledWaterTank.getFluidAmount();
    }

    public FluidTank getDistilledWaterTank() {
        return this.distilledWaterTank;
    }

    private boolean isHotSteam() {
        return this.steamTank.getFluid() != null && this.steamTank.getFluid().getFluid() == FluidName.superheated_steam.getInstance();
    }

    public boolean hasTurbine() {
        return !this.turbineSlot.isEmpty();
    }

    public boolean isThrottled() {
        return this.throttled;
    }

    public boolean isTurbineBlockedByWater() {
        return this.isTurbineFilledWithWater;
    }

    public int getTickRate() {
        return 20;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemConsuming, UpgradableProperty.FluidConsuming, UpgradableProperty.FluidProducing);
    }
}

