/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.grid;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.ILocatable;
import ic2.core.IC2;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.energy.grid.EnergyNetLocal;
import ic2.core.util.LogCategory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            throw new IllegalStateException("already initialized");
        }
        initialized = true;
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    private EventHandler() {
    }

    @SubscribeEvent
    public void onEnergyTileLoad(EnergyTileLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyTileLoadEvent: posted for %s client-side, aborting", event.tile);
            return;
        }
        if (event.tile instanceof TileEntity) {
            EnergyNet.instance.addTile(EventHandler.castToTeTile(event.tile));
        } else if (event.tile instanceof ILocatable) {
            EnergyNet.instance.addTile(EventHandler.castToLocTile(event.tile));
        } else {
            throw new IllegalArgumentException("invalid tile type: " + event.tile);
        }
    }

    @SubscribeEvent
    public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
        if (event.getWorld().field_72995_K) {
            IC2.log.warn(LogCategory.EnergyNet, "EnergyTileUnloadEvent: posted for %s client-side, aborting", event.tile);
            return;
        }
        EnergyNet.instance.removeTile(event.tile);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        EnergyNetLocal enet = EnergyNetGlobal.getLocal(event.world);
        if (event.phase == TickEvent.Phase.START) {
            enet.onTickStart();
        } else {
            enet.onTickEnd();
        }
    }

    private static <T extends TileEntity> T castToTeTile(IEnergyTile tile) {
        return (T)((TileEntity)tile);
    }

    private static <T extends ILocatable & IEnergyTile> T castToLocTile(IEnergyTile tile) {
        return (T)((ILocatable)((Object)tile));
    }
}

