/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.ref;

import com.google.common.base.Optional;
import ic2.core.block.ITeBlock;
import ic2.core.block.TeBlockRegistry;
import ic2.core.ref.MetaTeBlock;
import ic2.core.ref.TeBlock;
import ic2.core.util.Tuple;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.ResourceLocation;

public class MetaTeBlockProperty
implements IProperty<MetaTeBlock> {
    private final Collection<MetaTeBlock> allowedValues;
    private final String resourceLocationName;
    private static final Map<ResourceLocation, Tuple.T2<Integer, List<MetaTE2>>> resourceToTeBlock = new HashMap<ResourceLocation, Tuple.T2<Integer, List<MetaTE2>>>();
    private static final Map<ITeBlock, Tuple.T2<MetaTeBlock, MetaTeBlock>> teResourceMapping = new IdentityHashMap<ITeBlock, Tuple.T2<MetaTeBlock, MetaTeBlock>>();
    public static final MetaTeBlock invalid;

    public MetaTeBlockProperty(final ResourceLocation identifier) {
        this.resourceLocationName = identifier.toString();
        this.allowedValues = new AbstractCollection<MetaTeBlock>(){
            private final int trueSize;
            {
                this.trueSize = (Integer)((Tuple.T2)resourceToTeBlock.get((Object)identifier)).a;
            }

            @Override
            public Iterator<MetaTeBlock> iterator() {
                return new Iterator<MetaTeBlock>(){
                    private int teBlockIdx;
                    private boolean active;
                    private final List<MetaTE2> teBlockMap;
                    private final int allTeBlockSize;
                    {
                        this.teBlockMap = (List)((Tuple.T2)resourceToTeBlock.get((Object)identifier)).b;
                        this.allTeBlockSize = this.teBlockMap.size();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.teBlockIdx < this.allTeBlockSize;
                    }

                    @Override
                    public MetaTeBlock next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        MetaTE2 teBlockPair = this.teBlockMap.get(this.teBlockIdx);
                        MetaTeBlock ret = this.active ? (MetaTeBlock)teBlockPair.b : (MetaTeBlock)teBlockPair.a;
                        if (!this.active && teBlockPair.hasActive()) {
                            this.active = true;
                        } else {
                            this.active = false;
                            ++this.teBlockIdx;
                        }
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove a MetaTeBlock state.");
                    }
                };
            }

            @Override
            public int size() {
                return this.trueSize;
            }
        };
    }

    public String func_177701_a() {
        return "type";
    }

    public Collection<MetaTeBlock> func_177700_c() {
        return this.allowedValues;
    }

    public Class<MetaTeBlock> func_177699_b() {
        return MetaTeBlock.class;
    }

    public Optional<MetaTeBlock> func_185929_b(String value) {
        return null;
    }

    public String getName(MetaTeBlock value) {
        if (value.active) {
            return value.teBlock.getName() + "_active";
        }
        return value.teBlock.getName();
    }

    public String toString() {
        return "MetaTeBlockProperty{For " + this.resourceLocationName + '}';
    }

    public static List<MetaTE2> getAllStates(ResourceLocation identifier) {
        return (List)MetaTeBlockProperty.resourceToTeBlock.get((Object)identifier).b;
    }

    public static MetaTeBlock getState(ITeBlock teBlock) {
        return MetaTeBlockProperty.getState(teBlock, false);
    }

    public static MetaTeBlock getState(ITeBlock teBlock, boolean active) {
        Tuple.T2<MetaTeBlock, MetaTeBlock> state = teResourceMapping.get(teBlock);
        if (state == null) {
            return invalid;
        }
        return active && teBlock.hasActive() ? (MetaTeBlock)state.b : (MetaTeBlock)state.a;
    }

    static {
        for (Map.Entry<ResourceLocation, Set<ITeBlock>> blocks : TeBlockRegistry.getAll()) {
            ArrayList<MetaTE2> locationBlocks = new ArrayList<MetaTE2>(blocks.getValue().size());
            int states = 0;
            for (ITeBlock block : blocks.getValue()) {
                MetaTE2 lastIn;
                if (block.hasActive()) {
                    states += 2;
                    lastIn = new MetaTE2(block, true);
                    locationBlocks.add(lastIn);
                } else {
                    ++states;
                    lastIn = new MetaTE2(block, false);
                    locationBlocks.add(lastIn);
                }
                teResourceMapping.put(block, lastIn);
            }
            resourceToTeBlock.put(blocks.getKey(), new Tuple.T2(states, locationBlocks));
        }
        MetaTE2 invalidStates = (MetaTE2)teResourceMapping.get(TeBlock.invalid);
        invalid = (MetaTeBlock)invalidStates.a;
        assert (invalid != null) : "Failed to properly map ITeBlocks to MetaTeBlocks!";
        for (Map.Entry<ResourceLocation, Tuple.T2<Integer, List<MetaTE2>>> type : resourceToTeBlock.entrySet()) {
            if (type.getKey() == MetaTeBlockProperty.invalid.teBlock.getIdentifier()) continue;
            Tuple.T2<Integer, List<MetaTE2>> t2 = type.getValue();
            Integer n = (Integer)t2.a;
            t2.a = (Integer)t2.a + 1;
            Integer n2 = t2.a;
            ((List)type.getValue().b).add(invalidStates);
        }
    }

    public static final class MetaTE2
    extends Tuple.T2<MetaTeBlock, MetaTeBlock> {
        private final boolean hasActive;
        private final boolean hasItem;
        private final ResourceLocation loc;

        public MetaTE2(ITeBlock block, boolean active) {
            super(new MetaTeBlock(block, false), active ? new MetaTeBlock(block, true) : null);
            this.hasActive = active;
            this.hasItem = block.hasItem();
            this.loc = block.getIdentifier();
        }

        public ITeBlock getBlock() {
            return ((MetaTeBlock)this.a).teBlock;
        }

        public boolean hasActive() {
            return this.hasActive;
        }

        public boolean hasItem() {
            return this.hasItem;
        }

        public ResourceLocation getIdentifier() {
            return this.loc;
        }
    }
}

