/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.grid;

import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.energy.grid.Grid;
import ic2.core.energy.grid.GridChange;
import ic2.core.energy.grid.GridInfo;
import ic2.core.energy.grid.GridUpdater;
import ic2.core.energy.grid.Node;
import ic2.core.energy.grid.Tile;
import ic2.core.ref.BlockName;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnergyNetLocal {
    private final World world;
    private final Queue<GridChange> gridChangesQueue = new ArrayDeque<GridChange>();
    private final Set<BlockPos> positionsToNotify = new HashSet<BlockPos>();
    private final GridUpdater updater = new GridUpdater(this);
    int nextNodeId;
    int nextGridId;
    final Map<IEnergyTile, Tile> registeredIoTiles = new IdentityHashMap<IEnergyTile, Tile>();
    final Map<BlockPos, Tile> registeredTiles = new HashMap<BlockPos, Tile>();
    final Set<Grid> grids = Collections.newSetFromMap(new IdentityHashMap());

    public static EnergyNetLocal create(World world) {
        return new EnergyNetLocal(world);
    }

    private EnergyNetLocal(World world) {
        this.world = world;
    }

    IEnergyTile getIoTile(BlockPos pos) {
        Tile tile = this.getTile(pos);
        if (tile == null) {
            return null;
        }
        return tile.getMainTile();
    }

    IEnergyTile getSubTile(BlockPos pos) {
        Tile tile = this.getTile(pos);
        if (tile == null) {
            return null;
        }
        return tile.getSubTileAt(pos);
    }

    public Tile getTile(BlockPos pos) {
        if (this.updater.isInChangeStep()) {
            this.updater.awaitCompletion();
        }
        return this.registeredTiles.get(pos);
    }

    void addTile(IEnergyTile tile, BlockPos pos) {
        this.gridChangesQueue.add(new GridChange(GridChange.Type.ADDITION, pos, tile));
    }

    void removeTile(IEnergyTile tile, BlockPos pos) {
        this.gridChangesQueue.add(new GridChange(GridChange.Type.REMOVAL, pos, tile));
    }

    NodeStats getNodeStats(IEnergyTile ioTile) {
        this.updater.awaitCompletion();
        Tile tile = this.registeredIoTiles.get(ioTile);
        if (tile == null) {
            return null;
        }
        return EnergyNetGlobal.getCalculator().getNodeStats(tile);
    }

    public Collection<GridInfo> getGridInfos() {
        if (this.updater.isInChangeStep()) {
            this.updater.awaitCompletion();
        }
        ArrayList<GridInfo> ret = new ArrayList<GridInfo>();
        for (Grid grid : this.grids) {
            ret.add(grid.getInfo());
        }
        return ret;
    }

    boolean dumpDebugInfo(BlockPos pos, PrintStream console, PrintStream chat) {
        this.updater.awaitCompletion();
        Tile tile = this.registeredTiles.get(pos);
        if (tile == null) {
            return false;
        }
        chat.println("Tile " + tile + " info:");
        chat.println(" main: " + tile.getMainTile());
        chat.println(" sub: " + tile.subTiles);
        chat.println(" nodes: " + tile.nodes.size());
        HashSet<Grid> processedGrids = new HashSet<Grid>();
        for (Node node : tile.nodes) {
            Grid grid = node.getGrid();
            if (!processedGrids.add(grid)) continue;
            grid.dumpNodeInfo(node, " ", console, chat);
            grid.dumpInfo(" ", console, chat);
            grid.dumpGraph();
        }
        return true;
    }

    void onTickStart() {
        if (this.updater.isInChangeStep()) {
            this.updater.awaitCompletion();
            if (!this.positionsToNotify.isEmpty()) {
                Object block = BlockName.te.getInstance();
                for (BlockPos pos : this.positionsToNotify) {
                    if (!this.world.func_175667_e(pos)) continue;
                    this.world.func_180496_d(pos, block);
                }
                this.positionsToNotify.clear();
            }
            this.updater.startTransferCalc();
        }
    }

    void onTickEnd() {
        this.updater.awaitCompletion();
        if (!this.gridChangesQueue.isEmpty()) {
            this.updater.startChangeCalc(this.gridChangesQueue);
        } else {
            this.updater.startTransferCalc();
        }
    }

    public World getWorld() {
        return this.world;
    }

    int allocateNodeId() {
        return this.nextNodeId++;
    }

    int allocateGridId() {
        return this.nextGridId++;
    }

    void addPositionToNotify(BlockPos pos) {
        this.positionsToNotify.add(pos);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.positionsToNotify.add(pos.func_177972_a(facing));
        }
    }
}

