/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import ic2.api.item.ElectricItem;
import ic2.api.recipe.ICraftingRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.init.MainConfig;
import ic2.core.recipe.AdvRecipe;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.Vector;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.IFluidContainerItem;

public class AdvShapelessRecipe
implements IRecipe {
    public ItemStack output;
    public IRecipeInput[] input;
    public boolean hidden;
    public boolean consuming;

    public static void addAndRegister(ItemStack result, Object ... args) {
        block2: {
            try {
                CraftingManager.func_77594_a().func_77592_b().add(new AdvShapelessRecipe(result, args));
            }
            catch (RuntimeException e) {
                if (MainConfig.ignoreInvalidRecipes) break block2;
                throw e;
            }
        }
    }

    public AdvShapelessRecipe(ItemStack result, Object ... args) {
        if (result == null) {
            AdvRecipe.displayError("null result", null, null, true);
        } else {
            result = result.func_77946_l();
        }
        this.input = new IRecipeInput[args.length - Util.countInArray(args, Boolean.class, ICraftingRecipeManager.AttributeContainer.class)];
        int inputIndex = 0;
        for (Object o : args) {
            if (o instanceof Boolean) {
                this.hidden = (Boolean)o;
                continue;
            }
            if (o instanceof ICraftingRecipeManager.AttributeContainer) {
                this.hidden = ((ICraftingRecipeManager.AttributeContainer)o).hidden;
                this.consuming = ((ICraftingRecipeManager.AttributeContainer)o).consuming;
                continue;
            }
            try {
                this.input[inputIndex++] = AdvRecipe.getRecipeObject(o);
            }
            catch (Exception e) {
                e.printStackTrace();
                AdvRecipe.displayError("unknown type", "O: " + o + "\nT: " + o.getClass().getName(), result, true);
            }
        }
        if (inputIndex != this.input.length) {
            AdvRecipe.displayError("length calculation error", "I: " + inputIndex + "\nL: " + this.input.length, result, true);
        }
        this.output = result;
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        return this.func_77572_b(inventorycrafting) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        int offerSize = inventorycrafting.func_70302_i_();
        if (offerSize < this.input.length) {
            return null;
        }
        Vector<IRecipeInput> unmatched = new Vector<IRecipeInput>();
        for (IRecipeInput o : this.input) {
            unmatched.add(o);
        }
        double outputCharge = 0.0;
        block1: for (int i = 0; i < offerSize; ++i) {
            ItemStack offer = inventorycrafting.func_70301_a(i);
            if (offer == null) continue;
            for (int j = 0; j < unmatched.size(); ++j) {
                if (!((IRecipeInput)unmatched.get(j)).matches(offer)) continue;
                outputCharge += ElectricItem.manager.getCharge(offer);
                unmatched.remove(j);
                continue block1;
            }
            return null;
        }
        if (!unmatched.isEmpty()) {
            return null;
        }
        ItemStack ret = this.output.func_77946_l();
        Item item = ret.func_77973_b();
        ElectricItem.manager.charge(ret, outputCharge, Integer.MAX_VALUE, true, false);
        if (item instanceof IFluidContainerItem) {
            StackUtil.getOrCreateNbtData(ret);
        }
        return ret;
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean canShow() {
        return AdvRecipe.canShow(this.input, this.output, this.hidden);
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return this.consuming ? new ItemStack[inv.func_70302_i_()] : ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

