/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.upgrade;

import ic2.api.upgrade.IAugmentationUpgrade;
import ic2.api.upgrade.IEnergyStorageUpgrade;
import ic2.api.upgrade.IProcessingUpgrade;
import ic2.api.upgrade.IRedstoneSensitiveUpgrade;
import ic2.api.upgrade.ITransformerUpgrade;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class UpgradeBridge {
    private static final Map<UpgradableProperty, ic2.api.upgrade.UpgradableProperty> CONVERSION = UpgradeBridge.getConversionMap();
    private static final Map<Class<? extends IUpgradableBlock>, Method> FUNCTION_MAP = new IdentityHashMap<Class<? extends IUpgradableBlock>, Method>();

    public static Iterator<ItemStack> makeSafeIterator(final InvSlotUpgrade slot) {
        return new Iterator<ItemStack>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < slot.size();
            }

            @Override
            public ItemStack next() {
                ItemStack stack;
                if (this.idx >= slot.size()) {
                    throw new NoSuchElementException();
                }
                if ((stack = slot.get(this.idx++)) != null) {
                    stack = stack.func_77946_l();
                    assert (stack.func_77973_b() instanceof ic2.api.upgrade.IUpgradeItem);
                    stack.func_150996_a((Item)new WrappingUpgrade((ic2.api.upgrade.IUpgradeItem)stack.func_77973_b()));
                }
                return stack;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            class WrappingUpgrade
            extends Item
            implements IUpgradeItem {
                final ic2.api.upgrade.IUpgradeItem item;

                public WrappingUpgrade(ic2.api.upgrade.IUpgradeItem item) {
                    this.item = item;
                }

                @Override
                public boolean isSuitableFor(ItemStack stack, Set<UpgradableProperty> types) {
                    return this.item.isSuitableFor(stack, UpgradeBridge.convert(types));
                }

                @Override
                public int getAugmentation(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IAugmentationUpgrade ? ((IAugmentationUpgrade)this.item).getAugmentation(stack, parent) : 0;
                }

                @Override
                public int getExtraProcessTime(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IProcessingUpgrade ? ((IProcessingUpgrade)this.item).getExtraProcessTime(stack, parent) : 0;
                }

                @Override
                public double getProcessTimeMultiplier(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IProcessingUpgrade ? ((IProcessingUpgrade)this.item).getProcessTimeMultiplier(stack, parent) : 1.0;
                }

                @Override
                public int getExtraEnergyDemand(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IProcessingUpgrade ? ((IProcessingUpgrade)this.item).getExtraEnergyDemand(stack, parent) : 0;
                }

                @Override
                public double getEnergyDemandMultiplier(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IProcessingUpgrade ? ((IProcessingUpgrade)this.item).getEnergyDemandMultiplier(stack, parent) : 1.0;
                }

                @Override
                public int getExtraEnergyStorage(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IEnergyStorageUpgrade ? ((IEnergyStorageUpgrade)this.item).getExtraEnergyStorage(stack, parent) : 0;
                }

                @Override
                public double getEnergyStorageMultiplier(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IEnergyStorageUpgrade ? ((IEnergyStorageUpgrade)this.item).getEnergyStorageMultiplier(stack, parent) : 1.0;
                }

                @Override
                public int getExtraTier(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof ITransformerUpgrade ? ((ITransformerUpgrade)this.item).getExtraTier(stack, parent) : 0;
                }

                @Override
                public boolean modifiesRedstoneInput(ItemStack stack, IUpgradableBlock parent) {
                    return this.item instanceof IRedstoneSensitiveUpgrade ? ((IRedstoneSensitiveUpgrade)this.item).modifiesRedstoneInput(stack, parent) : false;
                }

                @Override
                public int getRedstoneInput(ItemStack stack, IUpgradableBlock parent, int externalInput) {
                    return this.item instanceof IRedstoneSensitiveUpgrade ? ((IRedstoneSensitiveUpgrade)this.item).getRedstoneInput(stack, parent, externalInput) : externalInput;
                }

                @Override
                public boolean onTick(ItemStack stack, IUpgradableBlock parent) {
                    return this.item.onTick(stack, parent);
                }

                @Override
                public void onProcessEnd(ItemStack stack, IUpgradableBlock parent, List<ItemStack> output) {
                    this.item.onProcessEnd(stack, parent, output);
                }
            }
        };
    }

    public static Set<ic2.api.upgrade.UpgradableProperty> getUpgradableProperties(IUpgradableBlock base) {
        try {
            return base.getUpgradableProperties();
        }
        catch (Exception e) {
            Set upgrades;
            Method getUpgrades = FUNCTION_MAP.get(base.getClass());
            if (getUpgrades == null) {
                getUpgrades = ReflectionUtil.getMethod(base.getClass(), new String[]{"getUpgradableProperties"}, new Class[0]);
                if (getUpgrades != null && getUpgrades.getReturnType() == UpgradableProperty.class) {
                    FUNCTION_MAP.put(base.getClass(), getUpgrades);
                } else {
                    throw new IllegalStateException("Cannot find function!");
                }
            }
            try {
                upgrades = (Set)getUpgrades.invoke((Object)base, new Object[0]);
            }
            catch (Exception oops) {
                throw new RuntimeException("And we've failed.", oops);
            }
            return UpgradeBridge.convert(upgrades);
        }
    }

    static Set<ic2.api.upgrade.UpgradableProperty> convert(Set<UpgradableProperty> upgrades) {
        EnumSet<ic2.api.upgrade.UpgradableProperty> ret = EnumSet.noneOf(ic2.api.upgrade.UpgradableProperty.class);
        for (UpgradableProperty upgrade : upgrades) {
            ret.add(CONVERSION.get((Object)upgrade));
        }
        return ret;
    }

    private static Map<UpgradableProperty, ic2.api.upgrade.UpgradableProperty> getConversionMap() {
        EnumMap<UpgradableProperty, ic2.api.upgrade.UpgradableProperty> ret = new EnumMap<UpgradableProperty, ic2.api.upgrade.UpgradableProperty>(UpgradableProperty.class);
        UpgradableProperty[] oldValues = UpgradableProperty.values();
        ic2.api.upgrade.UpgradableProperty[] newValues = ic2.api.upgrade.UpgradableProperty.values();
        assert (oldValues.length == newValues.length);
        for (int i = 0; i < oldValues.length; ++i) {
            ret.put(oldValues[i], newValues[i]);
        }
        return ret;
    }
}

