/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrade;

import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.gui.GuiElement;
import ic2.core.gui.IClickHandler;
import ic2.core.gui.MouseButton;
import ic2.core.gui.VanillaButton;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.DynamicHandHeldContainer;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiConditionProvider;
import ic2.core.gui.dynamic.IHolographicSlotProvider;
import ic2.core.item.tool.HandHeldInventory;
import ic2.core.item.upgrade.HandHeldMeta;
import ic2.core.item.upgrade.ItemUpgradeModule;
import ic2.core.network.GuiSynced;
import ic2.core.ref.ItemName;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.xml.sax.SAXException;

public class HandHeldAdvancedUpgrade
extends HandHeldInventory
implements IHolographicSlotProvider,
IGuiConditionProvider {
    @GuiSynced
    protected boolean meta;
    @GuiSynced
    protected boolean nbt;
    @GuiSynced
    protected boolean energy;
    protected static final int META_GUI = 0;
    protected static final int NBT_GUI = 1;
    protected static final int ENERGY_GUI = 2;
    private static final ResourceLocation GUI_XML = new ResourceLocation("ic2", "guidef/advanced_upgrade.xml");
    private static final String TRANSLATION_NAME = ItemName.upgrade.getItemStack(ItemUpgradeModule.UpgradeType.advanced_ejector).func_77977_a();

    public HandHeldAdvancedUpgrade(EntityPlayer player, ItemStack containerStack) {
        super(player, containerStack, 9);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(containerStack);
        this.meta = HandHeldAdvancedUpgrade.readTag(nbt, "meta");
        this.nbt = HandHeldAdvancedUpgrade.readTag(nbt, "nbt");
        this.energy = HandHeldAdvancedUpgrade.readTag(nbt, "energy");
    }

    @Override
    protected void save() {
        super.save();
        if (IC2.platform.isSimulating()) {
            NBTTagCompound nbt = this.containerStack.func_77978_p();
            assert (nbt != null);
            HandHeldAdvancedUpgrade.writeTag(nbt, "meta", this.meta);
            HandHeldAdvancedUpgrade.writeTag(nbt, "nbt", this.nbt);
            HandHeldAdvancedUpgrade.writeTag(nbt, "energy", this.energy);
        }
    }

    public static NBTTagCompound getTag(NBTTagCompound nbt, String name) {
        return nbt.func_74775_l(name + "Settings");
    }

    protected static boolean readTag(NBTTagCompound nbt, String name) {
        return HandHeldAdvancedUpgrade.getTag(nbt, name).func_74767_n("active");
    }

    protected static void writeTag(NBTTagCompound nbt, String name, boolean active) {
        NBTTagCompound tag = HandHeldAdvancedUpgrade.getTag(nbt, name);
        tag.func_74757_a("active", active);
        nbt.func_74782_a(name + "Settings", (NBTBase)tag);
    }

    static IHasGui delegate(EntityPlayer player, ItemStack stack, int ID) {
        switch (ID) {
            case 0: {
                return new HandHeldMeta(new HandHeldAdvancedUpgrade(player, stack));
            }
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
        }
        IC2.log.warn(LogCategory.Network, "Unexpected delegate ID: " + ID);
        return null;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return DynamicHandHeldContainer.create(this, player, this.getNode());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        final DynamicGui<ContainerBase<HandHeldAdvancedUpgrade>> gui = DynamicGui.create(this, player, this.getNode());
        if (Util.inDev()) {
            gui.addElement((GuiElement<?>)((VanillaButton)new VanillaButton(gui, 83, 23, 10, 10, new IClickHandler(){

                @Override
                public void onClick(MouseButton button) {
                    IC2.network.get(false).sendContainerEvent((ContainerBase<?>)((Object)gui.getContainer()), "metaDev");
                    ((HandHeldInventory)((ContainerBase)((Object)gui.getContainer())).base).onEvent("metaDev");
                }
            }).withText("M")).withTooltip("Open advanced meta GUI"));
        }
        return gui;
    }

    protected GuiParser.GuiNode getNode() {
        try {
            return GuiParser.parse(GUI_XML, HandHeldAdvancedUpgrade.class);
        }
        catch (SAXException e) {
            throw new RuntimeException("XML Exception opening Advanced Upgrade GUI", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception opening Advanced Upgrade GUI", e);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_70005_c_() {
        return TRANSLATION_NAME;
    }

    EntityPlayer getPlayer() {
        return this.player;
    }

    ItemStack getContainerStack() {
        return this.containerStack;
    }

    @Override
    public ItemStack[] getStacksForName(String name) {
        if ("filter".equals(name)) {
            return this.inventory;
        }
        throw new IllegalArgumentException("Unexpected stack array name requested: " + name);
    }

    @Override
    public boolean getGuiState(String name) {
        if ("meta".equals(name)) {
            return this.meta;
        }
        if ("nbt".equals(name)) {
            return this.nbt;
        }
        if ("energy".equals(name)) {
            return this.energy || this.nbt;
        }
        throw new IllegalArgumentException("Unexpected conditional name requested: " + name);
    }

    @Override
    public void onEvent(String event) {
        if (event.startsWith("meta")) {
            if ("meta".equals(event)) {
                this.meta = !this.meta;
            } else if (Util.inDev() && "metaDev".equals(event)) {
                if (!this.player.func_130014_f_().field_72995_K) {
                    IC2.platform.launchSubGui(this.player, new HandHeldMeta(this), 0);
                }
            } else {
                super.onEvent(event);
            }
        } else if ("nbt".equals(event)) {
            this.nbt = !this.nbt;
        } else if ("energy".equals(event)) {
            this.energy = !this.energy;
        } else {
            super.onEvent(event);
        }
    }
}

