/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotContainer;
import ic2.core.util.StackUtil;
import ic2.core.util.StrictItemComparableItemStack;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;

public class InvSlotCrafting
extends InvSlot {
    protected IRecipe recipe = null;
    protected ItemStack recipeOutput = null;
    protected boolean shouldCraft = false;
    protected int craftingHash;
    protected boolean skipHash;
    protected boolean keepSkipping;
    public final InvSlotContainer containerInput = new InvSlotContainer(this, "containersIn", 9, InvSlot.InvSide.NOTSIDE);
    protected final TIntIntMap containerSubSlots = new TIntIntHashMap();
    public final InventoryCrafting stackSyntheticClone = new InventoryCrafting(null, 0, 0){

        private boolean validIndex(int index) {
            return index >= 0 && index < this.func_70302_i_();
        }

        private boolean isContainerSlot(int index) {
            return InvSlotCrafting.this.containerSubSlots.containsKey(index);
        }

        public int func_70302_i_() {
            return InvSlotCrafting.this.size();
        }

        public ItemStack func_70463_b(int row, int column) {
            return row >= 0 && row < 3 && column >= 0 && column <= 3 ? this.func_70301_a(row + column * 3) : null;
        }

        private ItemStack get(int index) {
            if (this.isContainerSlot(index)) {
                return InvSlotCrafting.this.containerInput.get(InvSlotCrafting.this.containerSubSlots.get(index));
            }
            return InvSlotCrafting.this.get(index);
        }

        private void put(int index, ItemStack stack) {
            if (this.isContainerSlot(index)) {
                InvSlotCrafting.this.containerInput.put(InvSlotCrafting.this.containerSubSlots.get(index), stack);
            } else {
                InvSlotCrafting.this.forcePut(index, stack);
            }
        }

        public ItemStack func_70301_a(int index) {
            return !this.validIndex(index) ? null : this.get(index);
        }

        public ItemStack func_70304_b(int index) {
            if (this.validIndex(index)) {
                ItemStack stack = this.get(index);
                this.put(index, null);
                return stack;
            }
            return null;
        }

        public ItemStack func_70298_a(int index, int count) {
            if (this.validIndex(index) && this.get(index) != null && count > 0) {
                ItemStack stack = this.get(index).func_77979_a(count);
                if (this.get((int)index).field_77994_a == 0) {
                    this.put(index, null);
                }
                InvSlotCrafting.this.onChanged();
                return stack;
            }
            return null;
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (this.validIndex(index)) {
                this.put(index, stack);
            }
        }

        public void func_174888_l() {
            this.func_174888_l();
        }

        public int func_174922_i() {
            return 3;
        }

        public int func_174923_h() {
            return 3;
        }

        public int hashCode() {
            int ret = 0;
            for (ItemStack stack : InvSlotCrafting.this) {
                if (stack == null) continue;
                int hash = System.identityHashCode(stack.func_77973_b());
                hash = hash * 31 + StackUtil.getRawMeta(stack);
                hash = hash * 61 + stack.field_77994_a;
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null && !nbt.func_82582_d()) {
                    hash = hash * 127 + nbt.hashCode();
                }
                ret += hash;
            }
            return ret;
        }
    };

    public InvSlotCrafting(TileEntityInventory base, InvSlot.Access access) {
        super(base, "crafting", access, 9);
    }

    @Override
    public boolean accepts(ItemStack stack) {
        for (ItemStack slotStack : this) {
            if (!StackUtil.canStack(slotStack) || !StackUtil.checkItemEqualityStrict(slotStack, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        this.skipAllHash();
        super.readFromNbt(nbt);
        this.watchHash();
    }

    public void forcePut(int index, ItemStack content) {
        this.skipNextHash();
        super.put(index, content);
    }

    @Override
    public void put(int index, ItemStack content) {
        if (content == null) {
            this.forcePut(index, null);
        } else if (this.containerSubSlots.containsKey(index)) {
            this.containerInput.put(this.containerSubSlots.get(index), content);
        } else {
            ItemStack existing = this.get(index);
            if (content != existing) {
                if (existing != null) {
                    content.field_77994_a -= existing.field_77994_a;
                }
                if (!StackUtil.balanceStacks((IInventory)this.stackSyntheticClone, content).isEmpty()) {
                    this.onChanged();
                }
            }
        }
    }

    @Override
    public void onChanged() {
        super.onChanged();
        if (this.recipe == null || !this.recipe.func_77569_a(this.stackSyntheticClone, this.base.func_145831_w())) {
            this.containerSubSlots.clear();
            boolean found = false;
            for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!recipe.func_77569_a(this.stackSyntheticClone, this.base.func_145831_w())) continue;
                this.recipe = recipe;
                found = true;
                break;
            }
            if (!found) {
                this.recipe = null;
            }
        }
        if (this.recipe != null) {
            if (IC2.platform.isSimulating()) {
                this.containerSubSlots.clear();
                boolean finalSet = false;
                for (int slot = 0; slot < this.size(); ++slot) {
                    ItemStack stack = this.get(slot);
                    if (stack == null) continue;
                    if (InvSlotContainer.isSingleContainer(stack)) {
                        if (!this.containerInput.hasOthers(stack)) {
                            finalSet = true;
                            break;
                        }
                        this.containerSubSlots.put(slot, this.containerInput.findOther(stack));
                        continue;
                    }
                    if (stack.field_77994_a != 1) continue;
                    finalSet = true;
                    break;
                }
                this.shouldCraft = !finalSet;
                this.recipeOutput = this.recipe.func_77572_b(this.stackSyntheticClone);
                int newHash = this.stackSyntheticClone.hashCode();
                if (newHash != this.craftingHash) {
                    this.craftingHash = newHash;
                    if (!this.skipHash) {
                        HashMap<StrictItemComparableItemStack, TIntArrayList> slotTypeList = new HashMap<StrictItemComparableItemStack, TIntArrayList>();
                        int lengthIfAllDifferent = 0;
                        for (int slot = 0; slot < this.size(); ++slot) {
                            ItemStack stack = this.get(slot);
                            if (stack == null) continue;
                            ++lengthIfAllDifferent;
                            StrictItemComparableItemStack key = new StrictItemComparableItemStack(stack, false);
                            if (!slotTypeList.containsKey(key)) {
                                slotTypeList.put(key, new TIntArrayList(new int[]{slot}));
                                continue;
                            }
                            ((TIntList)slotTypeList.get(key)).add(slot);
                        }
                        if (lengthIfAllDifferent != slotTypeList.size()) {
                            for (TIntList slots : slotTypeList.values()) {
                                HashSet<ItemStack> stacksToBalance = new HashSet<ItemStack>(slots.size() * 2, 0.5f);
                                int minSize = 64;
                                int firstSize = 0;
                                TIntIterator it = slots.iterator();
                                while (it.hasNext()) {
                                    ItemStack stack = this.get(it.next());
                                    stacksToBalance.add(stack);
                                    if (stack.field_77994_a < minSize) {
                                        minSize = stack.field_77994_a;
                                    }
                                    if (firstSize <= -1) continue;
                                    if (firstSize == 0) {
                                        firstSize = stack.field_77994_a;
                                        continue;
                                    }
                                    if (firstSize == stack.field_77994_a) continue;
                                    firstSize = -1;
                                }
                                if (firstSize > 0) continue;
                                int extra = 0;
                                for (ItemStack stack : stacksToBalance) {
                                    extra += stack.field_77994_a - minSize;
                                    stack.field_77994_a = minSize;
                                }
                                assert (stacksToBalance.size() > 0);
                                int each = extra / stacksToBalance.size();
                                int spare = extra - each * stacksToBalance.size();
                                for (ItemStack stack : stacksToBalance) {
                                    stack.field_77994_a += each;
                                    if (spare <= 0) continue;
                                    ++stack.field_77994_a;
                                    --spare;
                                }
                            }
                        }
                    }
                }
                if (!this.keepSkipping) {
                    this.skipHash = false;
                }
            }
        } else {
            this.recipeOutput = null;
            this.shouldCraft = false;
            this.craftingHash = 0;
        }
    }

    public void skipNextHash() {
        this.skipHash = true;
        this.keepSkipping = false;
    }

    public void skipAllHash() {
        this.skipHash = true;
        this.keepSkipping = true;
    }

    public void watchHash() {
        this.keepSkipping = false;
        this.skipHash = false;
    }

    public boolean hasValidRecipe() {
        return this.recipe != null;
    }

    public boolean shouldCraft() {
        return this.shouldCraft;
    }

    public ItemStack getRecipeOutput() {
        return this.hasValidRecipe() ? this.recipeOutput : null;
    }

    public ItemStack[] getRecipeOutputRemains() {
        assert (this.hasValidRecipe());
        return this.recipe.func_179532_b(this.stackSyntheticClone);
    }
}

