/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.item.upgrade.ItemUpgradeModule;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class InvSlotProcessableGeneric
extends InvSlotProcessable {
    public IMachineRecipeManager recipeManager;

    public InvSlotProcessableGeneric(TileEntityInventory base1, String name1, int count, IMachineRecipeManager recipeManager1) {
        super(base1, name1, count);
        this.recipeManager = recipeManager1;
    }

    @Override
    public boolean accepts(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemUpgradeModule) {
            return false;
        }
        ItemStack tmp = StackUtil.copyWithSize(stack, Integer.MAX_VALUE);
        return this.getOutputFor(tmp, false, true) != null;
    }

    @Override
    public RecipeOutput process() {
        ItemStack input = this.get();
        if (input == null && !this.allowEmptyInput()) {
            return null;
        }
        RecipeOutput output = this.getOutputFor(input, false, false);
        if (output == null) {
            return null;
        }
        ArrayList<ItemStack> itemsCopy = new ArrayList<ItemStack>(output.items.size());
        for (ItemStack stack : output.items) {
            itemsCopy.add(stack.func_77946_l());
        }
        return new RecipeOutput(output.metadata, itemsCopy);
    }

    @Override
    public void consume() {
        ItemStack input = this.get();
        if (input == null && !this.allowEmptyInput()) {
            throw new IllegalStateException("consume from empty slot");
        }
        RecipeOutput output = this.getOutputFor(input, true, false);
        if (output == null) {
            throw new IllegalStateException("consume without a processing result");
        }
        if (input != null && input.field_77994_a <= 0) {
            this.put(null);
        }
    }

    public void setRecipeManager(IMachineRecipeManager recipeManager1) {
        this.recipeManager = recipeManager1;
    }

    protected RecipeOutput getOutputFor(ItemStack input, boolean adjustInput, boolean forAccept) {
        return this.recipeManager.getOutputFor(input, adjustInput);
    }

    protected boolean allowEmptyInput() {
        return false;
    }
}

