/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.recipe.BasicMachineRecipeManager;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCompressor
extends TileEntityStandardMachine {
    protected boolean usingPumpRecipe;
    protected final Set<TileEntityPump> pumps = new HashSet<TileEntityPump>(12, 0.5f);

    public TileEntityCompressor() {
        super(2, 300, 1);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 1, Recipes.compressor);
    }

    public static void init() {
        Recipes.compressor = new BasicMachineRecipeManager();
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        this.findPumps();
    }

    @Override
    protected void onNeighborChange(Block neighbor) {
        super.onNeighborChange(neighbor);
        this.findPumps();
    }

    protected void findPumps() {
        World world = this.func_145831_w();
        this.pumps.clear();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity te = world.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (!(te instanceof TileEntityPump)) continue;
            this.pumps.add((TileEntityPump)te);
        }
    }

    @Override
    public RecipeOutput getOutput() {
        this.usingPumpRecipe = false;
        RecipeOutput output = super.getOutput();
        if (output != null) {
            return output;
        }
        if (!this.pumps.isEmpty() && this.inputSlot.isEmpty() && this.outputSlot.canAdd(new ItemStack(Items.field_151126_ay))) {
            FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
            for (TileEntityPump pump : this.pumps) {
                FluidStack amount = pump.drain(EnumFacing.UP, fluid, false);
                if (amount != null) {
                    assert (amount.getFluid() == FluidRegistry.WATER);
                    fluid.amount -= amount.amount;
                }
                if (fluid.amount > 0) continue;
                this.usingPumpRecipe = true;
                output = new RecipeOutput(null, new ItemStack(Items.field_151126_ay));
                break;
            }
        }
        return output;
    }

    @Override
    public void operateOnce(RecipeOutput output, List<ItemStack> processResult) {
        if (this.usingPumpRecipe) {
            FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
            for (TileEntityPump pump : this.pumps) {
                FluidStack amount = pump.drain(EnumFacing.UP, fluid, true);
                if (amount != null && amount.getFluid() == FluidRegistry.WATER) {
                    fluid.amount -= amount.amount;
                }
                if (fluid.amount > 0) continue;
                break;
            }
            this.outputSlot.add(processResult);
        } else {
            super.operateOnce(output, processResult);
        }
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/CompressorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }
}

