/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.IItemHudInfo;
import ic2.core.init.Localization;
import ic2.core.item.ItemIC2;
import ic2.core.ref.FluidName;
import ic2.core.ref.IMultiItem;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public abstract class ItemIC2FluidContainer
extends ItemIC2
implements IMultiItem<FluidName>,
IFluidContainerItem,
IItemHudInfo {
    protected final int capacity;

    public ItemIC2FluidContainer(ItemName name, int capacity) {
        super(name);
        this.capacity = capacity;
        this.func_77627_a(true);
    }

    @Override
    public ItemStack getItemStack(FluidName type) {
        ItemStack ret = new ItemStack((Item)this);
        if (type == null) {
            return ret;
        }
        if (this.fill(ret, new FluidStack(type.getInstance(), Integer.MAX_VALUE), true) > 0) {
            return ret;
        }
        return null;
    }

    @Override
    public ItemStack getItemStack(String variant) {
        if (variant == null || variant.isEmpty()) {
            return new ItemStack((Item)this);
        }
        Fluid fluid = FluidRegistry.getFluid((String)variant);
        if (fluid == null) {
            return null;
        }
        ItemStack ret = new ItemStack((Item)this);
        if (this.fill(ret, new FluidStack(fluid, Integer.MAX_VALUE), true) > 0) {
            return ret;
        }
        return null;
    }

    @Override
    public String getVariant(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null stack");
        }
        if (stack.func_77973_b() != this) {
            throw new IllegalArgumentException("The stack " + stack + " doesn't match " + this);
        }
        FluidStack fs = this.getFluid(stack);
        if (fs == null || fs.getFluid() == null) {
            return null;
        }
        return fs.getFluid().getName();
    }

    @Override
    public Set<FluidName> getAllTypes() {
        return EnumSet.allOf(FluidName.class);
    }

    @Override
    public Set<ItemStack> getAllStacks() {
        HashSet<ItemStack> ret = new HashSet<ItemStack>();
        ret.add(new ItemStack((Item)this));
        Iterator iterator = FluidRegistry.getRegisteredFluids().values().iterator();
        while (iterator.hasNext()) {
            ItemStack filled = new ItemStack((Item)this);
            Fluid fluid = (Fluid)iterator.next();
            if (this.fill(filled, new FluidStack(fluid, Integer.MAX_VALUE), true) <= 0) continue;
            ret.add(filled);
        }
        return ret;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!this.hasContainerItem(stack)) {
            return super.getContainerItem(stack);
        }
        ItemStack ret = StackUtil.copyWithSize(stack, 1);
        this.drain(ret, Integer.MAX_VALUE, true);
        return ret;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            tooltip.add("< " + fs.getLocalizedName() + ", " + fs.amount + " mB >");
        } else {
            tooltip.add(Localization.translate("ic2.item.FluidContainer.Empty"));
        }
    }

    @Override
    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        LinkedList<String> info = new LinkedList<String>();
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            info.add("< " + FluidRegistry.getFluidName((FluidStack)fs) + ", " + fs.amount + " mB >");
        } else {
            info.add(Localization.translate("ic2.item.FluidContainer.Empty"));
        }
        return info;
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("fluid");
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
    }

    public boolean isEmpty(ItemStack stack) {
        return this.getFluid(stack) == null;
    }

    public int getCapacity(ItemStack container) {
        return this.capacity;
    }

    public abstract boolean canfill(Fluid var1);

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        if (!this.canfill(resource.getFluid())) {
            return 0;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = nbt.func_74775_l("fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            fs = new FluidStack(resource, 0);
        }
        if (!fs.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(this.capacity - fs.amount, resource.amount);
        if (doFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(fluidTag);
            nbt.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        return amount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        if (stack.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = nbt.func_74775_l("fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            return null;
        }
        maxDrain = Math.min(fs.amount, maxDrain);
        if (doDrain) {
            fs.amount -= maxDrain;
            if (fs.amount <= 0) {
                nbt.func_82580_o("fluid");
            } else {
                fs.writeToNBT(fluidTag);
                nbt.func_74782_a("fluid", (NBTBase)fluidTag);
            }
        }
        return new FluidStack(fs, maxDrain);
    }
}

