/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlot;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InvSlotUpgrade
extends InvSlot {
    private static final int maxStackSize = 64;
    public int augmentation;
    public int extraProcessTime;
    public double processTimeMultiplier;
    public int extraEnergyDemand;
    public double energyDemandMultiplier;
    public int extraEnergyStorage;
    public double energyStorageMultiplier;
    public int extraTier;
    private List<Redstone.IRedstoneModifier> redstoneModifiers = Collections.emptyList();

    public InvSlotUpgrade(TileEntityInventory base1, String name1, int count) {
        super(base1, name1, InvSlot.Access.NONE, count);
        if (!(base1 instanceof IUpgradableBlock)) {
            throw new IllegalArgumentException("Base needs to be an IUpgradableBlock.");
        }
        this.resetRates();
    }

    @Override
    public boolean accepts(ItemStack stack) {
        Item rawItem = stack.func_77973_b();
        if (!(rawItem instanceof IUpgradeItem)) {
            return false;
        }
        IUpgradeItem item = (IUpgradeItem)rawItem;
        return item.isSuitableFor(stack, ((IUpgradableBlock)((Object)this.base)).getUpgradableProperties());
    }

    @Override
    public void onChanged() {
        this.resetRates();
        IUpgradableBlock block = (IUpgradableBlock)((Object)this.base);
        ArrayList<Redstone.IRedstoneModifier> newRedstoneModifiers = new ArrayList<Redstone.IRedstoneModifier>();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (StackUtil.isEmpty(itemStack) || !this.accepts(itemStack)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)itemStack.func_77973_b();
            int size = StackUtil.getSize(itemStack);
            this.augmentation += upgrade.getAugmentation(itemStack, block) * size;
            this.extraProcessTime += upgrade.getExtraProcessTime(itemStack, block) * size;
            this.processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(itemStack, block), size);
            this.extraEnergyDemand += upgrade.getExtraEnergyDemand(itemStack, block) * size;
            this.energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(itemStack, block), size);
            this.extraEnergyStorage += upgrade.getExtraEnergyStorage(itemStack, block) * size;
            this.energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(itemStack, block), size);
            this.extraTier += upgrade.getExtraTier(itemStack, block) * size;
            if (!upgrade.modifiesRedstoneInput(itemStack, block)) continue;
            newRedstoneModifiers.add(new UpgradeRedstoneModifier(upgrade, itemStack, block));
        }
        for (TileEntityComponent tileEntityComponent : this.base.getComponents()) {
            if (!(tileEntityComponent instanceof Redstone)) continue;
            Redstone rs = (Redstone)tileEntityComponent;
            rs.removeRedstoneModifiers(this.redstoneModifiers);
            rs.addRedstoneModifiers(newRedstoneModifiers);
            rs.update();
        }
        this.redstoneModifiers = newRedstoneModifiers.isEmpty() ? Collections.emptyList() : newRedstoneModifiers;
    }

    private void resetRates() {
        this.augmentation = 0;
        this.extraProcessTime = 0;
        this.processTimeMultiplier = 1.0;
        this.extraEnergyDemand = 0;
        this.energyDemandMultiplier = 1.0;
        this.extraEnergyStorage = 0;
        this.energyStorageMultiplier = 1.0;
        this.extraTier = 0;
    }

    public int getOperationsPerTick(int defaultOperationLength) {
        if (defaultOperationLength == 0) {
            return 64;
        }
        return this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
    }

    public int getOperationLength(int defaultOperationLength) {
        if (defaultOperationLength == 0) {
            return 1;
        }
        double stackOpLen = this.getStackOpLen(defaultOperationLength);
        int opsPerTick = this.getOpsPerTick(stackOpLen);
        return Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
    }

    private double getStackOpLen(int defaultOperationLength) {
        return ((double)defaultOperationLength + (double)this.extraProcessTime) * 64.0 * this.processTimeMultiplier;
    }

    private int getOpsPerTick(double stackOpLen) {
        return (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
    }

    public int getEnergyDemand(int defaultEnergyDemand) {
        return InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
    }

    public int getEnergyStorage(int defaultEnergyStorage, int defaultOperationLength, int defaultEnergyDemand) {
        int opLen = this.getOperationLength(defaultOperationLength);
        int energyDemand = this.getEnergyDemand(defaultEnergyDemand);
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage + opLen * energyDemand, this.energyStorageMultiplier);
    }

    public int getTier(int defaultTier) {
        return InvSlotUpgrade.applyModifier(defaultTier, this.extraTier, 1.0);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static class UpgradeRedstoneModifier
    implements Redstone.IRedstoneModifier {
        private final IUpgradeItem upgrade;
        private final ItemStack stack;
        private final IUpgradableBlock block;

        UpgradeRedstoneModifier(IUpgradeItem upgrade, ItemStack stack, IUpgradableBlock block) {
            this.upgrade = upgrade;
            this.stack = stack.func_77946_l();
            this.block = block;
        }

        @Override
        public int getRedstoneInput(int redstoneInput) {
            return this.upgrade.getRedstoneInput(this.stack, this.block, redstoneInput);
        }
    }
}

