/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.energy.EnergyNet;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.wiring.ContainerTransformer;
import ic2.core.block.wiring.GuiTransformer;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityTransformer
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener {
    private double inputflow = 0.0;
    private double outputflow = 0.0;
    private final int defaultTier;
    protected final Energy energy;
    public Mode redstoneMode = Mode.redstone;
    public Mode transformMode = Mode.notset;

    public TileEntityTransformer(int tier) {
        this.defaultTier = tier;
        this.energy = this.addComponent(new Energy(this, EnergyNet.instance.getPowerFromTier(tier) * 8.0, Collections.<EnumFacing>emptySet(), Collections.<EnumFacing>emptySet(), tier, tier, true).setMultiSource(true));
    }

    public String getType() {
        switch (this.energy.getSourceTier()) {
            case 1: {
                return "LV";
            }
            case 2: {
                return "MV";
            }
            case 3: {
                return "HV";
            }
            case 4: {
                return "EV";
            }
        }
        return "";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redstoneMode = Mode.values()[nbt.func_74762_e("mode")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("mode", this.redstoneMode.ordinal());
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.updateRedstone();
        }
    }

    public Mode getMode() {
        return this.redstoneMode;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event >= Mode.values().length || event < 0) {
            return;
        }
        this.redstoneMode = Mode.values()[event];
        this.updateRedstone();
        this.outputflow = EnergyNet.instance.getPowerFromTier(this.energy.getSourceTier());
        this.inputflow = EnergyNet.instance.getPowerFromTier(this.energy.getSinkTier());
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        this.updateRedstone();
    }

    public void updateRedstone() {
        Mode newMode;
        switch (this.redstoneMode) {
            case redstone: {
                newMode = this.field_145850_b.func_175640_z(this.field_174879_c) ? Mode.stepup : Mode.stepdown;
                break;
            }
            case stepdown: 
            case stepup: {
                newMode = this.redstoneMode;
                break;
            }
            default: {
                return;
            }
        }
        this.energy.setEnabled(true);
        if (!this.transformMode.valid || newMode != this.transformMode) {
            this.transformMode = newMode;
            this.setActive(this.transformMode.enabled);
            if (this.transformMode.enabled) {
                this.energy.setDirections(EnumSet.complementOf(EnumSet.of(this.getFacing())), EnumSet.of(this.getFacing()));
                this.energy.setSourceTier(this.defaultTier + 1);
                this.energy.setSinkTier(this.defaultTier);
                this.energy.setPacketOutput(1);
            } else {
                this.energy.setDirections(EnumSet.of(this.getFacing()), EnumSet.complementOf(EnumSet.of(this.getFacing())));
                this.energy.setSourceTier(this.defaultTier);
                this.energy.setSinkTier(this.defaultTier + 1);
                this.energy.setPacketOutput(4);
            }
        }
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        switch (this.transformMode) {
            case stepdown: {
                this.energy.setDirections(EnumSet.of(this.getFacing()), EnumSet.complementOf(EnumSet.of(this.getFacing())));
                break;
            }
            case stepup: {
                this.energy.setDirections(EnumSet.complementOf(EnumSet.of(this.getFacing())), EnumSet.of(this.getFacing()));
                break;
            }
        }
    }

    public ContainerBase<TileEntityTransformer> getGuiContainer(EntityPlayer player) {
        return new ContainerTransformer(player, this, 219);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiTransformer(new ContainerTransformer(player, this, 219));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public double getinputflow() {
        if (!this.transformMode.enabled) {
            return this.inputflow;
        }
        return this.outputflow;
    }

    public double getoutputflow() {
        if (this.transformMode.enabled) {
            return this.inputflow;
        }
        return this.outputflow;
    }

    public static enum Mode {
        redstone(false, false),
        stepdown(true, false),
        stepup(true, true),
        notset(false, false);

        private final boolean valid;
        private final boolean enabled;

        private Mode(boolean valid, boolean enabled) {
            this.valid = valid;
            this.enabled = enabled;
        }
    }
}

