/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.block.BlockScaffold;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.ItemBooze;
import ic2.core.item.type.CropResItemType;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityBarrel
extends TileEntityBlock {
    private int type = 0;
    private int boozeAmount = 0;
    private int age = 0;
    private boolean opened;
    private byte hopsCount = 0;
    private byte wheatCount = 0;
    private byte solidRatio = 0;
    private byte hopsRatio = 0;
    private byte timeRatio = 0;

    public TileEntityBarrel() {
    }

    public TileEntityBarrel(int value) {
        this.type = ItemBooze.getTypeOfValue(value);
        if (this.type > 0) {
            this.boozeAmount = ItemBooze.getAmountOfValue(value);
        }
        if (this.type == 1) {
            this.opened = true;
            this.hopsRatio = (byte)ItemBooze.getHopsRatioOfBeerValue(value);
            this.solidRatio = (byte)ItemBooze.getSolidRatioOfBeerValue(value);
            this.timeRatio = (byte)ItemBooze.getTimeRatioOfBeerValue(value);
        }
        if (this.type == 2) {
            this.opened = false;
            this.age = this.timeNedForRum(this.boozeAmount) * ItemBooze.getProgressOfRumValue(value) / 100;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = nbt.func_74771_c("type");
        this.boozeAmount = nbt.func_74771_c("waterCount");
        this.age = nbt.func_74762_e("age");
        this.opened = nbt.func_74767_n("opened");
        if (this.type == 1) {
            if (!this.opened) {
                this.hopsCount = nbt.func_74771_c("hopsCount");
                this.wheatCount = nbt.func_74771_c("wheatCount");
            }
            this.solidRatio = nbt.func_74771_c("solidRatio");
            this.hopsRatio = nbt.func_74771_c("hopsRatio");
            this.timeRatio = nbt.func_74771_c("timeRatio");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)this.type);
        nbt.func_74774_a("waterCount", (byte)this.boozeAmount);
        nbt.func_74768_a("age", this.age);
        nbt.func_74757_a("opened", this.opened);
        if (this.type == 1) {
            if (!this.opened) {
                nbt.func_74774_a("hopsCount", this.hopsCount);
                nbt.func_74774_a("wheatCount", this.wheatCount);
            }
            nbt.func_74774_a("solidRatio", this.solidRatio);
            nbt.func_74774_a("hopsRatio", this.hopsRatio);
            nbt.func_74774_a("timeRatio", this.timeRatio);
        }
        return nbt;
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (!this.isEmpty() && !this.getActive()) {
            ++this.age;
            if (this.type == 1 && this.timeRatio < 5) {
                int x = this.timeRatio;
                if (x == 4) {
                    x += 2;
                }
                if ((double)this.age >= 24000.0 * Math.pow(3.0, x)) {
                    this.age = 0;
                    this.timeRatio = (byte)(this.timeRatio + 1);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.type == 0 || this.boozeAmount <= 0;
    }

    @Override
    protected boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem == null) {
            return false;
        }
        if (side.func_176740_k() != EnumFacing.Axis.Y && !this.getActive() && StackUtil.consumeFromPlayerHand(player, StackUtil.sameStack(ItemName.treetap.getItemStack()), 1) != null) {
            this.setActive(true);
            if (this.getFacing() != side) {
                this.setFacing(side);
            }
            return true;
        }
        if (!(this.type != 0 && this.type != 1 || this.opened)) {
            FluidStack fs;
            int minAmount = 1000;
            int space = (32 - this.boozeAmount) * minAmount;
            if (player.func_70093_af()) {
                space = Math.min(space, minAmount);
            }
            MutableObject output = new MutableObject();
            if (space >= minAmount && (fs = LiquidUtil.drainContainer(heldItem, FluidRegistry.WATER, space, (MutableObject<ItemStack>)output, LiquidUtil.FluidContainerOutputMode.InPlacePreferred, true)) != null && fs.amount >= minAmount) {
                int amount = fs.amount / minAmount * minAmount;
                fs = LiquidUtil.drainContainer(heldItem, FluidRegistry.WATER, amount, (MutableObject<ItemStack>)output, LiquidUtil.FluidContainerOutputMode.InPlacePreferred, true);
                if (fs.amount != amount) {
                    return false;
                }
                if (output.getValue() != null && !StackUtil.storeInventoryItem((ItemStack)output.getValue(), player, false)) {
                    return false;
                }
                LiquidUtil.drainContainer(heldItem, FluidRegistry.WATER, amount, (MutableObject<ItemStack>)output, LiquidUtil.FluidContainerOutputMode.InPlacePreferred, false);
                this.type = 1;
                this.boozeAmount += amount / minAmount;
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151015_O) {
                this.type = 1;
                int wantgive = heldItem.field_77994_a;
                if (player.func_70093_af()) {
                    wantgive = 1;
                }
                if (wantgive > 64 - this.wheatCount) {
                    wantgive = 64 - this.wheatCount;
                }
                if (wantgive <= 0) {
                    return false;
                }
                this.wheatCount = (byte)(this.wheatCount + wantgive);
                heldItem.field_77994_a -= wantgive;
                this.alterComposition();
                return true;
            }
            if (StackUtil.checkItemEquality(heldItem, ItemName.crop_res.getItemStack(CropResItemType.hops))) {
                this.type = 1;
                int wantgive = heldItem.field_77994_a;
                if (player.func_70093_af()) {
                    wantgive = 1;
                }
                if (wantgive > 64 - this.hopsCount) {
                    wantgive = 64 - this.hopsCount;
                }
                if (wantgive <= 0) {
                    return false;
                }
                this.hopsCount = (byte)(this.hopsCount + wantgive);
                heldItem.field_77994_a -= wantgive;
                this.alterComposition();
                return true;
            }
        } else if ((this.type == 0 || this.type == 2) && heldItem.func_77973_b() == Items.field_151120_aE) {
            if (this.age > 600) {
                return false;
            }
            this.type = 2;
            int wantgive = heldItem.field_77994_a;
            if (player.func_70093_af()) {
                wantgive = 1;
            }
            if (this.boozeAmount + wantgive > 32) {
                wantgive = 32 - this.boozeAmount;
            }
            if (wantgive <= 0) {
                return false;
            }
            this.boozeAmount += wantgive;
            heldItem.field_77994_a -= wantgive;
            return true;
        }
        return false;
    }

    @Override
    protected void onClicked(EntityPlayer player) {
        super.onClicked(player);
        if (this.getActive()) {
            if (!this.field_145850_b.field_72995_K) {
                StackUtil.dropAsEntity(this.field_145850_b, this.field_174879_c, ItemName.treetap.getItemStack());
                this.setActive(false);
            }
            this.drainLiquid(1);
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            StackUtil.dropAsEntity(this.field_145850_b, this.field_174879_c, new ItemStack(ItemName.barrel.getInstance(), 1, this.calculateMetaValue()));
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, BlockName.scaffold.getBlockState(BlockScaffold.ScaffoldType.wood));
    }

    private void alterComposition() {
        if (this.timeRatio <= 0) {
            this.age = 0;
        } else if (this.timeRatio == 1) {
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.timeRatio = 0;
            } else if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.timeRatio = (byte)5;
            }
        } else if (this.timeRatio == 2) {
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.timeRatio = (byte)5;
            }
        } else {
            this.timeRatio = (byte)5;
        }
    }

    public boolean drainLiquid(int amount) {
        if (this.isEmpty()) {
            return false;
        }
        if (amount > this.boozeAmount) {
            return false;
        }
        this.open();
        if (this.type == 2) {
            int progress = this.age * 100 / this.timeNedForRum(this.boozeAmount);
            this.boozeAmount -= amount;
            this.age = progress / 100 * this.timeNedForRum(this.boozeAmount);
        } else {
            this.boozeAmount -= amount;
        }
        if (this.boozeAmount <= 0) {
            if (this.type == 1) {
                this.hopsCount = 0;
                this.wheatCount = 0;
                this.hopsRatio = 0;
                this.solidRatio = 0;
                this.timeRatio = 0;
            }
            this.type = 0;
            this.opened = false;
            this.boozeAmount = 0;
        }
        return true;
    }

    private void open() {
        if (this.opened) {
            return;
        }
        this.opened = true;
        if (this.type == 1) {
            float ratio = this.hopsCount <= 0 ? 0.0f : (float)this.hopsCount / (float)this.wheatCount;
            if (ratio <= 0.25f) {
                this.hopsRatio = 0;
            } else if (ratio <= 0.33333334f) {
                this.hopsRatio = 1;
            } else if (ratio <= 0.5f) {
                this.hopsRatio = (byte)2;
            } else if (ratio < 2.0f) {
                this.hopsRatio = (byte)3;
            } else {
                this.hopsRatio = (byte)Math.min(6.0, Math.floor(ratio) + 2.0);
                if (ratio >= 5.0f) {
                    this.timeRatio = (byte)5;
                }
            }
            ratio = this.boozeAmount <= 0 ? Float.POSITIVE_INFINITY : (float)(this.hopsCount + this.wheatCount) / (float)this.boozeAmount;
            if (ratio <= 0.41666666f) {
                this.solidRatio = 0;
            } else if (ratio <= 0.5f) {
                this.solidRatio = 1;
            } else if (ratio < 1.0f) {
                this.solidRatio = (byte)2;
            } else if (ratio == 1.0f) {
                this.solidRatio = (byte)3;
            } else if (ratio < 2.0f) {
                this.solidRatio = (byte)4;
            } else if (ratio < 2.4f) {
                this.solidRatio = (byte)5;
            } else {
                this.solidRatio = (byte)6;
                if (ratio >= 4.0f) {
                    this.timeRatio = (byte)5;
                }
            }
        }
    }

    public int calculateMetaValue() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.type == 1) {
            this.open();
            int value = 0;
            value |= this.timeRatio;
            value <<= 3;
            value |= this.hopsRatio;
            value <<= 3;
            value |= this.solidRatio;
            value <<= 5;
            value |= this.boozeAmount - 1;
            value <<= 2;
            return value |= this.type;
        }
        if (this.type == 2) {
            this.open();
            int value = 0;
            int progress = this.age * 100 / this.timeNedForRum(this.boozeAmount);
            if (progress > 100) {
                progress = 100;
            }
            value |= progress;
            value <<= 5;
            value |= this.boozeAmount - 1;
            value <<= 2;
            return value |= this.type;
        }
        return 0;
    }

    public int timeNedForRum(int amount) {
        return (int)((double)(1200 * amount) * Math.pow(0.95, amount - 1));
    }

    @Override
    protected ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return BlockName.scaffold.getItemStack(BlockScaffold.ScaffoldType.wood);
    }

    @Override
    protected List<ItemStack> getAuxDrops(int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(super.getAuxDrops(fortune));
        ret.add(ItemName.barrel.getItemStack());
        return ret;
    }
}

