/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.crop.TileEntityCrop;
import ic2.core.model.AbstractModel;
import ic2.core.model.BasicBakedBlockModel;
import ic2.core.model.ModelUtil;
import ic2.core.model.VdUtil;
import ic2.core.util.LogCategory;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CropModel
extends AbstractModel {
    private static final ResourceLocation STICK = new ResourceLocation("ic2", "blocks/crop/stick2");
    private static Map<ResourceLocation, TextureAtlasSprite> textures = new HashMap<ResourceLocation, TextureAtlasSprite>();
    private final LoadingCache<TileEntityCrop.CropRenderState, IBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<TileEntityCrop.CropRenderState, IBakedModel>(){

        public IBakedModel load(TileEntityCrop.CropRenderState key) throws Exception {
            if (key.crop == null || key.size <= 0) {
                return CropModel.this.generateStickModel(key.crosscrop);
            }
            return CropModel.this.generateModel(key);
        }
    });

    @Override
    public Collection<ResourceLocation> getTextures() {
        if (textures.isEmpty() && Loader.instance().hasReachedState(LoaderState.AVAILABLE)) {
            for (CropCard crop : Crops.instance.getCrops()) {
                for (ResourceLocation aux : crop.getTexturesLocation()) {
                    textures.put(aux, null);
                }
            }
            textures.put(STICK, null);
        }
        return textures.keySet();
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IC2.log.debug(LogCategory.Resource, "Baking at state: " + Loader.instance().getLoaderState());
        for (Map.Entry<ResourceLocation, TextureAtlasSprite> entry : textures.entrySet()) {
            entry.setValue((TextureAtlasSprite)bakedTextureGetter.apply((Object)entry.getKey()));
        }
        return this;
    }

    private static ResourceLocation getTextureLocation(CropCard crop, int currentSize) {
        return crop.getTexturesLocation().get(currentSize - 1);
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState rawState, EnumFacing side, long rand) {
        if (!(rawState instanceof Ic2BlockState.Ic2BlockStateInstance)) {
            return ModelUtil.getMissingModel().func_188616_a(rawState, side, rand);
        }
        Ic2BlockState.Ic2BlockStateInstance state = (Ic2BlockState.Ic2BlockStateInstance)rawState;
        if (!state.hasValue(TileEntityCrop.renderStateProperty)) {
            return ModelUtil.getMissingModel().func_188616_a((IBlockState)state, side, rand);
        }
        TileEntityCrop.CropRenderState prop = state.getValue(TileEntityCrop.renderStateProperty);
        try {
            return ((IBakedModel)this.modelCache.get((Object)prop)).func_188616_a((IBlockState)state, side, rand);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IBakedModel generateModel(TileEntityCrop.CropRenderState prop) {
        List[] faceQuads = new List[EnumFacing.field_82609_l.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        List<Object> generalQuads = new ArrayList<BakedQuad>();
        TextureAtlasSprite sprite_stick = textures.get(STICK);
        TextureAtlasSprite sprite_crop = textures.get(CropModel.getTextureLocation(prop.crop, prop.size));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            CropModel.addCuboid(0.2f, 0.0f, 0.2f, 0.25f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.75f, 0.0f, 0.2f, 0.8f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.2f, 0.0f, 0.75f, 0.25f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.75f, 0.0f, 0.75f, 0.8f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            if (prop.crosscrop) {
                CropModel.addCuboid(0.05f, 0.65f, 0.2f, 0.95f, 0.7f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
                CropModel.addCuboid(0.2f, 0.65f, 0.05f, 0.25f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
                CropModel.addCuboid(0.05f, 0.65f, 0.75f, 0.95f, 0.7f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
                CropModel.addCuboid(0.75f, 0.65f, 0.05f, 0.8f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            }
            if (prop.crop == null) continue;
            CropModel.addFlippedCuboid(0.0f, 0.0f, 0.225f, 1.0f, 1.0f, 0.225f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
            CropModel.addFlippedCuboid(0.225f, 0.0f, 0.0f, 0.225f, 1.0f, 1.0f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
            CropModel.addFlippedCuboid(0.0f, 0.0f, 0.775f, 1.0f, 1.0f, 0.775f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
            CropModel.addFlippedCuboid(0.775f, 0.0f, 0.0f, 0.775f, 1.0f, 1.0f, EnumSet.of(facing), sprite_crop, faceQuads, generalQuads);
        }
        int used = 0;
        for (int i = 0; i < faceQuads.length; ++i) {
            if (faceQuads[i].isEmpty()) {
                faceQuads[i] = Collections.emptyList();
                continue;
            }
            ++used;
        }
        if (used == 0) {
            faceQuads = null;
        }
        if (generalQuads.isEmpty()) {
            generalQuads = Collections.emptyList();
        }
        return new BasicBakedBlockModel(faceQuads, generalQuads, sprite_stick);
    }

    private IBakedModel generateStickModel(boolean crosscrop) {
        List[] faceQuads = new List[EnumFacing.field_82609_l.length];
        for (int i = 0; i < faceQuads.length; ++i) {
            faceQuads[i] = new ArrayList();
        }
        List<Object> generalQuads = new ArrayList<BakedQuad>();
        TextureAtlasSprite sprite_stick = textures.get(new ResourceLocation("ic2", "blocks/crop/stick2"));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            CropModel.addCuboid(0.2f, 0.0f, 0.2f, 0.25f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.75f, 0.0f, 0.2f, 0.8f, 0.85f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.2f, 0.0f, 0.75f, 0.25f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.75f, 0.0f, 0.75f, 0.8f, 0.85f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            if (!crosscrop) continue;
            CropModel.addCuboid(0.05f, 0.65f, 0.2f, 0.95f, 0.7f, 0.25f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.2f, 0.65f, 0.05f, 0.25f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.05f, 0.65f, 0.75f, 0.95f, 0.7f, 0.8f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
            CropModel.addCuboid(0.75f, 0.65f, 0.05f, 0.8f, 0.7f, 0.95f, EnumSet.of(facing), sprite_stick, faceQuads, generalQuads);
        }
        int used = 0;
        for (int i = 0; i < faceQuads.length; ++i) {
            if (faceQuads[i].isEmpty()) {
                faceQuads[i] = Collections.emptyList();
                continue;
            }
            ++used;
        }
        if (used == 0) {
            faceQuads = null;
        }
        if (generalQuads.isEmpty()) {
            generalQuads = Collections.emptyList();
        }
        return new BasicBakedBlockModel(faceQuads, generalQuads, sprite_stick);
    }

    private static void addCuboid(float xS, float yS, float zS, float xE, float yE, float zE, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94209_e();
        float spriteV = sprite.func_94206_g();
        float spriteWidth = sprite.func_94212_f() - spriteU;
        float spriteHeight = sprite.func_94210_h() - spriteV;
        IntBuffer quadBuffer = IntBuffer.allocate(28);
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = BasicBakedBlockModel.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                faceQuads[facing.ordinal()].add(quad);
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    private static void addFlippedCuboid(float xS, float yS, float zS, float xE, float yE, float zE, Set<EnumFacing> faces, TextureAtlasSprite sprite, List<BakedQuad>[] faceQuads, List<BakedQuad> generalQuads) {
        float spriteU = sprite.func_94212_f();
        float spriteV = sprite.func_94210_h();
        float spriteWidth = sprite.func_94209_e() - spriteU;
        float spriteHeight = sprite.func_94206_g() - spriteV;
        IntBuffer quadBuffer = IntBuffer.allocate(28);
        block8: for (EnumFacing facing : faces) {
            boolean isFace;
            switch (facing) {
                case DOWN: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    isFace = yS == 0.0f;
                    break;
                }
                case UP: {
                    if (xS == xE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * zS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * zE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * zS, facing, quadBuffer);
                    isFace = yE == 1.0f;
                    break;
                }
                case NORTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = zS == 0.0f;
                    break;
                }
                case SOUTH: {
                    if (xS == xE || yS == yE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * xE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * xS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = zE == 1.0f;
                    break;
                }
                case WEST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xS, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xS, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    isFace = xS == 0.0f;
                    break;
                }
                case EAST: {
                    if (yS == yE || zS == zE) continue block8;
                    VdUtil.generateBlockVertex(xE, yS, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yS, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zS, spriteU + spriteWidth * zS, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yE, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yE, facing, quadBuffer);
                    VdUtil.generateBlockVertex(xE, yS, zE, spriteU + spriteWidth * zE, spriteV + spriteHeight * yS, facing, quadBuffer);
                    isFace = xE == 1.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (quadBuffer.position() <= 0) continue;
            BakedQuad quad = BasicBakedBlockModel.createQuad(Arrays.copyOf(quadBuffer.array(), quadBuffer.position()), facing, sprite);
            if (isFace) {
                faceQuads[facing.ordinal()].add(quad);
            } else {
                generalQuads.add(quad);
            }
            quadBuffer.rewind();
        }
    }

    @Override
    public void onReload() {
        this.modelCache.invalidateAll();
    }
}

