/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InvSlotContainer
extends InvSlot {
    protected final InvSlotCrafting parent;
    protected final Item[] containerMap = new Item[this.size()];

    protected InvSlotContainer(InvSlotCrafting parent, String name, int count, InvSlot.InvSide side) {
        this(parent, name, InvSlot.Access.I, count, side);
    }

    public InvSlotContainer(InvSlotCrafting parent, String name, InvSlot.Access access, int count, InvSlot.InvSide side) {
        super(parent.base, name, access, count, side);
        this.parent = parent;
    }

    public static boolean isSingleContainer(ItemStack stack) {
        assert (stack != null && stack.func_77973_b() != null);
        return stack.func_77973_b().hasContainerItem(stack) && stack.func_77976_d() == 1;
    }

    protected void buildContainerItemMap() {
        for (int slot = 0; slot < this.size(); ++slot) {
            ItemStack stack = this.get(slot);
            this.containerMap[slot] = stack != null ? stack.func_77973_b() : null;
        }
    }

    @Override
    public boolean accepts(ItemStack stack) {
        return stack != null && InvSlotContainer.isSingleContainer(stack);
    }

    public int findOther(ItemStack container) {
        assert (container != null);
        Item containerItem = container.func_77973_b();
        assert (containerItem != null && containerItem.hasContainerItem(container));
        for (int slot = 0; slot < this.size(); ++slot) {
            if (this.containerMap[slot] != containerItem) continue;
            return slot;
        }
        return -1;
    }

    public boolean hasOthers(ItemStack container) {
        return this.findOther(container) > -1;
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.buildContainerItemMap();
        this.parent.onChanged();
    }
}

