/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntegration;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.Recipes;
import ic2.core.block.machine.container.ContainerBatchCrafter;
import ic2.core.block.machine.container.ContainerIndustrialWorkbench;
import ic2.core.item.block.ItemCable;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.ref.TeBlock;
import ic2.jeiIntegration.recipe.crafting.AdvRecipeHandler;
import ic2.jeiIntegration.recipe.crafting.AdvShapelessRecipeHandler;
import ic2.jeiIntegration.recipe.crafting.GradualRecipeHandler;
import ic2.jeiIntegration.recipe.crafting.JetpackRecipeHandler;
import ic2.jeiIntegration.recipe.crafting.JetpackRecipeWrapper;
import ic2.jeiIntegration.recipe.machine.DynamicCategory;
import ic2.jeiIntegration.recipe.machine.ElectrolyzerCategory;
import ic2.jeiIntegration.recipe.machine.ElectrolyzerRecipeHandler;
import ic2.jeiIntegration.recipe.machine.IORecipeCategory;
import ic2.jeiIntegration.recipe.machine.IORecipeHandler;
import ic2.jeiIntegration.recipe.machine.IRecipeWrapperGenerator;
import ic2.jeiIntegration.recipe.machine.MetalFormerCategory;
import ic2.jeiIntegration.recipe.machine.RecyclerCategory;
import ic2.jeiIntegration.recipe.misc.ScrapboxRecipeCategory;
import ic2.jeiIntegration.recipe.misc.ScrapboxRecipeHandler;
import ic2.jeiIntegration.recipe.misc.ScrapboxRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class SubModule
implements IModPlugin {
    public void register(IModRegistry registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeHandlers(new IRecipeHandler[]{new AdvRecipeHandler()});
        registry.addRecipeHandlers(new IRecipeHandler[]{new AdvShapelessRecipeHandler()});
        registry.addRecipeHandlers(new IRecipeHandler[]{new GradualRecipeHandler()});
        registry.addRecipeHandlers(new IRecipeHandler[]{new JetpackRecipeHandler()});
        registry.addRecipes(JetpackRecipeWrapper.generateJetpackRecipes());
        registry.addRecipeCategories(new IRecipeCategory[]{new ScrapboxRecipeCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(ItemName.crafting.getItemStack(CraftingItemType.scrap_box), new String[]{"ic2.scrapbox"});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ScrapboxRecipeHandler()});
        registry.addRecipes(ScrapboxRecipeWrapper.createRecipes());
        registry.addRecipeHandlers(new IRecipeHandler[]{new IORecipeHandler(), new ElectrolyzerRecipeHandler()});
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.macerator, Recipes.macerator, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.extractor, Recipes.extractor, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.compressor, Recipes.compressor, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.centrifuge, Recipes.centrifuge, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.blast_furnace, Recipes.blastfurnace, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.ore_washing_plant, Recipes.oreWashing, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new DynamicCategory<IMachineRecipeManager>(TeBlock.block_cutter, Recipes.blockcutter, guiHelper), IRecipeWrapperGenerator.blockCutter);
        this.addMachineRecipes(registry, new MetalFormerCategory(Recipes.metalformerExtruding, 0, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new MetalFormerCategory(Recipes.metalformerRolling, 1, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new MetalFormerCategory(Recipes.metalformerCutting, 2, guiHelper), IRecipeWrapperGenerator.basicMachine);
        this.addMachineRecipes(registry, new ElectrolyzerCategory(guiHelper), IRecipeWrapperGenerator.electrolyzer);
        this.addMachineRecipes(registry, new RecyclerCategory(guiHelper), IRecipeWrapperGenerator.recycler);
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.iron_furnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.electric_furnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.induction_furnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.iron_furnace), new String[]{"minecraft.fuel"});
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.generator), new String[]{"minecraft.fuel"});
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.solid_heat_generator), new String[]{"minecraft.fuel"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerIndustrialWorkbench.class, "minecraft.crafting", 37, 9, 0, 36);
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.industrial_workbench), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerBatchCrafter.class, "minecraft.crafting", 36, 9, 0, 36);
        registry.addRecipeCategoryCraftingItem(BlockName.te.getItemStack(TeBlock.batch_crafter), new String[]{"minecraft.crafting"});
    }

    private <T> void addMachineRecipes(IModRegistry registry, IORecipeCategory<T> category, IRecipeWrapperGenerator<T> wrappergen) {
        registry.addRecipeCategories(new IRecipeCategory[]{category});
        registry.addRecipes(wrappergen.getRecipeList(category));
        registry.addRecipeCategoryCraftingItem(category.getBlockStack(), new String[]{category.getUid()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerNbtInterpreter(ItemName.cable.getInstance(), new ISubtypeRegistry.ISubtypeInterpreter(){

            public String getSubtypeInfo(ItemStack stack) {
                return ((ItemCable)ItemName.cable.getInstance()).getVariant(stack);
            }
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }
}

