/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.reactor.tileentity;

import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.reactor.IReactorChamber;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Redstone;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorChamberElectric
extends TileEntityBlock
implements IInventory,
IReactorChamber,
IFluidHandler,
IEnergyEmitter {
    public final Redstone redstone = this.addComponent(new Redstone(this));
    private TileEntityNuclearReactorElectric reactor;
    private long lastReactorUpdate;

    @Override
    protected void onLoaded() {
        super.onLoaded();
        this.updateRedstoneLink();
    }

    private void updateRedstoneLink() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        this.redstone.linkTo(reactor.redstone);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            TileEntityNuclearReactorElectric.showHeatEffects(this.field_145850_b, this.field_174879_c, reactor.getHeat());
        }
    }

    @Override
    protected boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            return reactor.getBlockType().func_180639_a(this.field_145850_b, reactor.func_174877_v(), this.field_145850_b.func_180495_p(reactor.func_174877_v()), player, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    protected void onNeighborChange(Block neighbor) {
        super.onNeighborChange(neighbor);
        this.lastReactorUpdate = 0L;
        if (this.getReactor() == null) {
            this.destoryChamber(true);
        }
    }

    public void destoryChamber(boolean wrench) {
        this.field_145850_b.func_175698_g(this.field_174879_c);
        for (ItemStack drop : this.getSelfDrops(0, wrench)) {
            StackUtil.dropAsEntity(this.field_145850_b, this.field_174879_c, drop);
        }
    }

    public String func_70005_c_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70005_c_() : "<null>";
    }

    public boolean func_145818_k_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_145818_k_() : false;
    }

    public ITextComponent func_145748_c_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_145748_c_() : new TextComponentString("<null>");
    }

    public int func_70302_i_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int index) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70301_a(index) : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70298_a(index, count) : null;
    }

    public ItemStack func_70304_b(int index) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70304_b(index) : null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_70299_a(index, stack);
        }
    }

    public int func_70297_j_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70300_a(player) : false;
    }

    public void func_174889_b(EntityPlayer player) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174886_c(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_94041_b(index, stack) : false;
    }

    public int func_174887_a_(int id) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_174887_a_(id) : 0;
    }

    public void func_174885_b(int id, int value) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174885_b(id, value);
        }
    }

    public int func_174890_g() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_174890_g() : 0;
    }

    public void func_174888_l() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174888_l();
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.fill(from, resource, doFill) : 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.drain(from, resource, doDrain) : null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.drain(from, maxDrain, doDrain) : null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.canFill(from, fluid) : false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.canDrain(from, fluid) : false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.getTankInfo(from) : new FluidTankInfo[]{};
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public TileEntityNuclearReactorElectric getReactorInstance() {
        return this.reactor;
    }

    @Override
    public boolean isWall() {
        return false;
    }

    private TileEntityNuclearReactorElectric getReactor() {
        long time = this.field_145850_b.func_82737_E();
        if (time != this.lastReactorUpdate) {
            this.updateReactor();
            this.lastReactorUpdate = time;
        } else if (this.reactor != null && this.reactor.func_145837_r()) {
            this.reactor = null;
        }
        return this.reactor;
    }

    private void updateReactor() {
        this.reactor = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(te instanceof TileEntityNuclearReactorElectric)) continue;
            this.reactor = (TileEntityNuclearReactorElectric)te;
            break;
        }
    }
}

