/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.container.ContainerCropmatron;
import ic2.core.block.machine.gui.GuiCropmatron;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.crop.TileEntityCrop;
import ic2.core.item.type.CropResItemType;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import java.util.List;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityCropmatron
extends TileEntityElectricMachine
implements IHasGui,
net.minecraftforge.fluids.IFluidHandler {
    public int scanX = -5;
    public int scanY = -1;
    public int scanZ = -5;
    public final InvSlotConsumable fertilizerSlot;
    public final InvSlotOutput wasseroutputSlot;
    public final InvSlotOutput exOutputSlot;
    public final InvSlotConsumableLiquidByTank wasserinputSlot;
    public final InvSlotConsumableLiquidByTank exInputSlot;
    protected final FluidTank waterTank = new SpecificFluidTank(2, FluidRegistry.WATER);
    protected final FluidTank exTank = new SpecificFluidTank(2, FluidName.weed_ex.getInstance());

    public TileEntityCropmatron() {
        super(10000, 1);
        this.fertilizerSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "fertilizer", 7, ItemName.crop_res.getItemStack(CropResItemType.fertilizer));
        this.wasserinputSlot = new InvSlotConsumableLiquidByTank(this, "wasserinputSlot", InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, (IFluidTank)this.waterTank);
        this.exInputSlot = new InvSlotConsumableLiquidByTank(this, "exInputSlot", InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, (IFluidTank)this.exTank);
        this.wasseroutputSlot = new InvSlotOutput(this, "wasseroutputSlot", 1);
        this.exOutputSlot = new InvSlotOutput(this, "exOutputSlot", 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.waterTank.readFromNBT(nbttagcompound.func_74775_l("waterTank"));
        this.exTank.readFromNBT(nbttagcompound.func_74775_l("exTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound waterTankTag = new NBTTagCompound();
        this.waterTank.writeToNBT(waterTankTag);
        nbt.func_74782_a("waterTank", (NBTBase)waterTankTag);
        NBTTagCompound exTankTag = new NBTTagCompound();
        this.exTank.writeToNBT(exTankTag);
        nbt.func_74782_a("exTank", (NBTBase)exTankTag);
        return nbt;
    }

    @Override
    protected void updateEntityServer() {
        List<ItemStack> processResult;
        super.updateEntityServer();
        RecipeOutput outputinputSlot = this.processWaterInputSlot(true);
        if (outputinputSlot != null) {
            this.processWaterInputSlot(false);
            processResult = outputinputSlot.items;
            this.wasseroutputSlot.add(processResult);
        }
        if ((outputinputSlot = this.processExInputSlot(true)) != null) {
            this.processExInputSlot(false);
            processResult = outputinputSlot.items;
            this.exOutputSlot.add(processResult);
        }
        this.fertilizerSlot.organize();
        if (this.energy.getEnergy() >= 31.0) {
            this.scan();
        }
    }

    public void scan() {
        ++this.scanX;
        if (this.scanX > 5) {
            this.scanX = -5;
            ++this.scanZ;
            if (this.scanZ > 5) {
                this.scanZ = -5;
                ++this.scanY;
                if (this.scanY > 1) {
                    this.scanY = -1;
                }
            }
        }
        this.energy.useEnergy(1.0);
        BlockPos scan = this.field_174879_c.func_177982_a(this.scanX, this.scanY, this.scanZ);
        TileEntity te = this.field_145850_b.func_175625_s(scan);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (!this.fertilizerSlot.isEmpty() && this.fertilizerSlot.consume(1, true, false) != null && crop.applyFertilizer(false)) {
                this.energy.useEnergy(10.0);
                this.fertilizerSlot.consume(1);
            }
            if (this.waterTank.getFluidAmount() > 0 && crop.applyHydration((IFluidHandler)this.getWaterTank())) {
                this.energy.useEnergy(10.0);
            }
            if (this.exTank.getFluidAmount() > 0 && crop.applyWeedEx((IFluidHandler)this.getExTank(), false)) {
                this.energy.useEnergy(10.0);
            }
        } else if (this.waterTank.getFluidAmount() > 0 && this.tryHydrateFarmland(scan)) {
            this.energy.useEnergy(10.0);
        }
    }

    private boolean tryHydrateFarmland(BlockPos pos) {
        int hydration;
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150458_ak && (hydration = ((Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) < 7) {
            int drainAmount = Math.min(this.waterTank.getFluidAmount(), 7 - hydration);
            assert (drainAmount > 0);
            assert (drainAmount <= 7);
            this.waterTank.drain(drainAmount, true);
            this.field_145850_b.func_180501_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(hydration + drainAmount)), 2);
            return true;
        }
        return false;
    }

    private RecipeOutput processWaterInputSlot(boolean simulate) {
        MutableObject output;
        if (!this.wasserinputSlot.isEmpty() && this.wasserinputSlot.transferToTank((IFluidTank)this.waterTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.wasseroutputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    private RecipeOutput processExInputSlot(boolean simulate) {
        MutableObject output;
        if (!this.exInputSlot.isEmpty() && this.exInputSlot.transferToTank((IFluidTank)this.exTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.exOutputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    public ContainerBase<TileEntityCropmatron> getGuiContainer(EntityPlayer player) {
        return new ContainerCropmatron(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiCropmatron(new ContainerCropmatron(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.waterTank.getInfo(), this.exTank.getInfo()};
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER) {
            this.getWaterTank().fill(resource, doFill);
        }
        if (resource.getFluid() == FluidName.weed_ex.getInstance()) {
            this.getExTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public FluidTank getExTank() {
        return this.exTank;
    }

    public static class SpecificFluidTank
    extends FluidTank {
        protected final Fluid fluidType;

        public SpecificFluidTank(int bucketCapacity, Fluid fluid) {
            super(1000 * bucketCapacity);
            this.fluidType = fluid;
        }

        public FluidStack getFluid() {
            return new FluidStack(this.fluidType, this.getFluidAmount());
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == this.fluidType;
        }
    }
}

