/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrade;

import ic2.core.ContainerBase;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.gui.Button;
import ic2.core.gui.IClickHandler;
import ic2.core.gui.MouseButton;
import ic2.core.gui.VanillaButton;
import ic2.core.init.Localization;
import ic2.core.item.tool.HandHeldInventory;
import ic2.core.item.upgrade.HandHeldAdvancedUpgrade;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class HandHeldUpgradeOption
extends HandHeldInventory {
    protected final String name;
    protected final HandHeldAdvancedUpgrade previousGUI;

    protected HandHeldUpgradeOption(HandHeldAdvancedUpgrade upgradeGUI, String name) {
        super(upgradeGUI.getPlayer(), upgradeGUI.getContainerStack(), 9);
        this.previousGUI = upgradeGUI;
        this.name = name;
    }

    static Button<?> getBackButton(final GuiIC2<?> gui) {
        return new VanillaButton(gui, 10, 62, 50, 15, new IClickHandler(){

            @Override
            public void onClick(MouseButton button) {
                IC2.network.get(false).sendContainerEvent((ContainerBase<?>)((Object)gui.getContainer()), "back");
            }
        }).withText(Localization.translate("ic2.upgrade.advancedGUI.back"));
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    protected static class ComparisonSettings
    extends Enum<ComparisonSettings> {
        public static final /* enum */ ComparisonSettings EQUAL = new ComparisonSettings("=");
        public static final /* enum */ ComparisonSettings LESS_OR_EQUAL = new ComparisonSettings("<="){

            @Override
            ComparisonSettings[] getPairOptions() {
                return new ComparisonSettings[]{LESS, LESS_OR_EQUAL};
            }
        };
        public static final /* enum */ ComparisonSettings LESS = new ComparisonSettings("<"){

            @Override
            ComparisonSettings[] getPairOptions() {
                return new ComparisonSettings[]{LESS, LESS_OR_EQUAL};
            }
        };
        public static final /* enum */ ComparisonSettings GREATER = new ComparisonSettings(">"){

            @Override
            ComparisonSettings[] getPairOptions() {
                return new ComparisonSettings[]{GREATER, GREATER_OR_EQUAL};
            }
        };
        public static final /* enum */ ComparisonSettings GREATER_OR_EQUAL = new ComparisonSettings(">="){

            @Override
            ComparisonSettings[] getPairOptions() {
                return new ComparisonSettings[]{GREATER, GREATER_OR_EQUAL};
            }
        };
        final String symbol;
        private static final Map<String, ComparisonSettings> SYMBOL_TO_SETTING;
        private static final /* synthetic */ ComparisonSettings[] $VALUES;

        public static ComparisonSettings[] values() {
            return (ComparisonSettings[])$VALUES.clone();
        }

        public static ComparisonSettings valueOf(String name) {
            return Enum.valueOf(ComparisonSettings.class, name);
        }

        private ComparisonSettings(String symbol) {
            this.symbol = symbol;
        }

        String constructFromBox(String type, String box) {
            return type + this.symbol + box;
        }

        ComparisonSettings[] getPairOptions() {
            return new ComparisonSettings[0];
        }

        String constructFromBoxes(String type, ComparisonSettings other, String mainBox, String auxBox) {
            boolean valid = false;
            for (ComparisonSettings option : this.getPairOptions()) {
                if (!option.equals((Object)other)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new IllegalArgumentException("Cannot combine " + this.name() + " and " + other.name() + '!');
            }
            int comparison = Integer.valueOf(mainBox).compareTo(Integer.valueOf(auxBox));
            switch (comparison) {
                case 0: 
                case 1: {
                    return auxBox + other.symbol + type + this.symbol + mainBox;
                }
                case -1: {
                    return mainBox + other.symbol + type + this.symbol + auxBox;
                }
            }
            throw new IllegalStateException("Impossible! Comparison was " + comparison);
        }

        public static ComparisonContainer breakNBT(String type, String nbt) {
            ComparisonContainer ret = new ComparisonContainer();
            Matcher m = Pattern.compile(type + "([=<>]=?)(\\d+)").matcher(nbt);
            if (m.matches()) {
                assert (m.groupCount() == 2);
                ret.rightSetting = SYMBOL_TO_SETTING.get(m.group(1));
                ret.rightBox = m.group(2);
            } else {
                m = Pattern.compile("(\\d+)([=<>]=?)" + type + "[=<>]=?\\d+").matcher(nbt);
                if (m.matches()) {
                    assert (m.groupCount() == 4);
                    ret.leftBox = m.group(1);
                    ret.leftSetting = SYMBOL_TO_SETTING.get(m.group(2));
                    ret.rightSetting = SYMBOL_TO_SETTING.get(m.group(3));
                    ret.rightBox = m.group(4);
                } else {
                    throw new IllegalArgumentException("Cannot decode given string: " + nbt);
                }
            }
            return ret;
        }

        static {
            $VALUES = new ComparisonSettings[]{EQUAL, LESS_OR_EQUAL, LESS, GREATER, GREATER_OR_EQUAL};
            SYMBOL_TO_SETTING = new HashMap<String, ComparisonSettings>();
            for (ComparisonSettings setting : ComparisonSettings.values()) {
                SYMBOL_TO_SETTING.put(setting.symbol, setting);
            }
        }

        public static class ComparisonContainer {
            public String leftBox;
            public String rightBox;
            public ComparisonSettings leftSetting;
            public ComparisonSettings rightSetting;
        }
    }

    protected static enum BoxSettings {
        IGNORED,
        COMPARISON,
        RANGE;

    }
}

