/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.IElectrolyzerRecipeManager;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerElectrolyzer;
import ic2.core.block.machine.gui.GuiElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityTank;
import ic2.core.recipe.ElectrolyzerRecipeManager;
import ic2.core.ref.FluidName;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityElectrolyzer
extends TileEntityElectricMachine
implements IFluidHandler,
IUpgradableBlock,
IHasGui {
    protected int progress = 0;
    protected IElectrolyzerRecipeManager.ElectrolyzerRecipe recipe = null;
    protected FluidTank input = new FluidTank(8000);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgradeSlot", 4);

    public TileEntityElectrolyzer() {
        super(32000, 2);
    }

    public static void init() {
        Recipes.electrolyzer = new ElectrolyzerRecipeManager();
        Recipes.electrolyzer.addRecipe(FluidRegistry.WATER.getName(), 40, 32, new IElectrolyzerRecipeManager.ElectrolyzerOutput(FluidName.hydrogen.getName(), 26, EnumFacing.DOWN), new IElectrolyzerRecipeManager.ElectrolyzerOutput(FluidName.oxygen.getName(), 13, EnumFacing.UP));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.input.readFromNBT(nbt.func_74775_l("input"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        NBTTagCompound inputTag = new NBTTagCompound();
        this.input.writeToNBT(inputTag);
        nbt.func_74782_a("input", (NBTBase)inputTag);
        return nbt;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.canOperate()) {
            assert (this.recipe != null);
            this.setActive(true);
            this.energy.useEnergy(this.recipe.EUaTick);
            ++this.progress;
            if (this.progress >= this.recipe.ticksNeeded) {
                this.operate();
                this.progress = 0;
                needsInvUpdate = true;
            }
        } else {
            this.setActive(false);
            this.progress = 0;
        }
        for (ItemStack stack : this.upgradeSlot) {
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            needsInvUpdate = ((IUpgradeItem)stack.func_77973_b()).onTick(stack, this) || needsInvUpdate;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    protected boolean canOperate() {
        if (this.input.getFluid() == null) {
            return false;
        }
        this.recipe = Recipes.electrolyzer.getElectrolysisInformation(this.input.getFluid().getFluid());
        if (this.recipe == null || this.energy.getEnergy() < (double)this.recipe.EUaTick || this.input.getFluidAmount() < this.recipe.inputAmount) {
            return false;
        }
        for (IElectrolyzerRecipeManager.ElectrolyzerOutput output : this.recipe.outputs) {
            if (this.canFillTank(output.tankDirection, output.getOutput())) continue;
            return false;
        }
        return true;
    }

    protected void operate() {
        assert (this.recipe != null);
        this.input.drain(this.recipe.inputAmount, true);
        for (IElectrolyzerRecipeManager.ElectrolyzerOutput output : this.recipe.outputs) {
            this.fillTank(output.tankDirection, output.getOutput());
        }
    }

    protected boolean canFillTank(EnumFacing facing, FluidStack fluid) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te instanceof TileEntityTank) {
            return ((TileEntityTank)te).fill(facing, fluid, false) == fluid.amount;
        }
        return false;
    }

    protected void fillTank(EnumFacing facing, FluidStack fluid) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te instanceof TileEntityTank) {
            ((TileEntityTank)te).fill(facing, fluid, true);
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource != null && this.canFill(from, resource.getFluid())) {
            return this.input.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.input.getInfo()};
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (Recipes.electrolyzer.acceptsFluid(fluid)) {
            return this.input.getFluid() == null || this.input.getFluid().getFluid() == fluid && this.input.getFluidAmount() < this.input.getCapacity();
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemProducing);
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    public ContainerBase<TileEntityElectrolyzer> getGuiContainer(EntityPlayer player) {
        return new ContainerElectrolyzer(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiElectrolyzer(new ContainerElectrolyzer(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public FluidTank getInput() {
        return this.input;
    }

    public IElectrolyzerRecipeManager.ElectrolyzerRecipe getCurrentRecipe() {
        return this.recipe;
    }

    public double getProgress() {
        return this.recipe == null ? 0.0 : (double)this.progress / (double)this.recipe.ticksNeeded;
    }
}

