/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.container;

import gnu.trove.map.hash.TIntObjectHashMap;
import ic2.core.ContainerFullInv;
import ic2.core.block.machine.tileentity.TileEntityIndustrialWorkbench;
import ic2.core.slot.SlotInvSlot;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerIndustrialWorkbench
extends ContainerFullInv<TileEntityIndustrialWorkbench> {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 3, 3){

        private boolean validIndex(int index) {
            return index >= 0 && index < this.func_70302_i_();
        }

        public ItemStack func_70301_a(int index) {
            return !this.validIndex(index) ? null : ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.get(index);
        }

        public ItemStack func_70304_b(int index) {
            if (this.validIndex(index)) {
                ItemStack stack = ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.get(index);
                ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.put(index, null);
                return stack;
            }
            return null;
        }

        public ItemStack func_70298_a(int index, int count) {
            if (this.validIndex(index) && ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.get(index) != null && count > 0) {
                ItemStack stack = ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.get(index).func_77979_a(count);
                if (((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.get((int)index).field_77994_a == 0) {
                    ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.put(index, null);
                }
                ContainerIndustrialWorkbench.this.func_75130_a((IInventory)this);
                return stack;
            }
            return null;
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (this.validIndex(index)) {
                ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.put(index, stack);
                ContainerIndustrialWorkbench.this.func_75130_a((IInventory)this);
            }
        }

        public void func_174888_l() {
            ((TileEntityIndustrialWorkbench)ContainerIndustrialWorkbench.this.base).craftingGrid.clear();
        }
    };
    public IInventory craftResult = new InventoryCraftResult();
    protected final EntityPlayer player;

    public ContainerIndustrialWorkbench(EntityPlayer player, TileEntityIndustrialWorkbench tileEntity) {
        super(player, tileEntity, 166);
        this.player = player;
        this.func_75146_a((Slot)new SlotCrafting(player, this.craftMatrix, this.craftResult, 0, 124, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotInvSlot(tileEntity.craftingGrid, x + y * 3, 30 + x * 18, 17 + y * 18){

                    public void func_75218_e() {
                        super.func_75218_e();
                        ContainerIndustrialWorkbench.this.func_75130_a((IInventory)ContainerIndustrialWorkbench.this.craftMatrix);
                    }
                });
            }
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void func_75130_a(IInventory inventory) {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, ((TileEntityIndustrialWorkbench)this.base).func_145831_w()));
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
    }

    @Override
    protected void handlePlayerSlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        int size = this.craftMatrix.func_70302_i_();
        ArrayList<StackMap> potentialBalances = new ArrayList<StackMap>(size);
        int biggestStack = 0;
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = this.craftMatrix.func_70301_a(slot);
            if (stack == null || !stack.func_77985_e() || stack.field_77994_a >= stack.func_77976_d() || !StackUtil.checkItemEqualityStrict(sourceItemStack, stack)) continue;
            potentialBalances.add(new StackMap(slot, stack, (Slot)this.field_75151_b.get(slot + 1)));
            biggestStack = Math.max(biggestStack, stack.field_77994_a);
        }
        size = potentialBalances.size();
        if (size < 1) {
            super.handlePlayerSlotShiftClick(player, sourceItemStack);
            return;
        }
        assert (biggestStack > 0);
        if (size == 1) {
            StackMap stack = (StackMap)potentialBalances.get(0);
            this.shoveIntoSlot(stack, sourceItemStack);
            stack.actualSlot.func_75218_e();
            return;
        }
        TIntObjectHashMap goals = new TIntObjectHashMap();
        for (StackMap stack : potentialBalances) {
            int want = stack.getWant(biggestStack);
            if (goals.containsKey(want)) {
                ((Set)goals.get(want)).add(stack);
                continue;
            }
            HashSet<StackMap> map = new HashSet<StackMap>();
            map.add(stack);
            goals.put(want, map);
        }
        int[] amounts = goals.keys();
        Arrays.sort(amounts);
        HashSet<StackMap> stacks = new HashSet<StackMap>();
        HashSet<StackMap> changedStacks = new HashSet<StackMap>();
        for (int index = amounts.length - 1; index > 0; --index) {
            int amount = amounts[index];
            int fillAmount = Math.min(sourceItemStack.field_77994_a, amount - amounts[index - 1]);
            stacks.addAll((Collection)goals.get(amount));
            if (stacks.size() == 1) {
                StackMap stack = (StackMap)stacks.iterator().next();
                this.placeIntoSlot(stack, sourceItemStack, Math.min(stack.possible(), fillAmount));
                changedStacks.add(stack);
                if (stack.full()) {
                    stacks.remove(stack);
                }
            } else if (stacks.size() * fillAmount <= sourceItemStack.field_77994_a) {
                for (StackMap stack : stacks) {
                    this.placeIntoSlot(stack, sourceItemStack, Math.min(stack.possible(), fillAmount));
                    changedStacks.add(stack);
                    if (!stack.full()) continue;
                    stacks.remove(stack);
                }
            } else {
                fillAmount = sourceItemStack.field_77994_a / stacks.size();
                int extra = sourceItemStack.field_77994_a - stacks.size() * fillAmount;
                for (StackMap stack : stacks) {
                    int amount2 = fillAmount;
                    if (extra > 0 && stack.possible() - amount2 >= 1) {
                        ++amount2;
                        --extra;
                    }
                    this.placeIntoSlot(stack, sourceItemStack, Math.min(stack.possible(), amount2));
                    changedStacks.add(stack);
                    if (!stack.full()) continue;
                    stacks.remove(stack);
                }
            }
            if (sourceItemStack.field_77994_a <= 0) break;
        }
        if (sourceItemStack.field_77994_a > 0) {
            stacks.clear();
            for (StackMap stack : potentialBalances) {
                if (stack.full()) continue;
                stacks.add(stack);
            }
            if (stacks.size() > 0) {
                int fillAmount = sourceItemStack.field_77994_a / stacks.size();
                int extra = sourceItemStack.field_77994_a - stacks.size() * fillAmount;
                for (StackMap stack : stacks) {
                    int amount = fillAmount;
                    if (extra > 0 && stack.possible() - amount >= 1) {
                        ++amount;
                        --extra;
                    }
                    this.placeIntoSlot(stack, sourceItemStack, Math.min(stack.possible(), amount));
                    changedStacks.add(stack);
                }
            }
        }
        for (StackMap stack : changedStacks) {
            stack.actualSlot.func_75218_e();
        }
    }

    private void shoveIntoSlot(StackMap stack, ItemStack sourceItemStack) {
        this.placeIntoSlot(stack, sourceItemStack, Math.min(sourceItemStack.field_77994_a, stack.possible()));
    }

    private void placeIntoSlot(StackMap stack, ItemStack sourceItemStack, int amount) {
        this.craftMatrix.func_70301_a((int)stack.slot).field_77994_a += amount;
        sourceItemStack.field_77994_a -= amount;
    }

    private static class StackMap {
        public final int slot;
        public final ItemStack stack;
        public final Slot actualSlot;

        public StackMap(int slot, ItemStack stack, Slot actualSlot) {
            this.slot = slot;
            this.stack = stack;
            this.actualSlot = actualSlot;
        }

        public int possible() {
            return this.stack.func_77976_d() - this.stack.field_77994_a;
        }

        public int getWant(int max) {
            return max - this.stack.field_77994_a;
        }

        public boolean full() {
            return this.stack.func_77976_d() <= this.stack.field_77994_a;
        }

        public String toString() {
            return "StackMap{stack=" + StackUtil.toStringSafe(this.stack) + ",slot=" + this.slot + '}';
        }
    }
}

