/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.gui;

import com.google.common.base.Supplier;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.container.ContainerIndustrialWorkbench;
import ic2.core.block.machine.tileentity.TileEntityIndustrialWorkbench;
import ic2.core.gui.CustomButton;
import ic2.core.gui.GuiElement;
import ic2.core.gui.IClickHandler;
import ic2.core.gui.IEnableHandler;
import ic2.core.gui.MouseButton;
import ic2.core.init.Localization;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class GuiIndustrialWorkbench
extends GuiIC2<ContainerIndustrialWorkbench> {
    private static final ResourceLocation CRAFTING_TABLE_GUI = new ResourceLocation("textures/gui/container/crafting_table.png");

    public GuiIndustrialWorkbench(ContainerIndustrialWorkbench container) {
        super(container);
        for (final EnumFacing side : EnumFacing.field_82609_l) {
            this.addElement((GuiElement<?>)((CustomButton)((CustomButton)new CustomButton(this, this.getX(side), this.getY(side), 18, 18, new IClickHandler(){

                @Override
                public void onClick(MouseButton button) {
                    IC2.network.get(false).sendContainerEvent(GuiIndustrialWorkbench.this.container, "open" + side.func_176745_a());
                }
            }).withEnableHandler(new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    TileEntityIndustrialWorkbench base = (TileEntityIndustrialWorkbench)((ContainerIndustrialWorkbench)((GuiIndustrialWorkbench)GuiIndustrialWorkbench.this).container).base;
                    return base.func_145830_o() && base.func_145831_w().func_175625_s(base.func_174877_v().func_177972_a(side)) instanceof IHasGui;
                }
            })).withIcon(new Supplier<ItemStack>(){

                public ItemStack get() {
                    TileEntityIndustrialWorkbench base = (TileEntityIndustrialWorkbench)((ContainerIndustrialWorkbench)((GuiIndustrialWorkbench)GuiIndustrialWorkbench.this).container).base;
                    assert (base.func_145830_o());
                    BlockPos pos = base.func_174877_v().func_177972_a(side);
                    IBlockState state = base.func_145831_w().func_180495_p(pos);
                    return state.func_177230_c().getPickBlock(state, null, base.func_145831_w(), pos, ((ContainerIndustrialWorkbench)GuiIndustrialWorkbench.this.container).getPlayer());
                }
            })).withTooltip(new Supplier<String>(){

                private String getSideName() {
                    switch (side) {
                        case WEST: {
                            return "ic2.dir.west";
                        }
                        case EAST: {
                            return "ic2.dir.east";
                        }
                        case DOWN: {
                            return "ic2.dir.bottom";
                        }
                        case UP: {
                            return "ic2.dir.top";
                        }
                        case NORTH: {
                            return "ic2.dir.north";
                        }
                        case SOUTH: {
                            return "ic2.dir.south";
                        }
                    }
                    throw new IllegalStateException("Unexpected direction: " + side);
                }

                public String get() {
                    TileEntityIndustrialWorkbench base = (TileEntityIndustrialWorkbench)((ContainerIndustrialWorkbench)((GuiIndustrialWorkbench)GuiIndustrialWorkbench.this).container).base;
                    assert (base.func_145830_o());
                    TileEntity neighbour = base.func_145831_w().func_175625_s(base.func_174877_v().func_177972_a(side));
                    assert (neighbour instanceof IHasGui);
                    return Localization.translate(((IHasGui)neighbour).func_70005_c_()) + '\n' + TextFormatting.DARK_GRAY + Localization.translate(this.getSideName());
                }
            }));
        }
    }

    protected int getX(EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return 150 - (side.func_176745_a() + 1) * 18;
        }
        return 150;
    }

    protected int getY(EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            side = EnumFacing.EAST;
        }
        return 7 + (side.func_176745_a() + 4) % 6 * 18;
    }

    @Override
    protected ResourceLocation getTexture() {
        return CRAFTING_TABLE_GUI;
    }
}

