/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.leg;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IExplosionPowerOverride;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.energy.tile.IOverloadHandler;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IWorldTickCallback;
import ic2.core.TickHandler;
import ic2.core.WorldData;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.energy.leg.EnergyPath;
import ic2.core.energy.leg.Tile;
import ic2.core.util.LogCategory;
import ic2.core.util.Tuple;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class EnergyNetLocalLeg {
    private boolean ignoreBlockUpdates = false;
    private final Map<Tile, List<EnergyPath>> energySourceToEnergyPathMap = new HashMap<Tile, List<EnergyPath>>();
    private final Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new HashMap<EntityLivingBase, Integer>();
    private final Map<Tile, Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>>> pathCache = new HashMap<Tile, Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>>>();
    private final Set<BlockPos> blocksToUpdate = new HashSet<BlockPos>();
    final Map<BlockPos, Tile> registeredTiles = new HashMap<BlockPos, Tile>();
    private final World world;
    private final List<IEnergySource> sources = new ArrayList<IEnergySource>();
    private static int apiDemandsErrorCooldown = 0;
    private static int apiEmitErrorCooldown = 0;
    private static final double minConductionLoss = 1.0E-4;
    private long crashPrevented = 0L;
    private static final long logSuppressionTimeout = 300000000000L;
    private final Map<String, Long> recentLogs = new HashMap<String, Long>();

    public EnergyNetLocalLeg(World world) {
        this.world = world;
    }

    public static EnergyNetLocalLeg getForWorld(World world) {
        if (world.field_72995_K) {
            throw new IllegalStateException("not applicable clientside");
        }
        WorldData worldData = WorldData.get(world);
        return worldData.energyNetLeg;
    }

    synchronized void tickEnd() {
        IC2.platform.profilerStartSection("EnergyNet");
        block0: for (int i = 0; i < this.sources.size(); ++i) {
            Tile tile;
            Object source1;
            ArrayList<Object> list;
            IEnergySource source = this.sources.get(i);
            if (source instanceof IMetaDelegate) {
                list = new ArrayList<IEnergyTile>(((IMetaDelegate)((Object)source)).getSubTiles());
            } else {
                list = new ArrayList<IEnergySource>(1);
                list.add(source);
            }
            int amount = 1;
            if (source instanceof IMultiEnergySource && (source1 = (IMultiEnergySource)source).sendMultipleEnergyPackets()) {
                amount = source1.getMultipleEnergyPacketAmount();
            }
            source1 = list.iterator();
            while (source1.hasNext()) {
                IEnergyTile sub = (IEnergyTile)source1.next();
                tile = this.registeredTiles.get(EnergyNet.instance.getPos(sub));
                List<EnergyPath> paths = this.energySourceToEnergyPathMap.get(tile);
                if (paths == null) continue;
                for (EnergyPath path : this.energySourceToEnergyPathMap.get(tile)) {
                    path.energyConducted = 0L;
                    path.maxPacketConducted = 0;
                }
            }
            int packet = 0;
            while (packet < amount && !list.isEmpty()) {
                IEnergyTile currentSubTile = (IEnergyTile)list.get(this.world.field_73012_v.nextInt(list.size()));
                tile = this.registeredTiles.get(EnergyNet.instance.getPos(currentSubTile));
                if (tile == null) {
                    ++this.crashPrevented;
                    this.logWarn("No tile found for " + currentSubTile + " at " + Util.formatPosition((IBlockAccess)this.world, EnergyNet.instance.getPos(currentSubTile)) + ". Crash prevented " + this.crashPrevented + " times.");
                    list.remove(currentSubTile);
                    continue;
                }
                int offer = (int)source.getOfferedEnergy();
                if (offer <= 0) continue block0;
                int unused = this.emitEnergyFrom(tile, offer);
                if (unused < offer) {
                    source.drawEnergy(offer - unused);
                    ++packet;
                    continue;
                }
                list.remove(currentSubTile);
            }
        }
        if (this.world.field_73011_w.getDimension() == 0) {
            if (apiDemandsErrorCooldown > 0) {
                --apiDemandsErrorCooldown;
            }
            if (apiEmitErrorCooldown > 0) {
                --apiEmitErrorCooldown;
            }
        }
        IC2.platform.profilerEndSection();
    }

    synchronized void tickStart() {
        IC2.platform.profilerEndStartSection("EnergyNet");
        for (Map.Entry<EntityLivingBase, Integer> entry : this.entityLivingToShockEnergyMap.entrySet()) {
            EntityLivingBase target = entry.getKey();
            int damage = (entry.getValue() + 63) / 64;
            if (!target.func_70089_S() || damage <= 0) continue;
            target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
        }
        this.entityLivingToShockEnergyMap.clear();
        this.ignoreBlockUpdates = true;
        for (BlockPos pos : this.blocksToUpdate) {
            if (!this.world.func_175667_e(pos)) continue;
            this.world.func_180496_d(pos, this.world.func_180495_p(pos).func_177230_c());
        }
        this.blocksToUpdate.clear();
        this.ignoreBlockUpdates = false;
        IC2.platform.profilerEndSection();
    }

    public synchronized void addTileEntity(IEnergyTile te) {
        if (te instanceof TileEntity && ((TileEntity)te).func_145837_r()) {
            IC2.log.debug(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + te + " is invalid (TileEntity.isInvalid()), aborting");
            return;
        }
        BlockPos coords = EnergyNet.instance.getPos(te);
        World world = EnergyNet.instance.getWorld(te);
        if (this.registeredTiles.containsKey(coords)) {
            IC2.log.debug(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + te + " is already added, aborting");
            return;
        }
        IBlockState state = world.func_180495_p(coords);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, coords)) {
            IC2.log.debug(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + te + " was added too early, postponing");
            IC2.tickHandler.requestSingleWorldTick(world, new PostPonedAddCallback(te));
            return;
        }
        List<Object> subTiles = new LinkedList();
        subTiles = te instanceof IMetaDelegate ? ((IMetaDelegate)te).getSubTiles() : Collections.singletonList(te);
        for (IEnergyTile iEnergyTile : subTiles) {
            Tile tile = new Tile(this, te, iEnergyTile);
            BlockPos pos = EnergyNet.instance.getPos(iEnergyTile).func_185334_h();
            this.registeredTiles.put(pos, tile);
            if (te instanceof IEnergyAcceptor) {
                if (te instanceof IEnergyConductor && tile.getAmountNeighbors() < 2) {
                    this.markBlockForUpdateWithNeighbors(pos);
                    continue;
                }
                List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
                for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                    Tile srcTile = reverseEnergyPath.target;
                    if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)EnergyNetLocalLeg.getMaxOutput((IEnergySource)srcTile.entity) <= reverseEnergyPath.loss) continue;
                    this.energySourceToEnergyPathMap.remove(srcTile);
                    this.pathCache.clear();
                }
            }
            this.markBlockForUpdateWithNeighbors(pos);
        }
        if (te instanceof IEnergySource && ((IEnergySource)te).getSourceTier() > 0) {
            this.sources.add((IEnergySource)te);
        }
    }

    public synchronized void removeTileEntity(IEnergyTile te) {
        if (te == null) {
            IC2.log.debug(LogCategory.EnergyNet, "EnergyNet.removeTileEntity: te is null, aborting");
            return;
        }
        List<IEnergyTile> subTiles = te instanceof IMetaDelegate ? ((IMetaDelegate)te).getSubTiles() : Collections.singletonList(te);
        for (IEnergyTile subTile : subTiles) {
            BlockPos subPos = EnergyNet.instance.getPos(subTile);
            Tile tile = this.registeredTiles.get(subPos);
            if (tile == null) {
                IC2.log.debug(LogCategory.EnergyNet, "EnergyNet.removeTileEntity: " + te + " is already removed, aborting");
                return;
            }
            if (tile.entity instanceof IEnergyAcceptor) {
                List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
                for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                    Tile srcTile = reverseEnergyPath.target;
                    if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)EnergyNetLocalLeg.getMaxOutput((IEnergySource)srcTile.entity) <= reverseEnergyPath.loss) continue;
                    if (tile.entity instanceof IEnergyConductor) {
                        this.energySourceToEnergyPathMap.remove(srcTile);
                    } else {
                        Iterator<EnergyPath> it = this.energySourceToEnergyPathMap.get(srcTile).iterator();
                        while (it.hasNext()) {
                            if (it.next().target != tile) continue;
                            it.remove();
                            break;
                        }
                    }
                    this.pathCache.clear();
                }
            }
            if (te instanceof IEnergySource) {
                this.pathCache.clear();
                this.energySourceToEnergyPathMap.remove(tile);
            }
            tile.destroy();
            this.registeredTiles.remove(EnergyNet.instance.getPos(tile.subTile));
            this.markBlockForUpdateWithNeighbors(EnergyNet.instance.getPos(te));
        }
        if (te instanceof IEnergySource) {
            this.sources.remove(te);
        }
    }

    public synchronized int emitEnergyFrom(Tile tile, int amount) {
        IEnergyTile srcTe = tile.entity;
        if (srcTe instanceof TileEntity && ((TileEntity)srcTe).func_145837_r()) {
            this.logDebug("EnergyNet.emitEnergyFrom: " + srcTe + " is invalid (TileEntity.isInvalid()), aborting");
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(tile)) {
            this.pathCache.clear();
            this.energySourceToEnergyPathMap.put(tile, this.discover(tile, false, EnergyNetLocalLeg.getMaxOutput((IEnergySource)tile.entity)));
        }
        Vector<EnergyPath> activeEnergyPaths = new Vector<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tile)) {
            IEnergySink sink = (IEnergySink)energyPath.target.entity;
            if (!(sink.getDemandedEnergy() > 0.0) || !(energyPath.loss < (double)amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        for (int i = activeEnergyPaths.size() - amount; i > 0; --i) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        HashMap<EnergyPath, Integer> suppliedEnergyPaths = new HashMap<EnergyPath, Integer>();
        LinkedList<IEnergyTile> blocksToExplode = new LinkedList<IEnergyTile>();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            Vector<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new Vector();
            activeEnergyPaths.iterator();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                Iterator<Tile> dstTile = energyPath.target;
                IEnergySink sink = (IEnergySink)((Tile)((Object)dstTile)).entity;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    int injected = energyProvided - energyLoss;
                    int energyReturned = (int)sink.injectEnergy(energyPath.targetDirection, injected, EnergyNet.instance.getTierFromPower(injected));
                    if (energyReturned <= 0 && sink.getDemandedEnergy() > 0.0) {
                        activeEnergyPaths.add(energyPath);
                        newTotalInvLoss += 1.0 / energyPath.loss;
                        blocksToExplode.add(0, ((Tile)((Object)dstTile)).entity);
                    } else if (energyReturned >= injected) {
                        energyReturned = injected;
                        if (apiDemandsErrorCooldown == 0) {
                            apiDemandsErrorCooldown = 600;
                            IEnergyTile te = ((Tile)((Object)dstTile)).entity;
                            World world = EnergyNet.instance.getWorld(te);
                            BlockPos pos = EnergyNet.instance.getPos(te);
                            String c = (world == null ? "unknown" : Integer.valueOf(world.field_73011_w.getDimension())) + ":" + pos;
                            IC2.log.warn(LogCategory.EnergyNet, "API ERROR: " + dstTile + " (" + c + ") didn't implement demandsEnergy() properly, no energy from injectEnergy accepted (" + energyReturned + ") although demandsEnergy() requested " + (energyProvided - energyLoss) + ".");
                        }
                    }
                    energyConsumed += energyProvided - energyReturned;
                    int energyInjected = energyProvided - energyLoss - energyReturned;
                    if (!suppliedEnergyPaths.containsKey(energyPath)) {
                        suppliedEnergyPaths.put(energyPath, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath));
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        World world = EnergyNet.instance.getWorld(srcTe);
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath = (EnergyPath)entry.getKey();
            int energyInjected = (Integer)entry.getValue();
            energyPath.energyConducted += (long)energyInjected;
            energyPath.maxPacketConducted = Math.max(energyPath.maxPacketConducted, energyInjected);
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (EntityLivingBase entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (Tile condTile : energyPath.conductors) {
                        IEnergyTile te = condTile.entity;
                        IEnergyConductor conductor = (IEnergyConductor)te;
                        BlockPos tilePos = EnergyNet.instance.getPos(te);
                        if (!entityLiving.func_174813_aQ().func_72326_a(new AxisAlignedBB((double)(tilePos.func_177958_n() - 1), (double)(tilePos.func_177956_o() - 1), (double)(tilePos.func_177952_p() - 1), (double)(tilePos.func_177958_n() + 2), (double)(tilePos.func_177956_o() + 2), (double)(tilePos.func_177952_p() + 2)))) continue;
                        int shockEnergy = (int)((double)energyInjected - conductor.getInsulationEnergyAbsorption());
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (conductor.getInsulationEnergyAbsorption() != (double)energyPath.minInsulationEnergyAbsorption) continue;
                        break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (Tile condTile : energyPath.conductors) {
                        IEnergyConductor conductor = (IEnergyConductor)condTile.entity;
                        if (!((double)energyInjected >= conductor.getInsulationBreakdownEnergy())) continue;
                        conductor.removeInsulation();
                        if (!(conductor.getInsulationEnergyAbsorption() < (double)energyPath.minInsulationEnergyAbsorption)) continue;
                        energyPath.minInsulationEnergyAbsorption = (int)conductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected >= energyPath.minConductorBreakdownEnergy) {
                for (Tile condTile : energyPath.conductors) {
                    IEnergyConductor conductor = (IEnergyConductor)condTile.entity;
                    if (!((double)energyInjected >= conductor.getConductorBreakdownEnergy())) continue;
                    conductor.removeConductor();
                }
            }
            if (!((double)energyInjected > EnergyNet.instance.getPowerFromTier(((IEnergySink)energyPath.target.entity).getSinkTier()))) continue;
            EnergyNetLocalLeg.explodeTile(energyPath.target.entity, EnergyNet.instance.getTierFromPower(energyInjected));
        }
        return amount;
    }

    public synchronized Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>> getEnergyPathsContaining(Tile tile) {
        if (this.pathCache.containsKey(tile)) {
            return this.pathCache.get(tile);
        }
        LinkedList<EnergyPath> in = new LinkedList<EnergyPath>();
        LinkedList<EnergyPath> out = new LinkedList<EnergyPath>();
        if (this.energySourceToEnergyPathMap.containsKey(tile)) {
            out.addAll((Collection)this.energySourceToEnergyPathMap.get(tile));
        }
        if (tile.entity instanceof IEnergyConductor || tile.entity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tile, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                Tile srcTile = reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(srcTile) || (double)EnergyNetLocalLeg.getMaxOutput((IEnergySource)srcTile.entity) <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(srcTile)) {
                    if (tile.entity instanceof IEnergySink && energyPath.target == tile) {
                        in.add(energyPath);
                        continue;
                    }
                    if (!(tile.entity instanceof IEnergyConductor) || !energyPath.conductors.contains(tile)) continue;
                    out.add(energyPath);
                    in.add(energyPath);
                }
            }
        }
        Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>> ret = new Tuple.T2<Iterable<EnergyPath>, Iterable<EnergyPath>>(in, out);
        this.pathCache.put(tile, ret);
        return ret;
    }

    private Tile getNeighbor(Tile te, EnumFacing dir) {
        return te.neighbors[dir.ordinal()];
    }

    private List<EnergyPath> discover(Tile emitter, boolean reverse, int lossLimit) {
        HashMap<Tile, EnergyBlockLink> reachedTileEntities = new HashMap<Tile, EnergyBlockLink>();
        LinkedList<Tile> tileEntitiesToCheck = new LinkedList<Tile>();
        tileEntitiesToCheck.add(emitter);
        World world = EnergyNet.instance.getWorld(emitter.subTile);
        while (!tileEntitiesToCheck.isEmpty()) {
            Tile tile = (Tile)tileEntitiesToCheck.remove();
            assert (world == EnergyNet.instance.getWorld(tile.subTile));
            if (!world.func_175667_e(EnergyNet.instance.getPos(tile.subTile))) continue;
            double currentLoss = 0.0;
            if (tile != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)tile)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers(tile, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tile == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tile.entity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tile.entity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tile) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tile)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tile, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tile.entity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tile);
                tileEntitiesToCheck.add(validReceiver.tile);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        block2: for (Map.Entry entry : reachedTileEntities.entrySet()) {
            Tile tile = (Tile)entry.getKey();
            if ((reverse || !(tile.entity instanceof IEnergySink)) && (!reverse || !(tile.entity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tile;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter.entity instanceof IEnergySource) {
                while ((tile = this.getNeighbor(tile, energyBlockLink.direction)) != emitter) {
                    if (tile.entity instanceof IEnergyConductor) {
                        IEnergyTile te = tile.entity;
                        IEnergyConductor energyConductor = (IEnergyConductor)te;
                        BlockPos pos = EnergyNet.instance.getPos(te);
                        if (pos.func_177958_n() < energyPath.minX) {
                            energyPath.minX = pos.func_177958_n();
                        }
                        if (pos.func_177956_o() < energyPath.minY) {
                            energyPath.minY = pos.func_177956_o();
                        }
                        if (pos.func_177952_p() < energyPath.minZ) {
                            energyPath.minZ = pos.func_177952_p();
                        }
                        if (pos.func_177958_n() > energyPath.maxX) {
                            energyPath.maxX = pos.func_177958_n();
                        }
                        if (pos.func_177956_o() > energyPath.maxY) {
                            energyPath.maxY = pos.func_177956_o();
                        }
                        if (pos.func_177952_p() > energyPath.maxZ) {
                            energyPath.maxZ = pos.func_177952_p();
                        }
                        energyPath.conductors.add(tile);
                        if (energyConductor.getInsulationEnergyAbsorption() < (double)energyPath.minInsulationEnergyAbsorption) {
                            energyPath.minInsulationEnergyAbsorption = (int)energyConductor.getInsulationEnergyAbsorption();
                        }
                        if (energyConductor.getInsulationBreakdownEnergy() < (double)energyPath.minInsulationBreakdownEnergy) {
                            energyPath.minInsulationBreakdownEnergy = (int)energyConductor.getInsulationBreakdownEnergy();
                        }
                        if (energyConductor.getConductorBreakdownEnergy() < (double)energyPath.minConductorBreakdownEnergy) {
                            energyPath.minConductorBreakdownEnergy = (int)energyConductor.getConductorBreakdownEnergy();
                        }
                        if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tile)) != null) continue;
                        IEnergyTile srcTe = emitter.entity;
                        IEnergyTile dstTe = energyPath.target.entity;
                        IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + srcTe + " (" + EnergyNet.instance.getPos(srcTe) + ")\nC: " + te + " (" + EnergyNet.instance.getPos(te) + ")\nR: " + dstTe + " (" + EnergyNet.instance.getPos(dstTe) + ")", new Object[0]);
                        continue;
                    }
                    IC2.log.warn(LogCategory.EnergyNet, "EnergyNet: EnergyBlockLink corrupted (" + energyPath.target.entity + " [" + EnergyNet.instance.getPos(energyPath.target.entity) + "] -> " + tile.entity + " [" + EnergyNet.instance.getPos(tile.entity) + "] -> " + emitter.entity + " [" + EnergyNet.instance.getPos(emitter.entity) + "])");
                    continue block2;
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    private List<EnergyTarget> getValidReceivers(Tile emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            Tile target = this.getNeighbor(emitter, direction);
            if (target == null) continue;
            EnumFacing inverseDirection = direction.func_176734_d();
            IEnergyEmitter emitterSource = EnergyNetLocalLeg.asEmitter(emitter);
            IEnergyAcceptor emitterSink = EnergyNetLocalLeg.asAcceptor(emitter);
            IEnergyEmitter targetSource = EnergyNetLocalLeg.asEmitter(target);
            IEnergyAcceptor targetSink = EnergyNetLocalLeg.asAcceptor(target);
            if ((reverse || emitterSource == null || targetSink == null || !emitterSource.emitsEnergyTo(targetSink, direction)) && (!reverse || emitterSink == null || targetSource == null || !emitterSink.acceptsEnergyFrom(targetSource, direction)) || (reverse || targetSink == null || emitterSource == null || !targetSink.acceptsEnergyFrom(emitterSource, inverseDirection)) && (!reverse || targetSource == null || emitterSink == null || !targetSource.emitsEnergyTo(emitterSink, inverseDirection))) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    private void markBlockForUpdate(BlockPos pos) {
        if (!this.ignoreBlockUpdates) {
            this.blocksToUpdate.add(pos.func_185334_h());
        }
    }

    private void markBlockForUpdateWithNeighbors(BlockPos pos) {
        this.markBlockForUpdate(pos);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.markBlockForUpdate(pos.func_177972_a(facing));
        }
    }

    private static int getMaxOutput(IEnergySource source) {
        return (int)EnergyNet.instance.getPowerFromTier(source.getSourceTier());
    }

    private static void explodeTile(IEnergyTile te, int tier) {
        World world = EnergyNet.instance.getWorld(te);
        List<IEnergyTile> toExplode = te instanceof IMetaDelegate ? ((IMetaDelegate)te).getSubTiles() : Collections.singletonList(te);
        for (IEnergyTile current : toExplode) {
            IExplosionPowerOverride override;
            BlockPos pos = EnergyNet.instance.getPos(current);
            TileEntity realTe = world.func_175625_s(pos);
            if (te instanceof IOverloadHandler && ((IOverloadHandler)((Object)te)).onOverload(tier) || realTe instanceof IOverloadHandler && ((IOverloadHandler)realTe).onOverload(tier)) continue;
            float power = 2.5f;
            if (te instanceof IExplosionPowerOverride) {
                override = (IExplosionPowerOverride)((Object)te);
                if (!override.shouldExplode()) continue;
                power = override.getExplosionPower(tier, power);
            } else if (realTe instanceof IExplosionPowerOverride) {
                override = (IExplosionPowerOverride)realTe;
                if (!override.shouldExplode()) continue;
                power = override.getExplosionPower(tier, power);
            }
            EntityPlayer closestPlayer = world.func_184137_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 20.0, false);
            if (closestPlayer != null) {
                IC2.achievements.issueAchievement(closestPlayer, "explodeMachine");
            }
            world.func_175698_g(pos);
            ExplosionIC2 explosion = new ExplosionIC2(world, null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, power, 0.75f);
            explosion.doExplosion();
        }
    }

    private static IEnergyAcceptor asAcceptor(Tile tile) {
        if (tile.subTile instanceof IEnergyAcceptor) {
            return (IEnergyAcceptor)tile.subTile;
        }
        if (tile.entity instanceof IEnergyAcceptor) {
            return (IEnergyAcceptor)tile.entity;
        }
        return null;
    }

    private static IEnergyEmitter asEmitter(Tile tile) {
        if (tile.subTile instanceof IEnergyEmitter) {
            return (IEnergyEmitter)tile.subTile;
        }
        if (tile.entity instanceof IEnergyEmitter) {
            return (IEnergyEmitter)tile.entity;
        }
        return null;
    }

    private void logDebug(String msg) {
        if (!this.shouldLog(msg)) {
            return;
        }
        IC2.log.debug(LogCategory.EnergyNet, msg);
        if (EnergyNetGlobal.debugTileManagement) {
            IC2.log.debug(LogCategory.EnergyNet, new Throwable(), "stack trace");
            if (TickHandler.getLastDebugTrace() != null) {
                IC2.log.debug(LogCategory.EnergyNet, TickHandler.getLastDebugTrace(), "parent stack trace");
            }
        }
    }

    private void logWarn(String msg) {
        if (!this.shouldLog(msg)) {
            return;
        }
        IC2.log.warn(LogCategory.EnergyNet, msg);
        if (EnergyNetGlobal.debugTileManagement) {
            IC2.log.debug(LogCategory.EnergyNet, new Throwable(), "stack trace");
            if (TickHandler.getLastDebugTrace() != null) {
                IC2.log.debug(LogCategory.EnergyNet, TickHandler.getLastDebugTrace(), "parent stack trace");
            }
        }
    }

    private boolean shouldLog(String msg) {
        long time;
        Long lastLog;
        if (EnergyNetGlobal.logAll) {
            return true;
        }
        if (this.recentLogs.size() >= 100) {
            long minTime = System.nanoTime() - 300000000000L;
            Iterator<Long> it = this.recentLogs.values().iterator();
            while (it.hasNext()) {
                long recTime = it.next();
                if (recTime >= minTime) continue;
                it.remove();
            }
        }
        return (lastLog = this.recentLogs.put(msg = msg.replaceAll("@[0-9a-f]+", "@x"), time = System.nanoTime())) == null || lastLog < time - 300000000000L;
    }

    private static class EnergyTarget {
        Tile tile;
        EnumFacing direction;

        EnergyTarget(Tile tile, EnumFacing direction) {
            this.tile = tile;
            this.direction = direction;
        }
    }

    private static class EnergyBlockLink {
        EnumFacing direction;
        double loss;

        EnergyBlockLink(EnumFacing direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    private static class PostPonedAddCallback
    implements IWorldTickCallback {
        private final IEnergyTile te;

        public PostPonedAddCallback(IEnergyTile te) {
            this.te = te;
        }

        @Override
        public void onTick(World world) {
            BlockPos pos = EnergyNet.instance.getPos(this.te);
            IBlockState state = world.func_180495_p(pos);
            if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
                EnergyNetLocalLeg.getForWorld(world).addTileEntity(this.te);
            } else {
                IC2.log.debug(LogCategory.EnergyNet, "EnergyNet.addTileEntity: " + this.te + " unloaded, aborting");
            }
        }
    }
}

