/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import ic2.core.GuiIC2;
import ic2.core.gui.GuiElement;
import ic2.core.gui.IEnableHandler;
import ic2.core.gui.MouseButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;

public class TextBox
extends GuiElement<TextBox> {
    protected String text;
    protected boolean focused;
    protected int cursor;
    protected int cursorTick;
    protected int scrollOffset;
    protected int selectionEnd;
    protected int maxTextLength = 32;
    protected IEnableHandler enableHandler;
    protected Predicate<String> validator = Predicates.alwaysTrue();
    protected final boolean drawBackground;
    protected static final int enabledColour = 0xE0E0E0;
    protected static final int disabledColour = 0x707070;
    protected static final int invalidColour = -3092272;

    public TextBox(GuiIC2<?> gui, int x, int y, int width, int height) {
        this(gui, x, y, width, height, "");
    }

    public TextBox(GuiIC2<?> gui, int x, int y, int width, int height, String text) {
        this(gui, x, y, width, height, text, true);
    }

    public TextBox(GuiIC2<?> gui, int x, int y, int width, int height, boolean drawBackground) {
        this(gui, x, y, width, height, "", drawBackground);
    }

    public TextBox(GuiIC2<?> gui, int x, int y, int width, int height, String text, boolean drawBackground) {
        super(gui, x, y, width, height);
        this.text = text;
        this.drawBackground = drawBackground;
        this.selectionEnd = this.cursor = text.length();
    }

    public TextBox withTextEnableHandler(IEnableHandler enableHandler) {
        this.enableHandler = enableHandler;
        return this;
    }

    public TextBox withTextValidator(Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public boolean willDraw() {
        return this.enableHandler == null || this.enableHandler.isEnabled();
    }

    public void setFocused(boolean focused) {
        if (focused && !this.focused) {
            this.cursorTick = 0;
        }
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setMaxTextLength(int length) {
        if (length >= 0) {
            this.maxTextLength = length;
        }
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.cursorTick;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        super.drawBackground(mouseX, mouseY);
        if (this.drawBackground) {
            this.gui.drawColoredRect(this.x - 1, this.y - 1, this.width + 2, this.height + 2, -6250336);
            this.gui.drawColoredRect(this.x, this.y, this.width, this.height, -16777216);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        int colour = this.willDraw() ? 0xE0E0E0 : 0x707070;
        int textOffset = this.cursor - this.scrollOffset;
        int selectionOffset = this.selectionEnd - this.scrollOffset;
        String text = this.gui.trimStringToWidth(this.text.substring(this.scrollOffset), this.drawBackground ? this.width - 8 : this.width);
        boolean validOffset = textOffset >= 0 && textOffset <= text.length();
        int[] size = this.gui.getSize();
        int xStartPos = (this.drawBackground ? this.x + 4 : this.x) - size[0];
        int yPos = (this.drawBackground ? this.y + (this.height - 8) / 2 : this.y) - size[1];
        int xPos = xStartPos;
        if (selectionOffset > text.length()) {
            selectionOffset = text.length();
        }
        if (!text.isEmpty()) {
            xPos = this.gui.drawString(xStartPos, yPos, validOffset ? text.substring(0, textOffset) : text, colour, true);
        }
        boolean inStringOrFull = this.cursor < this.text.length() || this.text.length() >= this.maxTextLength;
        int xCursorPos = xPos;
        if (!validOffset) {
            xCursorPos = textOffset > 0 ? xStartPos + this.width : xStartPos;
        } else if (inStringOrFull) {
            xCursorPos = xPos - 1;
            --xPos;
        }
        if (!text.isEmpty() && validOffset && textOffset < text.length()) {
            xPos = this.gui.drawString(xPos, yPos, text.substring(textOffset), colour, true);
        }
        if (this.focused && this.cursorTick / 6 % 2 == 0 && validOffset) {
            if (inStringOrFull) {
                this.gui.drawColoredRect(xCursorPos, yPos - 1, 1, 10, -3092272);
            } else {
                this.gui.drawString(xCursorPos, yPos, "_", colour, true);
            }
        }
        if (selectionOffset != textOffset) {
            int selectionEnd = xStartPos + this.gui.getStringWidth(text.substring(0, selectionOffset));
            this.drawHighlightedArea(xCursorPos, yPos - 1, selectionEnd - 1, yPos + 1 + 8);
        }
    }

    protected void drawHighlightedArea(int startX, int startY, int endX, int endY) {
        int temp;
        if (startX < endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY < endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        int[] size = this.gui.getSize();
        startX += size[0];
        startY += size[1];
        endY += size[1];
        if ((endX += size[0]) > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    @Override
    public void onMouseClick(int mouseX, int mouseY, MouseButton button, boolean onThis) {
        this.setFocused(onThis);
        if (this.focused && onThis && MouseButton.left == button) {
            int end = mouseX - this.x;
            if (this.drawBackground) {
                end -= 4;
            }
            String text = this.gui.trimStringToWidth(this.text.substring(this.scrollOffset), this.drawBackground ? this.width - 8 : this.width);
            this.setCursorPosition(this.gui.trimStringToWidth(text, end).length() + this.scrollOffset);
        }
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        if (!this.focused) {
            return super.onKeyTyped(typedChar, keyCode);
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
        } else if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
        } else if (GuiScreen.func_175279_e((int)keyCode)) {
            if (this.willDraw()) {
                this.writeText(GuiScreen.func_146277_j());
            }
        } else if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.willDraw()) {
                this.writeText("");
            }
        } else {
            switch (keyCode) {
                case 14: {
                    if (GuiScreen.func_146271_m()) {
                        if (!this.willDraw()) break;
                        this.deleteWords(-1);
                        break;
                    }
                    if (!this.willDraw()) break;
                    this.deleteFromCursor(-1);
                    break;
                }
                case 199: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(0);
                        break;
                    }
                    this.setCursorPositionStart();
                    break;
                }
                case 203: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.getNthWordFromPos(-1, this.selectionEnd));
                            break;
                        }
                        this.setSelectionPos(this.selectionEnd - 1);
                        break;
                    }
                    if (GuiScreen.func_146271_m()) {
                        this.setCursorPosition(this.getNthWordFromCursor(-1));
                        break;
                    }
                    this.moveCursorBy(-1);
                    break;
                }
                case 205: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.getNthWordFromPos(1, this.selectionEnd));
                            break;
                        }
                        this.setSelectionPos(this.selectionEnd + 1);
                        break;
                    }
                    if (GuiScreen.func_146271_m()) {
                        this.setCursorPosition(this.getNthWordFromCursor(1));
                        break;
                    }
                    this.moveCursorBy(1);
                    break;
                }
                case 207: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(this.text.length());
                        break;
                    }
                    this.setCursorPositionEnd();
                    break;
                }
                case 211: {
                    if (GuiScreen.func_146271_m()) {
                        if (!this.willDraw()) break;
                        this.deleteWords(1);
                        break;
                    }
                    if (!this.willDraw()) break;
                    this.deleteFromCursor(1);
                    break;
                }
                default: {
                    if (ChatAllowedCharacters.func_71566_a((char)typedChar) && this.willDraw()) {
                        this.writeText(String.valueOf(typedChar));
                        break;
                    }
                    return super.onKeyTyped(typedChar, keyCode);
                }
            }
        }
        return true;
    }

    public void writeText(String textToWrite) {
        int extraLength;
        StringBuilder newText = new StringBuilder();
        String cleanString = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int start = Math.min(this.cursor, this.selectionEnd);
        int end = Math.max(this.cursor, this.selectionEnd);
        int insertionPoint = this.maxTextLength - this.text.length() - (start - end);
        if (!this.text.isEmpty()) {
            newText.append(this.text.substring(0, start));
        }
        if (insertionPoint < cleanString.length()) {
            newText.append(cleanString.substring(0, insertionPoint));
            extraLength = insertionPoint;
        } else {
            newText.append(cleanString);
            extraLength = cleanString.length();
        }
        if (!this.text.isEmpty() && end < this.text.length()) {
            newText.append(this.text.substring(end));
        }
        if (this.validator.apply((Object)this.text)) {
            this.text = newText.toString();
            this.moveCursorBy(start - this.selectionEnd + extraLength);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursor) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursor);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursor) {
                this.writeText("");
            } else {
                int end;
                int start;
                if (num < 0) {
                    start = this.cursor;
                    end = this.cursor + num;
                } else {
                    start = this.cursor + num;
                    end = this.cursor;
                }
                StringBuilder newText = new StringBuilder();
                if (end >= 0) {
                    newText.append(this.text.substring(0, end));
                }
                if (start < this.text.length()) {
                    newText.append(this.text.substring(start));
                }
                if (this.validator.apply((Object)this.text)) {
                    this.text = newText.toString();
                    if (num < 0) {
                        this.moveCursorBy(num);
                    }
                }
            }
        }
    }

    protected int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursor);
    }

    protected int getNthWordFromPos(int numWords, int position) {
        return this.getNthWordFromPosWS(numWords, position, true);
    }

    protected int getNthWordFromPosWS(int numWords, int position, boolean skipWs) {
        boolean positive = numWords >= 0;
        int absN = Math.abs(numWords);
        for (int k = 0; k < absN; ++k) {
            if (positive) {
                int end = this.text.length();
                if ((position = this.text.indexOf(32, position)) == -1) {
                    position = end;
                    continue;
                }
                while (skipWs && position < end && this.text.charAt(position) == ' ') {
                    ++position;
                }
                continue;
            }
            while (skipWs && position > 0 && this.text.charAt(position - 1) == ' ') {
                --position;
            }
            while (position > 0 && this.text.charAt(position - 1) != ' ') {
                --position;
            }
        }
        return position;
    }

    public String getSelectedText() {
        return this.text.substring(Math.min(this.cursor, this.selectionEnd), Math.max(this.cursor, this.selectionEnd));
    }

    protected void setCursorPositionStart() {
        this.setCursorPosition(0);
    }

    protected void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    protected void moveCursorBy(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    protected void setCursorPosition(int position) {
        this.cursor = MathHelper.func_76125_a((int)position, (int)0, (int)this.text.length());
        this.setSelectionPos(this.cursor);
    }

    protected void setSelectionPos(int position) {
        int textLength = this.text.length();
        this.selectionEnd = position = MathHelper.func_76125_a((int)position, (int)0, (int)textLength);
        if (this.scrollOffset > textLength) {
            this.scrollOffset = textLength;
        }
        int width = this.drawBackground ? this.width - 8 : this.width;
        int maxPosition = this.gui.trimStringToWidth(this.text.substring(this.scrollOffset), width).length() + this.scrollOffset;
        if (position == this.scrollOffset) {
            this.scrollOffset -= this.gui.trimStringToWidthReverse(this.text, width).length();
        }
        if (position > maxPosition) {
            this.scrollOffset += position - maxPosition;
        } else if (position <= this.scrollOffset) {
            this.scrollOffset -= this.scrollOffset - position;
        }
        this.scrollOffset = MathHelper.func_76125_a((int)this.scrollOffset, (int)0, (int)textLength);
    }
}

