/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import ic2.core.IC2;
import ic2.core.Ic2Player;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.util.LogCategory;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class StackUtil {
    private static final int[] emptySlotArray = new int[0];
    static final Set<String> ignoredNbtKeys = new HashSet<String>(Arrays.asList("damage", "charge", "energy", "advDmg"));

    public static boolean isInventoryTile(TileEntity te, EnumFacing side) {
        return te instanceof IInventory || te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static AdjacentInv getAdjacentInventory(TileEntity source, EnumFacing dir) {
        GameProfile srcOwner;
        TileEntity target = source.func_145831_w().func_175625_s(source.func_174877_v().func_177972_a(dir));
        if (!StackUtil.isInventoryTile(target, dir)) {
            return null;
        }
        if (target instanceof IPersonalBlock && source instanceof IPersonalBlock && (srcOwner = ((IPersonalBlock)source).getOwner()) != null) {
            return new PersonalAdjacentInv(target, dir, srcOwner);
        }
        if (target instanceof TileEntityChest && Blocks.field_150486_ae.func_180676_d(target.func_145831_w(), target.func_174877_v()) == null) {
            return null;
        }
        return new AdjacentInv(target, dir);
    }

    public static List<AdjacentInv> getAdjacentInventories(TileEntity source) {
        ArrayList<AdjacentInv> inventories = new ArrayList<AdjacentInv>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            AdjacentInv inventory = StackUtil.getAdjacentInventory(source, dir);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        Collections.sort(inventories, new Comparator<AdjacentInv>(){

            @Override
            public int compare(AdjacentInv a, AdjacentInv b) {
                if (a.te instanceof IPersonalBlock || !(b.te instanceof IPersonalBlock)) {
                    return -1;
                }
                if (b.te instanceof IPersonalBlock || !(a.te instanceof IPersonalBlock)) {
                    return 1;
                }
                return StackUtil.getInventorySize(b.te, b.dir.func_176734_d(), b.getAccessor()) - StackUtil.getInventorySize(a.te, a.dir.func_176734_d(), a.getAccessor());
            }
        });
        return inventories;
    }

    public static GameProfile getOwner(TileEntity te) {
        if (te instanceof IPersonalBlock) {
            return ((IPersonalBlock)te).getOwner();
        }
        return null;
    }

    public static int getInventorySize(TileEntity te, EnumFacing side, GameProfile accessor) {
        if (te instanceof IInventory) {
            IInventory inv = StackUtil.getInventory(te, accessor);
            return inv == null ? 0 : inv.func_70302_i_();
        }
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (handler == null) {
                return 0;
            }
            return handler.getSlots();
        }
        return 0;
    }

    private static IInventory getInventory(TileEntity te, GameProfile accessor) {
        if (te instanceof TileEntityChest) {
            return Blocks.field_150486_ae.func_180676_d(te.func_145831_w(), te.func_174877_v());
        }
        if (te instanceof IPersonalBlock) {
            return ((IPersonalBlock)te).getPrivilegedInventory(accessor);
        }
        if (te instanceof IInventory) {
            return (IInventory)te;
        }
        return null;
    }

    public static int distribute(TileEntity source, ItemStack stack, boolean simulate) {
        int transferred = 0;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            int amount = StackUtil.putInInventory(source, inventory, stack, simulate);
            transferred += amount;
            stack.field_77994_a -= amount;
            if (stack.field_77994_a != 0) continue;
            break;
        }
        stack.field_77994_a += transferred;
        return transferred;
    }

    public static ItemStack fetch(TileEntity source, ItemStack stack, boolean simulate) {
        ItemStack ret = null;
        int oldStackSize = stack.field_77994_a;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            ItemStack transferred = StackUtil.getFromInventory(source, inventory, stack, true, simulate);
            if (transferred == null) continue;
            if (ret == null) {
                ret = transferred;
            } else {
                ret.field_77994_a += transferred.field_77994_a;
                stack.field_77994_a -= transferred.field_77994_a;
            }
            if (stack.field_77994_a > 0) continue;
            break;
        }
        stack.field_77994_a = oldStackSize;
        return ret;
    }

    public static int transfer(TileEntity src, TileEntity dst, EnumFacing dir, int amount) {
        if (amount <= 0) {
            return 0;
        }
        GameProfile srcOwner = StackUtil.getOwner(src);
        GameProfile dstOwner = StackUtil.getOwner(dst);
        EnumFacing reverseDir = dir.func_176734_d();
        int[] srcSlots = StackUtil.getInventorySlots(src, dir, false, true, dstOwner);
        if (srcSlots.length == 0) {
            return 0;
        }
        int[] dstSlots = StackUtil.getInventorySlots(dst, reverseDir, true, false, srcOwner);
        if (dstSlots.length == 0) {
            return 0;
        }
        if (src instanceof IInventory) {
            IInventory srcInv = StackUtil.getInventory(src, dstOwner);
            if (srcInv == null) {
                return 0;
            }
            if (dst instanceof IInventory) {
                IInventory dstInv = StackUtil.getInventory(dst, srcOwner);
                if (dstInv == null) {
                    return 0;
                }
                return StackUtil.transfer(srcInv, srcSlots, dstInv, dstSlots, dir, reverseDir, amount);
            }
            if (dst.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) {
                IItemHandler dstHandler = (IItemHandler)dst.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                if (dstHandler == null) {
                    return 0;
                }
                return StackUtil.transfer(srcInv, srcSlots, dstHandler, dstSlots, reverseDir, amount);
            }
            return 0;
        }
        if (src.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
            IItemHandler srcHandler = (IItemHandler)src.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
            if (srcHandler == null) {
                return 0;
            }
            if (dst instanceof IInventory) {
                IInventory dstInv = StackUtil.getInventory(dst, srcOwner);
                if (dstInv == null) {
                    return 0;
                }
                return StackUtil.transfer(srcHandler, srcSlots, dstInv, dstSlots, reverseDir, amount);
            }
            if (dst.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) {
                IItemHandler dstHandler = (IItemHandler)dst.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                if (dstHandler == null) {
                    return 0;
                }
                return StackUtil.transfer(srcHandler, srcSlots, dstHandler, dstSlots, amount);
            }
            return 0;
        }
        return 0;
    }

    private static int transfer(IInventory src, int[] srcSlots, IInventory dst, int[] dstSlots, EnumFacing dir, EnumFacing reverseDir, int amount) {
        ISidedInventory dstSided = dst instanceof ISidedInventory ? (ISidedInventory)dst : null;
        int total = amount;
        for (int srcSlot : srcSlots) {
            ItemStack srcStack = src.func_70301_a(srcSlot);
            if (srcStack == null) continue;
            int origSrcAmount = srcStack.field_77994_a;
            StackUtil.insert(srcStack, dst, dstSided, reverseDir, dstSlots);
            if (srcStack.field_77994_a >= origSrcAmount) continue;
            amount -= origSrcAmount - srcStack.field_77994_a;
            if (srcStack.field_77994_a <= 0) {
                src.func_70299_a(srcSlot, null);
            }
            if (amount <= 0) break;
        }
        amount = total - amount;
        assert (amount >= 0);
        if (amount > 0) {
            src.func_70296_d();
            dst.func_70296_d();
        }
        return amount;
    }

    private static int transfer(IItemHandler src, int[] srcSlots, IInventory dst, int[] dstSlots, EnumFacing reverseDir, int amount) {
        ISidedInventory dstSided = dst instanceof ISidedInventory ? (ISidedInventory)dst : null;
        int total = amount;
        for (int srcSlot : srcSlots) {
            ItemStack srcStack = src.extractItem(srcSlot, amount, true);
            if (srcStack == null) continue;
            int origSrcAmount = srcStack.field_77994_a;
            StackUtil.insert(srcStack, dst, dstSided, reverseDir, dstSlots);
            if (srcStack.field_77994_a >= origSrcAmount) continue;
            src.extractItem(srcSlot, origSrcAmount - srcStack.field_77994_a, false);
            if ((amount -= origSrcAmount - srcStack.field_77994_a) <= 0) break;
        }
        amount = total - amount;
        assert (amount >= 0);
        if (amount > 0) {
            dst.func_70296_d();
        }
        return amount;
    }

    private static void insert(ItemStack stack, IInventory dst, ISidedInventory dstSided, EnumFacing side, int[] dstSlots) {
        for (int pass = 0; pass < 2; ++pass) {
            for (int i = 0; i < dstSlots.length; ++i) {
                int amount;
                int dstSlot = dstSlots[i];
                if (dstSlot < 0) continue;
                ItemStack dstStack = dst.func_70301_a(dstSlot);
                if (pass == 0 && (dstStack == null || !StackUtil.checkItemEqualityStrict(stack, dstStack)) || pass == 1 && dstStack != null || !dst.func_94041_b(dstSlot, stack) || dstSided != null && !dstSided.func_180462_a(dstSlot, stack, side)) continue;
                if (dstStack == null) {
                    amount = Math.min(stack.field_77994_a, dst.func_70297_j_());
                    dst.func_70299_a(dstSlot, StackUtil.copyWithSize(stack, amount));
                } else {
                    amount = Math.min(stack.field_77994_a, Math.min(dstStack.func_77976_d(), dst.func_70297_j_()) - dstStack.field_77994_a);
                    if (amount <= 0) {
                        dstSlots[i] = -1;
                        continue;
                    }
                    dstStack.field_77994_a += amount;
                }
                assert (amount > 0);
                stack.field_77994_a -= amount;
                if (stack.field_77994_a > 0) continue;
                return;
            }
        }
    }

    private static int transfer(IItemHandler src, int[] srcSlots, IItemHandler dst, int[] dstSlots, int amount) {
        int total = amount;
        for (int srcSlot : srcSlots) {
            ItemStack srcStack = src.extractItem(srcSlot, amount, true);
            if (srcStack == null) continue;
            int origSrcAmount = srcStack.field_77994_a;
            StackUtil.insert(srcStack, dst, dstSlots);
            if (srcStack.field_77994_a >= origSrcAmount) continue;
            src.extractItem(srcSlot, origSrcAmount - srcStack.field_77994_a, false);
            if ((amount -= origSrcAmount - srcStack.field_77994_a) <= 0) break;
        }
        amount = total - amount;
        assert (amount >= 0);
        return amount;
    }

    private static int transfer(IInventory src, int[] srcSlots, IItemHandler dst, int[] dstSlots, EnumFacing dir, int amount) {
        int total = amount;
        for (int srcSlot : srcSlots) {
            ItemStack srcStack = src.func_70301_a(srcSlot);
            if (srcStack == null) continue;
            int origSize = srcStack.field_77994_a;
            if (srcStack.field_77994_a > amount) {
                srcStack.field_77994_a = amount;
            }
            int transferSize = srcStack.field_77994_a;
            StackUtil.insert(srcStack, dst, dstSlots);
            amount -= transferSize - srcStack.field_77994_a;
            srcStack.field_77994_a = origSize - (transferSize - srcStack.field_77994_a);
            if (srcStack.field_77994_a > 0) continue;
            src.func_70299_a(srcSlot, null);
        }
        amount = total - amount;
        assert (amount >= 0);
        if (amount > 0) {
            src.func_70296_d();
        }
        return amount;
    }

    private static void insert(ItemStack stack, IItemHandler dst, int[] dstSlots) {
        for (int pass = 0; pass < 2; ++pass) {
            for (int i = 0; i < dstSlots.length; ++i) {
                int dstSlot = dstSlots[i];
                if (dstSlot < 0) continue;
                ItemStack dstStack = dst.getStackInSlot(dstSlot);
                if (pass == 0 && (dstStack == null || dstStack.field_77994_a <= 0 || !StackUtil.checkItemEqualityStrict(stack, dstStack)) || pass == 1 && dstStack != null) continue;
                ItemStack remaining = dst.insertItem(dstSlot, stack, false);
                if (remaining == null || remaining.field_77994_a <= 0) {
                    stack.field_77994_a = 0;
                    return;
                }
                if (remaining.field_77994_a >= stack.field_77994_a) continue;
                stack.field_77994_a = remaining.field_77994_a;
            }
        }
    }

    public static void distributeDrops(TileEntity source, List<ItemStack> stacks) {
        Iterator<ItemStack> it = stacks.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            int amount = StackUtil.distribute(source, stack, false);
            if (amount == stack.field_77994_a) {
                it.remove();
                continue;
            }
            stack.field_77994_a -= amount;
        }
        for (ItemStack stack : stacks) {
            StackUtil.dropAsEntity(source.func_145831_w(), source.func_174877_v(), stack);
        }
        stacks.clear();
    }

    private static ItemStack getFromInventory(TileEntity source, AdjacentInv inventory, ItemStack stack, boolean ignoreMaxStackSize, boolean simulate) {
        return StackUtil.getFromInventory(inventory.te, inventory.dir.func_176734_d(), stack, stack.field_77994_a, ignoreMaxStackSize, inventory.getAccessor(), simulate);
    }

    public static ItemStack getFromInventory(TileEntity te, EnumFacing side, ItemStack stackDestination, int max, boolean ignoreMaxStackSize, boolean simulate) {
        return StackUtil.getFromInventory(te, side, stackDestination, max, ignoreMaxStackSize, null, simulate);
    }

    public static ItemStack getFromInventory(TileEntity te, EnumFacing side, ItemStack stackDestination, int max, boolean ignoreMaxStackSize, GameProfile accessor, boolean simulate) {
        int[] slots;
        if (stackDestination != null && !ignoreMaxStackSize) {
            max = Math.min(max, stackDestination.func_77976_d() - stackDestination.field_77994_a);
        }
        if ((slots = StackUtil.getInventorySlots(te, side, false, true, accessor)).length == 0) {
            return null;
        }
        ItemStack ret = null;
        if (te instanceof IInventory) {
            IInventory inv = StackUtil.getInventory(te, accessor);
            if (inv == null) {
                return null;
            }
            for (int slot : slots) {
                if (max <= 0) break;
                ItemStack stack = inv.func_70301_a(slot);
                assert (stack != null);
                if (stackDestination != null && !StackUtil.checkItemEqualityStrict(stack, stackDestination)) continue;
                if (ret == null) {
                    ret = StackUtil.copyWithSize(stack, 0);
                    if (stackDestination == null) {
                        if (!ignoreMaxStackSize) {
                            max = Math.min(max, ret.func_77976_d());
                        }
                        stackDestination = ret;
                    }
                }
                int transfer = Math.min(max, stack.field_77994_a);
                if (!simulate) {
                    stack.field_77994_a -= transfer;
                    if (stack.field_77994_a == 0) {
                        inv.func_70299_a(slot, null);
                    }
                }
                max -= transfer;
                ret.field_77994_a += transfer;
            }
            if (!simulate && ret != null) {
                inv.func_70296_d();
            }
        } else if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (handler == null) {
                return null;
            }
            for (int slot : slots) {
                ItemStack stack;
                if (max <= 0) break;
                if (stackDestination != null && ((stack = handler.getStackInSlot(slot)) == null || !StackUtil.checkItemEqualityStrict(stack, stackDestination)) || (stack = handler.extractItem(slot, max, simulate)) == null || stack.field_77994_a <= 0) continue;
                if (ret == null) {
                    ret = StackUtil.copyWithSize(stack, 0);
                    if (stackDestination == null) {
                        if (!ignoreMaxStackSize) {
                            max = Math.min(max, ret.func_77976_d());
                        }
                        stackDestination = ret;
                    }
                } else assert (StackUtil.checkItemEqualityStrict(stack, ret));
                max -= stack.field_77994_a;
                ret.field_77994_a += stack.field_77994_a;
            }
        }
        return ret;
    }

    private static int putInInventory(TileEntity source, AdjacentInv inventory, ItemStack stackSource, boolean simulate) {
        return StackUtil.putInInventory(inventory.te, inventory.dir.func_176734_d(), stackSource, inventory.getAccessor(), simulate);
    }

    public static int putInInventory(TileEntity te, EnumFacing side, ItemStack stackSource, boolean simulate) {
        return StackUtil.putInInventory(te, side, stackSource, null, simulate);
    }

    public static int putInInventory(TileEntity te, EnumFacing side, ItemStack stackSource, GameProfile accessor, boolean simulate) {
        if (stackSource == null) {
            return 0;
        }
        int[] slots = StackUtil.getInventorySlots(te, side, true, false, accessor);
        if (slots.length == 0) {
            return 0;
        }
        if (te instanceof IInventory) {
            int transfer;
            ItemStack stack;
            IInventory inv = StackUtil.getInventory(te, accessor);
            if (inv == null) {
                return 0;
            }
            int toTransfer = stackSource.field_77994_a;
            for (int slot : slots) {
                if (toTransfer <= 0) break;
                if (!inv.func_94041_b(slot, stackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_180462_a(slot, stackSource, side) || (stack = inv.func_70301_a(slot)) == null || !StackUtil.checkItemEqualityStrict(stack, stackSource)) continue;
                transfer = Math.min(toTransfer, Math.min(inv.func_70297_j_(), stack.func_77976_d()) - stack.field_77994_a);
                if (!simulate) {
                    stack.field_77994_a += transfer;
                }
                toTransfer -= transfer;
            }
            for (int slot : slots) {
                if (toTransfer <= 0) break;
                if (!inv.func_94041_b(slot, stackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_180462_a(slot, stackSource, side) || (stack = inv.func_70301_a(slot)) != null) continue;
                transfer = Math.min(toTransfer, Math.min(inv.func_70297_j_(), stackSource.func_77976_d()));
                if (!simulate) {
                    ItemStack dest = StackUtil.copyWithSize(stackSource, transfer);
                    inv.func_70299_a(slot, dest);
                }
                toTransfer -= transfer;
            }
            if (!simulate && toTransfer != stackSource.field_77994_a) {
                inv.func_70296_d();
            }
            return stackSource.field_77994_a - toTransfer;
        }
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            ItemStack remaining;
            ItemStack stack;
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (handler == null) {
                return 0;
            }
            ItemStack src = stackSource.func_77946_l();
            for (int slot : slots) {
                if (src.field_77994_a <= 0) break;
                stack = handler.getStackInSlot(slot);
                if (stack == null || stack.field_77994_a <= 0) continue;
                remaining = handler.insertItem(slot, src, simulate);
                if (remaining == null) {
                    src.field_77994_a = 0;
                    continue;
                }
                if (remaining.field_77994_a >= src.field_77994_a) continue;
                src.field_77994_a = remaining.field_77994_a;
            }
            for (int slot : slots) {
                if (src.field_77994_a <= 0) break;
                stack = handler.getStackInSlot(slot);
                if (stack != null && stack.field_77994_a != 0) continue;
                remaining = handler.insertItem(slot, src, simulate);
                if (remaining == null) {
                    src.field_77994_a = 0;
                    continue;
                }
                if (remaining.field_77994_a >= src.field_77994_a) continue;
                src.field_77994_a = remaining.field_77994_a;
            }
            return stackSource.field_77994_a - src.field_77994_a;
        }
        return 0;
    }

    private static int[] getInventorySlots(TileEntity te, EnumFacing side, boolean checkInsert, boolean checkExtract, GameProfile accessor) {
        if (te instanceof IInventory) {
            int[] ret;
            ISidedInventory sidedInv;
            IInventory inv = StackUtil.getInventory(te, accessor);
            if (inv == null || inv.func_70297_j_() <= 0) {
                return emptySlotArray;
            }
            if (inv instanceof ISidedInventory) {
                sidedInv = (ISidedInventory)inv;
                ret = sidedInv.func_180463_a(side);
                if (ret.length == 0) {
                    return emptySlotArray;
                }
                ret = Arrays.copyOf(ret, ret.length);
            } else {
                int size = inv.func_70302_i_();
                if (size <= 0) {
                    return emptySlotArray;
                }
                sidedInv = null;
                ret = new int[size];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = i;
                }
            }
            if (checkInsert || checkExtract) {
                int writeIdx = 0;
                for (int readIdx = 0; readIdx < ret.length; ++readIdx) {
                    int slot = ret[readIdx];
                    ItemStack stack = inv.func_70301_a(slot);
                    if (checkExtract && (stack == null || stack.field_77994_a <= 0 || sidedInv != null && !sidedInv.func_180461_b(slot, stack, side)) || checkInsert && stack != null && (stack.field_77994_a >= stack.func_77976_d() || stack.field_77994_a >= inv.func_70297_j_() || sidedInv != null && !sidedInv.func_180462_a(slot, stack, side))) continue;
                    ret[writeIdx] = slot;
                    ++writeIdx;
                }
                if (writeIdx != ret.length) {
                    ret = Arrays.copyOf(ret, writeIdx);
                }
            }
            return ret;
        }
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (handler == null) {
                return emptySlotArray;
            }
            int size = handler.getSlots();
            if (size <= 0) {
                return emptySlotArray;
            }
            int[] ret = new int[size];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = i;
            }
            if (checkInsert || checkExtract) {
                int writeIdx = 0;
                for (int readIdx = 0; readIdx < ret.length; ++readIdx) {
                    int slot = ret[readIdx];
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (checkExtract && (stack == null || stack.field_77994_a <= 0 || handler.extractItem(slot, Integer.MAX_VALUE, true) == null) || checkInsert && !StackUtil.checkInsert(handler, slot, stack)) continue;
                    ret[writeIdx] = slot;
                    ++writeIdx;
                }
                if (writeIdx != ret.length) {
                    ret = Arrays.copyOf(ret, writeIdx);
                }
            }
            return ret;
        }
        return emptySlotArray;
    }

    private static boolean checkInsert(IItemHandler handler, int slot, ItemStack stack) {
        if (stack == null || stack.field_77994_a >= stack.func_77976_d()) {
            return true;
        }
        ItemStack result = handler.insertItem(slot, StackUtil.copyWithSize(stack, Integer.MAX_VALUE), true);
        return result == null || result.field_77994_a < Integer.MAX_VALUE;
    }

    public static boolean consumeFromPlayerInventory(EntityPlayer player, Predicate<ItemStack> request, int amount, boolean simulate) {
        ItemStack[] contents = player.field_71071_by.field_70462_a;
        for (int pass = 0; pass < 2; ++pass) {
            int amountNeeded = amount;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack stack = contents[i];
                if (!request.apply((Object)stack)) continue;
                if (player.field_71075_bZ.field_75098_d) {
                    return true;
                }
                int cAmount = Math.min(stack.field_77994_a, amountNeeded);
                amountNeeded -= cAmount;
                if (pass == 1) {
                    if (stack.field_77994_a == cAmount) {
                        contents[i] = null;
                    } else {
                        contents[i].field_77994_a -= cAmount;
                    }
                }
                if (amountNeeded <= 0) break;
            }
            if (amountNeeded > 0) {
                if (pass == 1) {
                    IC2.log.warn(LogCategory.General, "Inconsistent inventory transaction for player %s, request %s: %d missing", player, request, amountNeeded);
                }
                return false;
            }
            if (!simulate) continue;
            return true;
        }
        return true;
    }

    public static Predicate<ItemStack> sameStack(final ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null stack");
        }
        return new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return StackUtil.checkItemEquality(input, stack);
            }

            public String toString() {
                return "stack==" + stack;
            }
        };
    }

    public static Predicate<ItemStack> sameItem(final Item item) {
        if (item == null) {
            throw new NullPointerException("null item");
        }
        return new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return input.func_77973_b() == item;
            }

            public String toString() {
                return "item==" + item;
            }
        };
    }

    public static Predicate<ItemStack> sameItem(Block block) {
        if (block == null) {
            throw new NullPointerException("null block");
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            throw new IllegalArgumentException("block " + block + " doesn't have an associated item");
        }
        return StackUtil.sameItem(item);
    }

    public static ItemStack consumeFromPlayerHand(EntityPlayer player, Predicate<ItemStack> request, int amount) {
        ItemStack stack = player.func_184614_ca();
        if (stack == null || !StackUtil.check(stack)) {
            return null;
        }
        if (!request.apply((Object)stack)) {
            return null;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        if (stack.field_77994_a < amount) {
            return null;
        }
        stack.field_77994_a -= amount;
        if (stack.field_77994_a == 0) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
        }
        return stack;
    }

    public static void dropAsEntity(World world, BlockPos pos, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack.func_77946_l());
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack stack, int newSize) {
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static ItemStack copyWithWildCard(ItemStack stack) {
        ItemStack ret = stack.func_77946_l();
        StackUtil.setRawMeta(ret, Short.MAX_VALUE);
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack stack) {
        NBTTagCompound ret = stack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            stack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean checkItemEquality(ItemStack a, ItemStack b) {
        return a == b || a != null && b != null && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77960_j() == b.func_77960_j()) && StackUtil.checkNbtEquality(a, b);
    }

    public static boolean checkItemEquality(ItemStack a, Item b) {
        return a == null && b == null || a != null && b != null && a.func_77973_b() == b;
    }

    public static boolean checkItemEqualityStrict(ItemStack a, ItemStack b) {
        return a == b || a != null && b != null && a.func_77969_a(b) && StackUtil.checkNbtEqualityStrict(a, b);
    }

    private static boolean checkNbtEquality(ItemStack a, ItemStack b) {
        NBTTagCompound nbtB;
        NBTTagCompound nbtA = a.func_77978_p();
        if (nbtA == (nbtB = b.func_77978_p())) {
            return true;
        }
        Set keysA = nbtA != null ? nbtA.func_150296_c() : Collections.emptySet();
        Set keysB = nbtB != null ? nbtB.func_150296_c() : Collections.emptySet();
        HashSet<String> toCheck = new HashSet<String>(Math.max(keysA.size(), keysB.size()));
        for (String key : keysA) {
            if (ignoredNbtKeys.contains(key)) continue;
            if (!keysB.contains(key)) {
                return false;
            }
            toCheck.add(key);
        }
        for (String key : keysB) {
            if (ignoredNbtKeys.contains(key)) continue;
            if (!keysA.contains(key)) {
                return false;
            }
            toCheck.add(key);
        }
        for (String key : toCheck) {
            if (nbtA.func_74781_a(key).equals((Object)nbtB.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkNbtEqualityStrict(ItemStack a, ItemStack b) {
        NBTTagCompound nbtB;
        NBTTagCompound nbtA = a.func_77978_p();
        if (nbtA == (nbtB = b.func_77978_p())) {
            return true;
        }
        return nbtA != null && nbtB != null && nbtA.equals((Object)nbtB);
    }

    @Deprecated
    public static boolean areStacksEqual(ItemStack a, ItemStack b) {
        return a == null && b == null || a != null && b != null && !a.func_77969_a(b);
    }

    @Deprecated
    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 == null && stack2 == null || stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() && !stack1.func_77984_f() || stack1.func_77952_i() == stack2.func_77952_i());
    }

    @Deprecated
    public static boolean isStackEqualStrict(ItemStack stack1, ItemStack stack2) {
        return StackUtil.isStackEqual(stack1, stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isTagEqual(ItemStack a, ItemStack b) {
        boolean bEmpty;
        boolean aEmpty = !a.func_77942_o() || a.func_77978_p().func_82582_d();
        boolean bl = bEmpty = !b.func_77942_o() || b.func_77978_p().func_82582_d();
        if (aEmpty != bEmpty) {
            return false;
        }
        if (aEmpty) {
            return true;
        }
        return a.func_77978_p().equals((Object)b.func_77978_p());
    }

    public static ItemStack getPickStack(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        Block block = state.func_177230_c();
        RayTraceResult target = new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d((Vec3i)pos), EnumFacing.DOWN, pos);
        ItemStack ret = FMLCommonHandler.instance().getSide().isClient() ? block.getPickBlock(state, target, world, pos, player) : new ItemStack(block, 1, block.func_176201_c(state));
        if (ret == null || !StackUtil.check(ret)) {
            return null;
        }
        return ret;
    }

    public static List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return state.func_177230_c().getDrops(world, pos, state, fortune);
    }

    public static List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, EntityPlayer player, int fortune, boolean silkTouch) {
        ItemStack drop;
        Block block = state.func_177230_c();
        if (block.isAir(state, world, pos)) {
            return Collections.emptyList();
        }
        World rawWorld = null;
        if (silkTouch) {
            rawWorld = Util.getWorld(world);
            if (rawWorld == null) {
                throw new IllegalArgumentException("invalid world for silk touch: " + world);
            }
            if (player == null) {
                player = Ic2Player.get(rawWorld);
            }
        }
        if (silkTouch && block.canSilkHarvest(rawWorld, pos, state, player) && (drop = StackUtil.getPickStack(rawWorld, pos, state, player)) != null) {
            return new ArrayList<ItemStack>(Arrays.asList(drop));
        }
        return StackUtil.getDrops(world, pos, state, fortune);
    }

    public static boolean placeBlock(ItemStack stack, World world, BlockPos pos) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return false;
        }
        if (item instanceof ItemBlock || item instanceof ItemBlockSpecial) {
            int oldSize = stack.field_77994_a;
            EnumActionResult result = item.func_180614_a(stack, (EntityPlayer)Ic2Player.get(world), world, pos, EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            stack.field_77994_a = oldSize;
            return result == EnumActionResult.SUCCESS;
        }
        return false;
    }

    @Deprecated
    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    @Deprecated
    public static IBlockState getBlockState(ItemStack stack) {
        return StackUtil.getBlock(stack).func_176203_a(stack.func_77952_i());
    }

    @Deprecated
    public static boolean equals(Block block, ItemStack stack) {
        return block == StackUtil.getBlock(stack);
    }

    public static boolean damageItemStack(ItemStack stack, int amount) {
        if (stack.func_96631_a(amount, IC2.random)) {
            --stack.field_77994_a;
            stack.func_77964_b(0);
            return stack.field_77994_a <= 0;
        }
        return false;
    }

    public static boolean check2(Iterable<List<ItemStack>> list) {
        for (List<ItemStack> list2 : list) {
            if (StackUtil.check(list2)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack[] array) {
        return StackUtil.check(Arrays.asList(array));
    }

    public static boolean check(Iterable<ItemStack> list) {
        for (ItemStack stack : list) {
            if (StackUtil.check(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack stack) {
        return stack.func_77973_b() != null;
    }

    public static String toStringSafe2(Iterable<List<ItemStack>> list) {
        String ret = "[";
        for (List<ItemStack> list2 : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(list2);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack[] array) {
        return StackUtil.toStringSafe(Arrays.asList(array));
    }

    public static String toStringSafe(Iterable<ItemStack> list) {
        String ret = "[";
        for (ItemStack stack : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(stack);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return stack.field_77994_a + "x(null)@(unknown)";
        }
        return stack.toString();
    }

    @Deprecated
    public static void consumeInventoryItem(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || !player.field_71071_by.field_70462_a[i].func_77969_a(stack)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            return;
        }
    }

    public static boolean storeInventoryItem(ItemStack stack, EntityPlayer player, boolean simulate) {
        if (simulate) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack invStack = player.field_71071_by.field_70462_a[i];
                if (invStack != null && (!StackUtil.checkItemEqualityStrict(stack, invStack) || invStack.field_77994_a + stack.field_77994_a > Math.min(player.field_71071_by.func_70297_j_(), invStack.func_77976_d()))) continue;
                return true;
            }
        } else if (player.field_71071_by.func_70441_a(stack)) {
            return true;
        }
        return false;
    }

    public static int getRawMeta(ItemStack stack) {
        return Items.field_151100_aR.getDamage(stack);
    }

    public static void setRawMeta(ItemStack stack, int meta) {
        if (meta < 0) {
            throw new IllegalArgumentException("negative meta");
        }
        Items.field_151100_aR.setDamage(stack, meta);
    }

    public static void copyStack(ItemStack src, ItemStack dst) {
        dst.func_150996_a(src.func_77973_b());
        StackUtil.setRawMeta(dst, StackUtil.getRawMeta(src));
        dst.func_77982_d(src.func_77978_p());
    }

    public static class PersonalAdjacentInv
    extends AdjacentInv {
        public final GameProfile accessor;

        private PersonalAdjacentInv(TileEntity te, EnumFacing dir, GameProfile accessor) {
            super(te, dir);
            this.accessor = accessor;
        }

        @Override
        public GameProfile getAccessor() {
            return this.accessor;
        }
    }

    public static class AdjacentInv {
        public final TileEntity te;
        public final EnumFacing dir;

        private AdjacentInv(TileEntity te, EnumFacing dir) {
            this.te = te;
            this.dir = dir;
        }

        public GameProfile getAccessor() {
            return null;
        }
    }
}

