/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrade;

import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.DynamicHandHeldContainer;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiConditionProvider;
import ic2.core.gui.dynamic.IHolographicSlotProvider;
import ic2.core.item.tool.HandHeldInventory;
import ic2.core.item.upgrade.HandHeldMeta;
import ic2.core.item.upgrade.ItemUpgradeModule;
import ic2.core.network.GuiSynced;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.xml.sax.SAXException;

public class HandHeldAdvancedUpgrade
extends HandHeldInventory
implements IHolographicSlotProvider,
IGuiConditionProvider {
    @GuiSynced
    protected boolean meta;
    @GuiSynced
    protected boolean nbt;
    @GuiSynced
    protected boolean energy;
    protected static final int META_GUI = 0;
    protected static final int NBT_GUI = 1;
    protected static final int ENERGY_GUI = 2;
    protected static final ResourceLocation GUI_XML = new ResourceLocation("ic2", "guidef/advanced_upgrade.xml");
    protected static final String TRANSLATION_NAME = ItemName.upgrade.getItemStack(ItemUpgradeModule.UpgradeType.advanced_ejector).func_77977_a();

    public HandHeldAdvancedUpgrade(EntityPlayer player, ItemStack containerStack) {
        super(player, containerStack, 9);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(containerStack);
        this.meta = nbt.func_74767_n("meta");
        this.nbt = nbt.func_74767_n("nbt");
        this.energy = nbt.func_74767_n("energy");
    }

    @Override
    protected void save() {
        super.save();
        if (IC2.platform.isSimulating()) {
            NBTTagCompound nbt = this.containerStack.func_77978_p();
            assert (nbt != null);
            nbt.func_74757_a("meta", this.meta);
            nbt.func_74757_a("nbt", this.nbt);
            nbt.func_74757_a("energy", this.energy);
        }
    }

    static IHasGui delegate(EntityPlayer player, ItemStack stack, int ID) {
        switch (ID) {
            case 0: {
                return null;
            }
            case 1: {
                return new HandHeldMeta(new HandHeldAdvancedUpgrade(player, stack));
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return DynamicHandHeldContainer.create(this, player, this.getNode());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create(this, player, this.getNode());
    }

    protected GuiParser.GuiNode getNode() {
        try {
            return GuiParser.parse(GUI_XML, HandHeldAdvancedUpgrade.class);
        }
        catch (SAXException e) {
            throw new RuntimeException("XML Exception opening Advanced Upgrade GUI", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception opening Advanced Upgrade GUI", e);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String func_70005_c_() {
        return TRANSLATION_NAME;
    }

    EntityPlayer getPlayer() {
        return this.player;
    }

    ItemStack getContainerStack() {
        return this.containerStack;
    }

    @Override
    public ItemStack[] getStacksForName(String name) {
        if ("filter".equals(name)) {
            return this.inventory;
        }
        throw new IllegalArgumentException("Unexpected stack array name requested: " + name);
    }

    @Override
    public boolean getGuiState(String name) {
        if ("meta".equals(name)) {
            return this.meta;
        }
        if ("nbt".equals(name)) {
            return this.nbt;
        }
        if ("energy".equals(name)) {
            return this.energy;
        }
        throw new IllegalArgumentException("Unexpected conditional name requested: " + name);
    }

    @Override
    public void onEvent(String event) {
        System.out.println("Received event: " + event);
        if ("meta".equals(event)) {
            this.meta = !this.meta;
        } else if ("nbt".equals(event)) {
            if (!this.player.field_70170_p.field_72995_K) {
                IC2.platform.launchSubGui(this.player, new HandHeldMeta(this), 1);
            }
        } else if ("energy".equals(event)) {
            this.energy = !this.energy;
        } else {
            super.onEvent(event);
        }
    }
}

