/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui.dynamic;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.GuiIC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.invslot.InvSlot;
import ic2.core.gui.EnergyGauge;
import ic2.core.gui.FluidSlot;
import ic2.core.gui.GuiElement;
import ic2.core.gui.Image;
import ic2.core.gui.LinkedGauge;
import ic2.core.gui.SlotGrid;
import ic2.core.gui.TankGauge;
import ic2.core.gui.Text;
import ic2.core.gui.VanillaButton;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.GuiEnvironment;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IFluidTankProvider;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.gui.dynamic.TextProvider;
import ic2.core.upgrade.IUpgradableBlock;
import java.util.Collections;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class DynamicGui<T extends ContainerBase<? extends IInventory>>
extends GuiIC2<T> {
    public static <T extends IInventory> DynamicGui<ContainerBase<T>> create(T base, EntityPlayer player, GuiParser.GuiNode guiNode) {
        DynamicContainer<T> container = DynamicContainer.create(base, player, guiNode);
        return new DynamicGui<ContainerBase<T>>(player, container, guiNode);
    }

    protected DynamicGui(EntityPlayer player, T container, GuiParser.GuiNode guiNode) {
        super(container, guiNode.width, guiNode.height);
        this.initializeWidgets(player, guiNode);
    }

    private void initializeWidgets(EntityPlayer player, GuiParser.ParentNode parentNode) {
        block20: for (GuiParser.Node rawNode : parentNode.getNodes()) {
            switch (rawNode.getType()) {
                case environment: {
                    if (((GuiParser.EnvironmentNode)rawNode).environment == GuiEnvironment.GAME) break;
                    continue block20;
                }
                case key: 
                case only: {
                    break;
                }
                case button: {
                    if (!(this.container.base instanceof INetworkClientTileEntityEventListener)) {
                        throw new RuntimeException("Invalid base " + this.container.base + " for button elements");
                    }
                    GuiParser.Node node = (GuiParser.ButtonNode)rawNode;
                    parentNode.addElement(this, (GuiElement<?>)new VanillaButton(this, ((GuiParser.ButtonNode)node).x, ((GuiParser.ButtonNode)node).y, ((GuiParser.ButtonNode)node).width, ((GuiParser.ButtonNode)node).height, this.createEventSender(((GuiParser.ButtonNode)node).eventID)).withText(((GuiParser.ButtonNode)node).text.get(this.container.base, Collections.<String, TextProvider.ITextProvider>emptyMap())));
                    break;
                }
                case energygauge: {
                    if (!(this.container.base instanceof TileEntityBlock) || !((TileEntityBlock)this.container.base).hasComponent(Energy.class)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for energygauge elements");
                    }
                    GuiParser.Node node = (GuiParser.EnergyGaugeNode)rawNode;
                    parentNode.addElement(this, new EnergyGauge(this, ((GuiParser.EnergyGaugeNode)node).x, ((GuiParser.EnergyGaugeNode)node).y, (TileEntityBlock)this.container.base, ((GuiParser.EnergyGaugeNode)node).style));
                    break;
                }
                case gauge: {
                    if (!(this.container.base instanceof IGuiValueProvider)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for gauge elements");
                    }
                    GuiParser.Node node = (GuiParser.GaugeNode)rawNode;
                    parentNode.addElement(this, new LinkedGauge(this, ((GuiParser.GaugeNode)node).x, ((GuiParser.GaugeNode)node).y, (IGuiValueProvider)this.container.base, ((GuiParser.GaugeNode)node).name, ((GuiParser.GaugeNode)node).style));
                    break;
                }
                case image: {
                    GuiParser.Node node = (GuiParser.ImageNode)rawNode;
                    parentNode.addElement(this, Image.create(this, ((GuiParser.ImageNode)node).x, ((GuiParser.ImageNode)node).y, ((GuiParser.ImageNode)node).width, ((GuiParser.ImageNode)node).height, ((GuiParser.ImageNode)node).src, ((GuiParser.ImageNode)node).u, ((GuiParser.ImageNode)node).v));
                    break;
                }
                case playerinventory: {
                    GuiParser.Node node = (GuiParser.PlayerInventoryNode)rawNode;
                    parentNode.addElement(this, new SlotGrid(this, ((GuiParser.PlayerInventoryNode)node).x, ((GuiParser.PlayerInventoryNode)node).y, 9, 3, ((GuiParser.PlayerInventoryNode)node).style, 0, ((GuiParser.PlayerInventoryNode)node).spacing));
                    parentNode.addElement(this, new SlotGrid(this, ((GuiParser.PlayerInventoryNode)node).x, ((GuiParser.PlayerInventoryNode)node).y + ((GuiParser.PlayerInventoryNode)node).hotbarOffset, 9, 1, ((GuiParser.PlayerInventoryNode)node).style, 0, ((GuiParser.PlayerInventoryNode)node).spacing));
                    if (!((GuiParser.PlayerInventoryNode)node).showTitle) break;
                    parentNode.addElement(this, Text.create(this, ((GuiParser.PlayerInventoryNode)node).x + 1, ((GuiParser.PlayerInventoryNode)node).y - 10, TextProvider.ofTranslated(player.field_71071_by.func_70005_c_()), 0x404040, false));
                    break;
                }
                case slot: {
                    GuiParser.Node node = (GuiParser.SlotNode)rawNode;
                    parentNode.addElement(this, new SlotGrid(this, ((GuiParser.SlotNode)node).x, ((GuiParser.SlotNode)node).y, 1, 1, ((GuiParser.SlotNode)node).style));
                    break;
                }
                case slotgrid: {
                    if (!(this.container.base instanceof TileEntityInventory)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for slot elements");
                    }
                    GuiParser.Node node = (GuiParser.SlotGridNode)rawNode;
                    InvSlot slot = ((TileEntityInventory)this.container.base).getInvSlot(((GuiParser.SlotGridNode)node).name);
                    if (slot == null) {
                        throw new RuntimeException("invalid invslot name " + ((GuiParser.SlotGridNode)node).name + " for base " + this.container.base);
                    }
                    int size = slot.size();
                    if (size <= ((GuiParser.SlotGridNode)node).offset) break;
                    GuiParser.SlotGridNode.SlotGridDimension dim = ((GuiParser.SlotGridNode)node).getDimension(size);
                    parentNode.addElement(this, new SlotGrid(this, ((GuiParser.SlotGridNode)node).x, ((GuiParser.SlotGridNode)node).y, dim.cols, dim.rows, ((GuiParser.SlotGridNode)node).style, 0, ((GuiParser.SlotGridNode)node).spacing));
                    break;
                }
                case text: {
                    int x;
                    GuiParser.Node node = (GuiParser.TextNode)rawNode;
                    switch (((GuiParser.TextNode)node).align) {
                        case Start: {
                            x = ((GuiParser.TextNode)node).x;
                            break;
                        }
                        case Center: {
                            x = ((GuiParser.TextNode)node).x + this.field_146999_f / 2;
                            break;
                        }
                        case End: {
                            x = ((GuiParser.TextNode)node).x + this.field_146999_f;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid alignment: " + (Object)((Object)((GuiParser.TextNode)node).align));
                        }
                    }
                    Text text = ((GuiParser.TextNode)node).rightAligned ? Text.createRightAligned(this, x, ((GuiParser.TextNode)node).y, ((GuiParser.TextNode)node).width, ((GuiParser.TextNode)node).height, ((GuiParser.TextNode)node).text, ((GuiParser.TextNode)node).color, ((GuiParser.TextNode)node).shadow, ((GuiParser.TextNode)node).xOffset, ((GuiParser.TextNode)node).yOffset, ((GuiParser.TextNode)node).centerX, ((GuiParser.TextNode)node).centerY) : Text.create(this, x, ((GuiParser.TextNode)node).y, ((GuiParser.TextNode)node).width, ((GuiParser.TextNode)node).height, ((GuiParser.TextNode)node).text, ((GuiParser.TextNode)node).color, ((GuiParser.TextNode)node).shadow, ((GuiParser.TextNode)node).xOffset, ((GuiParser.TextNode)node).yOffset, ((GuiParser.TextNode)node).centerX, ((GuiParser.TextNode)node).centerY);
                    parentNode.addElement(this, text);
                    break;
                }
                case gui: {
                    break;
                }
                case fluidtank: {
                    if (!(this.container.base instanceof IFluidTankProvider)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for tank elements");
                    }
                    GuiParser.Node node = (GuiParser.FluidTankNode)rawNode;
                    parentNode.addElement(this, TankGauge.createNormal(this, ((GuiParser.FluidTankNode)node).x, ((GuiParser.FluidTankNode)node).y, ((IFluidTankProvider)this.container.base).getFluidTank(((GuiParser.FluidTankNode)node).name)));
                    break;
                }
                case fluidslot: {
                    if (!(this.container.base instanceof IFluidTankProvider)) {
                        throw new RuntimeException("invalid base " + this.container.base + " for tank elements");
                    }
                    GuiParser.Node node = (GuiParser.FluidSlotNode)rawNode;
                    parentNode.addElement(this, FluidSlot.createFluidSlot(this, ((GuiParser.FluidSlotNode)node).x, ((GuiParser.FluidSlotNode)node).y, ((IFluidTankProvider)this.container.base).getFluidTank(((GuiParser.FluidSlotNode)node).name)));
                    break;
                }
            }
            if (!(rawNode instanceof GuiParser.ParentNode)) continue;
            this.initializeWidgets(player, (GuiParser.ParentNode)rawNode);
        }
    }

    @Override
    public void addElement(GuiElement<?> element) {
        super.addElement(element);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        mouseX -= this.field_147003_i;
        mouseY -= this.field_147009_r;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiElement.bindCommonTexture();
        this.drawBackground();
        if (this.container.base instanceof IUpgradableBlock) {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("ic2", "textures/gui/infobutton.png"));
            this.drawTexturedRect(3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
        }
        for (GuiElement element : this.elements) {
            if (!element.isEnabled()) continue;
            element.drawBackground(mouseX, mouseY);
        }
    }

    private void drawBackground() {
        int side;
        this.drawTexturedRect(-16.0, -16.0, 32.0, 32.0, 0.0, 0.0);
        this.drawTexturedRect(this.field_146999_f - 16, -16.0, 32.0, 32.0, 64.0, 0.0);
        this.drawTexturedRect(-16.0, this.field_147000_g - 16, 32.0, 32.0, 0.0, 64.0);
        this.drawTexturedRect(this.field_146999_f - 16, this.field_147000_g - 16, 32.0, 32.0, 64.0, 64.0);
        for (side = 0; side < 2; ++side) {
            int y = this.field_147000_g * side - 16;
            int v = 64 * side;
            for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                int width = Math.min(32, this.field_146999_f - 16 - x);
                this.drawTexturedRect(x, y, width, 32.0, 32.0, v);
            }
        }
        for (side = 0; side < 2; ++side) {
            int x = this.field_146999_f * side - 16;
            int u = 64 * side;
            for (int y = 16; y < this.field_147000_g - 16; y += 32) {
                int height = Math.min(32, this.field_147000_g - 16 - y);
                this.drawTexturedRect(x, y, 32.0, height, u, 32.0);
            }
        }
        for (int y = 16; y < this.field_147000_g - 16; y += 32) {
            int height = Math.min(32, this.field_147000_g - 16 - y);
            for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                int width = Math.min(32, this.field_146999_f - 16 - x);
                this.drawTexturedRect(x, y, width, height, 32.0, 32.0);
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }
}

