package ic2.api.energy.tile;

/**
 * Implement with an {@link IEnergySink} tile entity to change the force of the explosion when overpowered.
 */
public interface IExplosionPowerOverride {

	/**
	 * Checks, if the electric tile should explode. If you return false here,
	 * the explosion will just not happen at all and the block will stay.
	 * This is NOT recommended.
	 * @return wether the block should explode.
	 */
	boolean shouldExplode(); //ShouldExplode should not be dependant on the tier of the power injected.

	/**
	 * The explosion force when too much power is received.
	 * @param defaultPower the default explosion power.
	 * @return The explosion power
	 */
	float getExplosionPower(int tier, float defaultPower);
}