package ic2.api.item;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public interface ILatheItem {

	/**
	 * Returns the radius of this Lathe Item
	 */
	int getWidth(ItemStack stack);

	/**
	 * Returns the current state of this Lathe Item
	 * The length of the array should be 5
	 * The value should be the current size of the item at this time.
	 * It should also not be greater than getWidth()
	 */
	int[] getCurrentState(ItemStack stack);

	/**
	 * This will set the current state of the Item on that position to that value.
	 */
	void setState(ItemStack stack, int position, int value);

	/**
	 * Returns the output Item (normally dust) when you lathe on this position.
	 */
	ItemStack getOutputItem(ItemStack stack, int position);

	@SideOnly(Side.CLIENT)
	ResourceLocation getTexture(ItemStack stack);

	@SideOnly(Side.CLIENT)
	int getGuiLength(ItemStack stack);

	@SideOnly(Side.CLIENT)
	int getGuiWidth(ItemStack stack);

}
