/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.genepool;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.genepool.Genepool;
import binnie.genetics.machine.genepool.GenepoolFX;
import binnie.genetics.machine.genepool.GenepoolLogic;
import forestry.core.fluids.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PackageGenepool
extends GeneticMachine.PackageGeneticBase
implements IMachineInformation {
    public PackageGenepool() {
        super("genepool", 12661942, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.GENEPOOL);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotEnzyme = inventory.addSlot(7, "enzyme");
        slotEnzyme.setValidator(new SlotValidator.Item(GeneticsItems.Enzyme.get(1), ModuleMachine.spriteEnzyme));
        slotEnzyme.forbidExtraction();
        InventorySlot slotProcess = inventory.addSlot(0, "process");
        slotProcess.setValidator(new SlotValidator.Individual());
        slotProcess.setReadOnly();
        slotProcess.forbidExtraction();
        for (InventorySlot slot : inventory.addSlotArray(Genepool.SLOT_RESERVE, "input")) {
            slot.setValidator(new SlotValidator.Individual());
            slot.forbidExtraction();
        }
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        TankSlot tankDNA = tanks.addTank(0, "output", 2000);
        tankDNA.setReadOnly();
        TankSlot tankEthanol = tanks.addTank(1, "input", 1000);
        tankEthanol.forbidExtraction();
        tankEthanol.setValidator(new TankValidator(){

            @Override
            public String getTooltip() {
                return FluidRegistry.getFluidStack((String)Fluids.BIO_ETHANOL.getTag(), (int)1).getLocalizedName();
            }

            @Override
            public boolean isValid(FluidStack stack) {
                return Fluids.BIO_ETHANOL.getTag().equals(stack.getFluid().getName());
            }
        });
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Genepool.SLOT_RESERVE, 0, 1);
        new ComponentPowerReceptor(machine, 1600);
        new GenepoolLogic(machine);
        ComponentChargedSlots chargedSlots = new ComponentChargedSlots(machine);
        chargedSlots.addCharge(7);
        new GenepoolFX(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

