/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageGenome
extends ControlAnalystPage {
    boolean active;

    public AnalystPageGenome(IWidget parent, Area area, boolean active, IIndividual ind) {
        super(parent, area);
        this.active = active;
        this.setColor(26265);
        int y = 4;
        int width = this.getWidth();
        int center = width / 2;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(ind);
        IBreedingSystem system = Binnie.GENETICS.getSystem(root);
        Control scaled = new Control(this, 0, y += 16, 0, 0){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderBackground(int guiWidth, int guiHeight) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)10.0f, (float)-15.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.9f, (float)0.95f, (float)1.0f);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderForeground(int guiWidth, int guiHeight) {
                GlStateManager.func_179121_F();
            }
        };
        for (IChromosomeType chromo : system.getActiveKaryotype()) {
            IAllele allele = active ? ind.getGenome().getActiveAllele(chromo) : ind.getGenome().getInactiveAllele(chromo);
            String alleleName = system.getAlleleName(chromo, allele);
            int height = CraftGUI.RENDER.textHeight(alleleName, center - 2);
            new ControlText(scaled, new Area(0, y + (height - 9) / 2, center - 2, 0), system.getChromosomeShortName(chromo) + " :", TextJustification.TOP_RIGHT).setColor(this.getColor());
            new ControlText(scaled, new Area(center + 2, y, center - 2, 0), alleleName, TextJustification.TOP_LEFT).setColor(this.getColor());
            y += 3 + height;
        }
        this.setSize(new Point(width, y + 8));
    }

    @Override
    public String getTitle() {
        String stateKey = "genetics.gui.analyst.genome";
        stateKey = this.active ? stateKey + ".active" : stateKey + ".inactive";
        return I18N.localise("genetics.gui.analyst.genome.title", I18N.localise(stateKey));
    }
}

