/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.botany.api.genetics.IFlower;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.control.ControlIconDisplay;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.item.ModuleItems;
import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.IButterfly;
import java.text.DecimalFormat;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageBiology
extends ControlAnalystPage {
    private static final float SPAWN_KOEF = 1365.3999f;

    public AnalystPageBiology(IWidget parent, Area area, IIndividual ind) {
        super(parent, area);
        this.setColor(26214);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 12;
        if (ind instanceof IBee) {
            this.addBeePages((IBee)ind, y);
        } else if (ind instanceof ITree) {
            this.addTreePages((ITree)ind, y);
        } else if (ind instanceof IButterfly) {
            this.addButterflyPages((IButterfly)ind, y);
        } else if (ind instanceof IFlower) {
            this.addFlowerPages((IFlower)ind, y);
        }
        this.setSize(new Point(this.getWidth(), y));
    }

    private void addBeePages(IBee bee, int y) {
        if (bee.getGenome().getNeverSleeps()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2, y, ModuleItems.iconAllDay).addTooltip(I18N.localise("genetics.gui.analyst.biology.allDay"));
        } else if (bee.getGenome().getPrimary().isNocturnal()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2, y, ModuleItems.iconNight).addTooltip(I18N.localise("genetics.gui.analyst.biology.night"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2, y, ModuleItems.iconDaytime).addTooltip(I18N.localise("genetics.gui.analyst.biology.day"));
        }
        if (!bee.getGenome().getToleratesRain()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 24, y, ModuleItems.iconNoRain).addTooltip(I18N.localise("genetics.gui.analyst.biology.notRain"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 24, y, ModuleItems.iconRain).addTooltip(I18N.localise("genetics.gui.analyst.biology.rain"));
        }
        if (bee.getGenome().getCaveDwelling()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 48, y, ModuleItems.iconNoSky).addTooltip(I18N.localise("genetics.gui.analyst.biology.underground"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 48, y, ModuleItems.iconSky).addTooltip(I18N.localise("genetics.gui.analyst.biology.notUnderground"));
        }
        y += 30;
        int fertility = bee.getGenome().getFertility();
        if (fertility > 1) {
            new ControlTextCentered((IWidget)this, y, TextFormatting.BOLD + I18N.localise("genetics.gui.analyst.biology.fertility.drones", fertility)).setColor(this.getColor());
        } else {
            new ControlTextCentered((IWidget)this, y, TextFormatting.BOLD + I18N.localise("genetics.gui.analyst.biology.fertility.drone")).setColor(this.getColor());
        }
        new ControlTextCentered((IWidget)this, y += 22, I18N.localise("genetics.gui.analyst.biology.averageLifespan")).setColor(this.getColor());
        int lifespan = bee.getGenome().getLifespan() * 550;
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.BOLD + this.getMCDayString((float)lifespan * (bee.getGenome().getNeverSleeps() ? 1.0f : 2.0f))).setColor(this.getColor());
        y += 22;
    }

    private void addTreePages(ITree tree, int y) {
        String alleleName = ExtraTrees.treeBreedingSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.SAPPINESS, tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS));
        new ControlTextCentered((IWidget)this, y, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.biology.sappiness", alleleName)).setColor(this.getColor());
        y += 20;
        int fertility = (int)(1.0f / tree.getGenome().getFertility());
        if (fertility > 1) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.biology.fertility.leaves", fertility)).setColor(this.getColor());
        } else {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.biology.fertility.leaf")).setColor(this.getColor());
        }
        int butterflySpawn = Math.round(1365.3999f / (tree.getGenome().getSappiness() * tree.getGenome().getYield() * 0.5f));
        new ControlTextCentered((IWidget)this, y += 22, I18N.localise("genetics.gui.analyst.biology.mothSpawn.perLeaf", this.getTimeString(butterflySpawn))).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 34, I18N.localise("genetics.gui.analyst.biology.plantTypes")).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + tree.getGenome().getPrimary().getPlantType().toString()).setColor(this.getColor());
    }

    private void addButterflyPages(IButterfly butterfly, int y) {
        if (butterfly.getGenome().getNocturnal()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2, y, ModuleItems.iconAllDay).addTooltip(I18N.localise("genetics.gui.analyst.biology.allDay"));
        } else if (butterfly.getGenome().getPrimary().isNocturnal()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2, y, ModuleItems.iconNight).addTooltip(I18N.localise("genetics.gui.analyst.biology.night"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2, y, ModuleItems.iconDaytime).addTooltip(I18N.localise("genetics.gui.analyst.biology.day"));
        }
        if (!butterfly.getGenome().getTolerantFlyer()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 24, y, ModuleItems.iconNoRain).addTooltip(I18N.localise("genetics.gui.analyst.biology.notRain"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 24, y, ModuleItems.iconRain).addTooltip(I18N.localise("genetics.gui.analyst.biology.rain"));
        }
        if (butterfly.getGenome().getFireResist()) {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 48, y, ModuleItems.iconNoFire).addTooltip(I18N.localise("genetics.gui.analyst.biology.nonflammable"));
        } else {
            new ControlIconDisplay((IWidget)this, (this.getWidth() - 64) / 2 + 48, y, ModuleItems.iconFire).addTooltip(I18N.localise("genetics.gui.analyst.biology.flammable"));
        }
        y += 30;
        int fertility = butterfly.getGenome().getFertility();
        if (fertility > 1) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.biology.fertility.moths", fertility)).setColor(this.getColor());
        } else {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.biology.fertility.moth")).setColor(this.getColor());
        }
        float caterpillarMatureTime = 1365.3999f * (float)Math.round(butterfly.getGenome().getLifespan() / (butterfly.getGenome().getFertility() * 2));
        new ControlTextCentered((IWidget)this, y += 32, I18N.localise("genetics.gui.analyst.biology.caterpillarGestation")).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.BOLD + this.getMCDayString(caterpillarMatureTime)).setColor(this.getColor());
        int speed = (int)(20.0f * butterfly.getGenome().getSpeed());
        new ControlTextCentered((IWidget)this, y += 22, I18N.localise("genetics.gui.analyst.biology.flightSpeed")).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.BOLD + I18N.localise("genetics.gui.analyst.biology.blocksPerSec", speed)).setColor(this.getColor());
        y += 22;
    }

    private void addFlowerPages(IFlower flower, int y) {
        int butterflySpawn2 = Math.round(1365.3999f / (flower.getGenome().getSappiness() * 0.2f));
        new ControlTextCentered((IWidget)this, y += 10, I18N.localise("genetics.gui.analyst.biology.mothSpawn", this.getTimeString(butterflySpawn2))).setColor(this.getColor());
        y += 30;
        int fertility = flower.getGenome().getFertility();
        float chanceDispersal = 0.8f;
        chanceDispersal += 0.2f * (float)fertility;
        if (chanceDispersal > 1.0f) {
            chanceDispersal = 1.0f;
        }
        float chancePollinate = 0.6f;
        if ((chancePollinate += 0.25f * (float)fertility) > 1.0f) {
            chancePollinate = 1.0f;
        }
        float maxAge = flower.getMaxAge();
        float ageChance = flower.getGenome().getAgeChance();
        float dispersalTime = 1365.3999f / chanceDispersal;
        float pollinateTime = 1365.3999f / chancePollinate;
        float lifespan2 = maxAge * 20.0f * 68.27f / ageChance;
        float floweringLifespan = (maxAge - 1.0f) * 20.0f * 68.27f / ageChance - 1365.3999f;
        new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.biology.averageLifespan")).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.BOLD + this.getMCDayString(lifespan2)).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 22, I18N.localise("genetics.gui.analyst.biology.seedDispersal")).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.biology.perLifetime", (int)(floweringLifespan / dispersalTime))).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 22, I18N.localise("genetics.gui.analyst.biology.pollination")).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.biology.perLifetime", (int)(floweringLifespan / pollinateTime))).setColor(this.getColor());
        y += 22;
    }

    private String getMCDayString(float time) {
        float seconds = time / 20.0f;
        float minutes = seconds / 60.0f;
        float days = minutes / 20.0f;
        DecimalFormat df = new DecimalFormat("#.#");
        return I18N.localise("genetics.gui.analyst.biology.mcDays", df.format(days));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.biology");
    }
}

