/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.api.block.TileEntityMetadata;
import binnie.core.modules.BinnieModule;
import binnie.core.modules.Module;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.BlockCarpentryPanel;
import binnie.extratrees.carpentry.BlockDesign;
import binnie.extratrees.carpentry.BlockStainedDesign;
import binnie.extratrees.carpentry.CarpentryInterface;
import binnie.extratrees.carpentry.DesignBlock;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.carpentry.ItemDesign;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;

@BinnieModule(moduleID="extratrees.carpentry", moduleContainerID="extratrees", name="Carpentry", unlocalizedDescription="extratrees.module.carpentry")
public class ModuleCarpentry
extends Module {
    public static BlockCarpentry blockCarpentry;
    public static BlockCarpentry blockPanel;
    public static BlockStainedDesign blockStained;

    public static ItemStack getItemStack(BlockDesign block, IDesignMaterial type1, IDesignMaterial type2, IDesign design) {
        return ModuleCarpentry.getItemStack(block, block.getDesignSystem().getMaterialIndex(type1), block.getDesignSystem().getMaterialIndex(type2), CarpentryManager.carpentryInterface.getDesignIndex(design));
    }

    public static ItemStack getItemStack(BlockDesign block, int type1, int type2, int design) {
        return TileEntityMetadata.getItemStack((Block)block, ModuleCarpentry.getMetadata(type1, type2, design, 0, EnumFacing.UP.ordinal()));
    }

    public static ItemStack getItemStack(BlockDesign blockC, DesignBlock block) {
        return ModuleCarpentry.getItemStack(blockC, block.getPrimaryMaterial(), block.getSecondaryMaterial(), block.getDesign());
    }

    public static int getMetadata(int plank1, int plank2, int design, int rotation, int facing) {
        return plank1 + (plank2 << 8) + (design << 16) + (rotation << 26) + (facing << 28);
    }

    public static DesignBlock getDesignBlock(IDesignSystem system, int meta) {
        int plankID1 = meta & 0xFF;
        int plankID2 = meta >> 8 & 0xFF;
        int tile = meta >> 16 & 0x3FF;
        int rotation = meta >> 26 & 3;
        int axis = meta >> 28 & 7;
        IDesignMaterial type1 = system.getMaterial(plankID1);
        IDesignMaterial type2 = system.getMaterial(plankID2);
        IDesign type3 = CarpentryManager.carpentryInterface.getDesign(tile);
        return new DesignBlock(system, type1, type2, type3, rotation, EnumFacing.field_82609_l[axis]);
    }

    public static DesignBlock getCarpentryPanel(IDesignSystem system, int meta) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(system, meta);
        block.setPanel();
        return block;
    }

    public static int getBlockMetadata(IDesignSystem system, DesignBlock block) {
        int plank1 = system.getMaterialIndex(block.getPrimaryMaterial());
        int plank2 = system.getMaterialIndex(block.getSecondaryMaterial());
        int design = CarpentryManager.carpentryInterface.getDesignIndex(block.getDesign());
        int rotation = block.getRotation();
        int facing = block.getFacing().ordinal();
        return ModuleCarpentry.getMetadata(plank1, plank2, design, rotation, facing);
    }

    public static int getItemMetadata(IDesignSystem system, DesignBlock block) {
        int plank1 = system.getMaterialIndex(block.getPrimaryMaterial());
        int plank2 = system.getMaterialIndex(block.getSecondaryMaterial());
        int design = CarpentryManager.carpentryInterface.getDesignIndex(block.getDesign());
        return ModuleCarpentry.getMetadata(plank1, plank2, design, 0, EnumFacing.UP.ordinal());
    }

    @Override
    public void registerItemsAndBlocks() {
        blockCarpentry = new BlockCarpentry("carpentry");
        blockPanel = new BlockCarpentryPanel();
        blockStained = new BlockStainedDesign();
        ExtraTrees.proxy.registerBlock(blockCarpentry, (ItemBlock)new ItemDesign(blockCarpentry));
        ExtraTrees.proxy.registerBlock(blockPanel, (ItemBlock)new ItemDesign(blockPanel));
        ExtraTrees.proxy.registerBlock(blockStained, (ItemBlock)new ItemDesign(blockStained));
        MinecraftForge.EVENT_BUS.register((Object)blockCarpentry);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        for (EnumDesign design : EnumDesign.values()) {
            CarpentryManager.carpentryInterface.registerDesign(design.ordinal(), design);
        }
    }

    @Override
    public Set<String> getDependencyUids() {
        return ImmutableSet.of((Object)"extratrees.machines");
    }

    static {
        CarpentryManager.carpentryInterface = new CarpentryInterface();
    }

    static enum Axis {
        Y,
        X,
        Z;

    }
}

