/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.botany.api.genetics.EnumFlowerColor;
import binnie.core.api.block.TileEntityMetadata;
import binnie.extratrees.api.IDesignMaterial;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class GlassType
implements IDesignMaterial {
    static Map<Integer, GlassType> types = new LinkedHashMap<Integer, GlassType>();
    String name;
    int colour;
    int id;

    private GlassType(int id, String name, int colour) {
        this.id = id;
        this.name = name;
        this.colour = colour;
    }

    public static int getIndex(IDesignMaterial id) {
        for (Map.Entry<Integer, GlassType> entry : types.entrySet()) {
            if (entry.getValue() != id) continue;
            return entry.getKey();
        }
        return 0;
    }

    public static IDesignMaterial get(int id) {
        return types.get(id);
    }

    @Nullable
    public static IDesignMaterial get(ItemStack stack) {
        for (Map.Entry<Integer, GlassType> entry : types.entrySet()) {
            if (!stack.func_77969_a(entry.getValue().getStack())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        if (this.id < 128) {
            return new ItemStack((Block)Blocks.field_150399_cn, 1, this.id);
        }
        Block stained = Botany.stained;
        if (stained != null) {
            return TileEntityMetadata.getItemStack(stained, this.id - 128);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getStack(boolean fireproof) {
        return this.getStack();
    }

    @Override
    public String getDesignMaterialName() {
        return this.name;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    static {
        for (StandardColor standardColor : StandardColor.values()) {
            types.put(standardColor.ordinal(), new GlassType(standardColor.ordinal(), standardColor.name, standardColor.colour));
        }
        for (Enum enum_ : EnumFlowerColor.values()) {
            types.put(128 + enum_.ordinal(), new GlassType(128 + enum_.ordinal(), ((EnumFlowerColor)enum_).getFlowerColorAllele().getColorName(), ((EnumFlowerColor)enum_).getFlowerColorAllele().getColor(false)));
        }
    }

    private static enum StandardColor {
        White("White", 0xFFFFFF),
        Orange("Orange", 14188339),
        Magenta("Magenta", 11685080),
        LightBlue("Light Blue", 6724056),
        Yellow("Yellow", 0xE5E533),
        Lime("Lime", 8375321),
        Pink("Pink", 15892389),
        Gray("Gray", 0x4C4C4C),
        LightGray("Light Gray", 0x999999),
        Cyan("Cyan", 5013401),
        Purple("Purple", 8339378),
        Blue("Blue", 3361970),
        Brown("Brown", 6704179),
        Green("Green", 6717235),
        Red("Red", 0x993333),
        Black("Black", 0x191919);

        String name;
        int colour;

        private StandardColor(String name, int colour) {
            this.name = name;
            this.colour = colour;
        }
    }

    @GameRegistry.ObjectHolder(value="botany")
    public static final class Botany {
        @GameRegistry.ObjectHolder(value="stained")
        @Nullable
        public static final Block stained = Blocks.field_150350_a;
    }
}

