/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.botany.api.genetics.IAlleleFlowerSpecies;
import binnie.botany.api.genetics.IColorMix;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerColor;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerMutation;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.FlowerGenome;
import binnie.core.util.I18N;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.utils.Translator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Flower
extends Individual
implements IFlower {
    public IFlowerGenome genome;
    @Nullable
    public IFlowerGenome mate;
    private int age;
    private boolean wilting;
    private boolean flowered;

    public Flower(NBTTagCompound compound) {
        super(compound);
        this.age = compound.func_74764_b("Age") ? compound.func_74762_e("Age") : 0;
        boolean bl = this.wilting = compound.func_74764_b("Wilt") && compound.func_74767_n("Wilt");
        this.flowered = compound.func_74764_b("Flowered") ? compound.func_74767_n("Flowered") : this.age > 0;
        this.genome = compound.func_74764_b("Genome") ? new FlowerGenome(compound.func_74775_l("Genome")) : BotanyCore.getFlowerRoot().templateAsGenome(BotanyCore.getFlowerRoot().getDefaultTemplate());
        if (compound.func_74764_b("Mate")) {
            this.mate = new FlowerGenome(compound.func_74775_l("Mate"));
        }
    }

    public Flower(IFlowerGenome genome, int age) {
        this.genome = genome;
        this.age = age;
        this.wilting = false;
        this.flowered = age > 0;
    }

    public String getDisplayName() {
        IAlleleFlowerSpecies species = this.getGenome().getPrimary();
        String name = species.getAlleleName();
        if (this.age == 0) {
            name = name + "";
        }
        return name;
    }

    public void addTooltip(List<String> list) {
        IAlleleFlowerSpecies primary = this.genome.getPrimary();
        IAlleleFlowerSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumFlowerChromosome.SPECIES)) {
            list.add(TextFormatting.BLUE + Translator.translateToLocal((String)"for.bees.hybrid").replaceAll("%PRIMARY", primary.getAlleleName()).replaceAll("%SECONDARY", secondary.getAlleleName()));
        }
        list.add(TextFormatting.GOLD + I18N.localise("item.botany.flower.age", this.getAge()));
        list.add(TextFormatting.GREEN + "T: " + this.getGenome().getPrimary().getTemperature() + " / " + this.getGenome().getToleranceTemperature());
        list.add(TextFormatting.AQUA + "M: " + (Object)((Object)this.getGenome().getPrimary().getMoisture()) + " / " + this.getGenome().getToleranceMoisture());
        list.add(TextFormatting.AQUA + "pH: " + this.getGenome().getPrimary().getHumidity() + " / " + this.getGenome().getTolerancePH());
        list.add(TextFormatting.GOLD + "Fert: " + this.getGenome().getFertility() + "x");
    }

    public String getIdent() {
        return this.getGenome().getPrimary().getUID();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("Age", this.age);
        compound.func_74757_a("Wilt", this.wilting);
        compound.func_74757_a("Flowered", this.flowered);
        NBTTagCompound compoundGenome = new NBTTagCompound();
        this.genome.writeToNBT(compoundGenome);
        compound.func_74782_a("Genome", (NBTBase)compoundGenome);
        if (this.mate != null) {
            NBTTagCompound compundMate = new NBTTagCompound();
            this.mate.writeToNBT(compundMate);
            compound.func_74782_a("Mate", (NBTBase)compundMate);
        }
        return compound;
    }

    @Override
    public IFlowerGenome getGenome() {
        return this.genome;
    }

    @Override
    public void mate(IFlower other) {
        this.mate = new FlowerGenome(other.getGenome().getChromosomes());
    }

    @Override
    @Nullable
    public IFlowerGenome getMate() {
        return this.mate;
    }

    public IFlower copy() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeToNBT(compound);
        return new Flower(compound);
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int i) {
        this.age = i;
    }

    @Override
    public void age() {
        if (this.age < 15) {
            ++this.age;
        }
    }

    @Override
    public int getMaxAge() {
        return this.getGenome().getLifespan();
    }

    @Override
    public boolean isWilted() {
        return this.wilting;
    }

    @Override
    public void setWilted(boolean wilted) {
        this.wilting = wilted;
    }

    @Override
    public boolean hasFlowered() {
        return this.flowered;
    }

    @Override
    public void setFlowered(boolean flowered) {
        this.flowered = flowered;
    }

    @Override
    public void removeMate() {
        this.mate = null;
    }

    @Override
    public IFlower getOffspring(World world, BlockPos pos) {
        if (this.mate != null) {
            IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
            IChromosome[] parentFirst = this.mutateSpecies(world, pos, this.genome, this.mate);
            IChromosome[] parentSecond = this.mutateSpecies(world, pos, this.mate, this.genome);
            for (int i = 0; i < parentFirst.length; ++i) {
                if (parentFirst[i] == null || parentSecond[i] == null) continue;
                chromosomes[i] = Chromosome.inheritChromosome((Random)world.field_73012_v, (IChromosome)parentFirst[i], (IChromosome)parentSecond[i]);
            }
            return new Flower(new FlowerGenome(chromosomes), 0);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return new Flower(nbt);
    }

    private IChromosome[] mutateSpecies(World world, BlockPos pos, IFlowerGenome genomeFirst, IFlowerGenome genomeSecond) {
        IFlowerGenome genome2;
        IFlowerGenome genome0;
        IAlleleFlowerSpecies alleleSecond;
        IAlleleFlowerSpecies alleleFirst;
        IChromosome[] parentFirst = genomeFirst.getChromosomes();
        IChromosome[] parentSecond = genomeSecond.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            alleleFirst = (IAlleleFlowerSpecies)parentFirst[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            alleleSecond = (IAlleleFlowerSpecies)parentSecond[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeFirst;
            genome2 = genomeSecond;
        } else {
            alleleFirst = (IAlleleFlowerSpecies)parentSecond[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            alleleSecond = (IAlleleFlowerSpecies)parentFirst[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeSecond;
            genome2 = genomeFirst;
        }
        IFlowerColor colorFirst = genome0.getPrimaryColor();
        IFlowerColor colorSecond = genome2.getPrimaryColor();
        if (colorFirst != colorSecond) {
            for (IColorMix mutation : BotanyCore.getFlowerRoot().getColorMixes(true)) {
                if (!mutation.isMutation(colorFirst, colorSecond) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parentFirst[EnumFlowerChromosome.PRIMARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colorFirst = genome0.getSecondaryColor()) != (colorSecond = genome2.getSecondaryColor())) {
            for (IColorMix mutation : BotanyCore.getFlowerRoot().getColorMixes(true)) {
                if (!mutation.isMutation(colorFirst, colorSecond) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parentFirst[EnumFlowerChromosome.SECONDARY.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        if ((colorFirst = genome0.getStemColor()) != (colorSecond = genome2.getStemColor())) {
            for (IColorMix mutation : BotanyCore.getFlowerRoot().getColorMixes(true)) {
                if (!mutation.isMutation(colorFirst, colorSecond) || !(world.field_73012_v.nextFloat() * 100.0f < (float)mutation.getChance())) continue;
                parentFirst[EnumFlowerChromosome.STEM.ordinal()] = new Chromosome((IAllele)mutation.getResult().getAllele());
            }
        }
        IChromosome[] template = null;
        for (IFlowerMutation iFlowerMutation : BotanyCore.getFlowerRoot().getMutations(true)) {
            float chance = iFlowerMutation.getChance(world, pos, alleleFirst, alleleSecond, genome0, genome2);
            if (!(chance > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance) || template != null) continue;
            template = BotanyCore.getFlowerRoot().templateAsChromosomes(iFlowerMutation.getTemplate());
        }
        if (template != null) {
            parentFirst = template;
        }
        return parentFirst;
    }
}

