/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill.recipes;

import binnie.core.util.OreDictionaryUtil;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.api.recipes.ILumbermillManager;
import binnie.extratrees.api.recipes.ILumbermillRecipe;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class LumbermillRecipeManager
implements ILumbermillManager {
    private static Multimap<Item, ILumbermillRecipe> recipes = ArrayListMultimap.create();
    private static boolean calculatedRecipes = false;

    public static ItemStack getPlankProduct(ItemStack logStack, World world) {
        if (!calculatedRecipes) {
            LumbermillRecipeManager.calculateProducts(world);
            calculatedRecipes = true;
        }
        Item logItem = logStack.func_77973_b();
        for (ILumbermillRecipe recipe : recipes.get((Object)logItem)) {
            if (!recipe.getInput().func_77969_a(logStack)) continue;
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private static void calculateProducts(World world) {
        InventoryCrafting fakeCraftingInventory = new InventoryCrafting(new FakeCraftingHandler(), 3, 3){};
        NonNullList oreDictLogs = OreDictionary.getOres((String)"logWood");
        UniqueItemStackSet logsSet = new UniqueItemStackSet();
        for (ItemStack logStack : oreDictLogs) {
            List<ItemStack> subtypes = LumbermillRecipeManager.getSubtypes(logStack);
            logsSet.addAll((Collection<? extends ItemStack>)subtypes);
        }
        for (ItemStack log : logsSet) {
            ItemStack logCopy = log.func_77946_l();
            logCopy.func_190920_e(1);
            fakeCraftingInventory.func_174888_l();
            fakeCraftingInventory.func_70299_a(0, logCopy.func_77946_l());
            ItemStack recipeOutput = LumbermillRecipeManager.getRecipeWithPlanksOutput(fakeCraftingInventory, world);
            if (recipeOutput == null) continue;
            LumbermillRecipeManager.addLogToPlankRecipe(logCopy, recipeOutput.func_77946_l());
        }
    }

    @Nullable
    private static ItemStack getRecipeWithPlanksOutput(InventoryCrafting fakeCraftingInventory, World world) {
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            ItemStack recipeOutput;
            boolean matches;
            try {
                matches = recipe.func_77569_a(fakeCraftingInventory, world);
            }
            catch (LinkageError | RuntimeException e) {
                matches = false;
            }
            if (!matches || (recipeOutput = recipe.func_77572_b(fakeCraftingInventory)).func_190926_b() || !OreDictionaryUtil.hasOreName(recipeOutput, "plankWood")) continue;
            return recipeOutput;
        }
        return null;
    }

    private static List<ItemStack> getSubtypes(ItemStack itemStack) {
        NonNullList subtypes = NonNullList.func_191196_a();
        if (itemStack.func_77952_i() == Short.MAX_VALUE && itemStack.func_77981_g()) {
            Item item = itemStack.func_77973_b();
            for (CreativeTabs creativeTab : item.getCreativeTabs()) {
                item.func_150895_a(creativeTab, subtypes);
            }
        } else {
            subtypes.add((Object)itemStack);
        }
        return subtypes;
    }

    private static void addLogToPlankRecipe(ItemStack logStack, ItemStack plankStack) {
        Item logItem = logStack.func_77973_b();
        plankStack.func_190920_e((int)Math.ceil((float)plankStack.func_190916_E() * 1.5f));
        recipes.put((Object)logItem, (Object)new LumbermillRecipe(logStack, plankStack));
    }

    @Override
    public void addRecipe(ItemStack input, ItemStack output) {
        Item logItem = input.func_77973_b();
        recipes.put((Object)logItem, (Object)new LumbermillRecipe(input, output));
    }

    @Override
    public boolean addRecipe(ILumbermillRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.put((Object)item, (Object)recipe);
    }

    @Override
    public boolean removeRecipe(ILumbermillRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.get((Object)item).remove(recipe);
    }

    @Override
    public Collection<ILumbermillRecipe> recipes() {
        return recipes.values();
    }

    private static class FakeCraftingHandler
    extends Container {
        private FakeCraftingHandler() {
        }

        public void func_75130_a(IInventory inventoryIn) {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }
}

