/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.extratrees.gui.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.lumbermill.LumbermillLogic;
import binnie.extratrees.machines.lumbermill.window.SlotValidatorLog;
import net.minecraft.tileentity.TileEntity;

public class LumbermillMachine
extends ExtraTreeMachine.PackageExtraTreeMachine
implements IMachineInformation {
    public static final int SLOT_LOG = 0;
    public static final int SLOT_PLANKS = 1;
    public static final int SLOT_BARK = 2;
    public static final int SLOT_SAWDUST = 3;
    public static final int TANK_WATER = 0;
    public static final int TANK_WATER_CAPACITY = 10000;

    public LumbermillMachine() {
        super("lumbermill", true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.LUMBERMILL);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotLog = inventory.addSlot(0, "input");
        slotLog.setValidator(new SlotValidatorLog(machine.getWorld()));
        slotLog.forbidExtraction();
        inventory.addSlot(1, "output").setReadOnly();
        inventory.addSlot(2, "byproduct").setReadOnly();
        inventory.addSlot(3, "byproduct").setReadOnly();
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        TankSlot tankWater = tanks.addTank(0, "input", 10000);
        tankWater.setValidator(new TankValidator.Basic("water"));
        new ComponentPowerReceptor(machine);
        new LumbermillLogic(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

