/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.IMachineType;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IInteraction;
import binnie.core.modules.ModuleManager;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.gui.ExtraTreesGUID;
import binnie.extratrees.machines.brewery.BreweryMachine;
import binnie.extratrees.machines.designer.DesignerType;
import binnie.extratrees.machines.designer.PackageDesigner;
import binnie.extratrees.machines.distillery.DistilleryMachine;
import binnie.extratrees.machines.fruitpress.FruitPressMachine;
import binnie.extratrees.machines.lumbermill.LumbermillMachine;
import binnie.extratrees.modules.ModuleMachine;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum ExtraTreeMachine implements IMachineType
{
    Lumbermill(LumbermillMachine::new),
    Woodworker(() -> {
        if (ModuleManager.isModuleEnabled("extratrees", "extratrees.carpentry")) {
            return new PackageDesigner(DesignerType.Woodworker);
        }
        return null;
    }),
    Panelworker(() -> {
        if (ModuleManager.isModuleEnabled("extratrees", "extratrees.carpentry")) {
            return new PackageDesigner(DesignerType.Panelworker);
        }
        return null;
    }),
    Nursery(() -> null),
    Press(FruitPressMachine::new),
    BREWERY(BreweryMachine::new),
    Distillery(DistilleryMachine::new),
    Glassworker(() -> {
        if (ModuleManager.isModuleEnabled("extratrees", "extratrees.carpentry")) {
            return new PackageDesigner(DesignerType.GlassWorker);
        }
        return null;
    });

    Supplier<MachinePackage> supplier;

    private ExtraTreeMachine(Supplier<MachinePackage> supplier) {
        this.supplier = supplier;
    }

    @Override
    public Supplier<MachinePackage> getSupplier() {
        return this.supplier;
    }

    public ItemStack get(int i) {
        return new ItemStack(ModuleMachine.blockMachine, i, this.ordinal());
    }

    public static abstract class PackageExtraTreeMachine
    extends MachinePackage {
        protected PackageExtraTreeMachine(String uid, boolean powered) {
            super(uid, powered);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }

    public static class ComponentExtraTreeGUI
    extends MachineComponent
    implements IInteraction.RightClick {
        ExtraTreesGUID id;

        public ComponentExtraTreeGUI(Machine machine, ExtraTreesGUID id) {
            super(machine);
            this.id = id;
        }

        @Override
        public void onRightClick(World p0, EntityPlayer p1, BlockPos pos) {
            ExtraTrees.proxy.openGui(this.id, p1, pos);
        }
    }
}

