/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.extratrees.genetics.ETTreeDefinition;
import com.google.common.base.Preconditions;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ExtraTreeMutation
implements ITreeMutation {
    int chance;
    boolean isSecret = false;
    IAlleleTreeSpecies allele0;
    IAlleleTreeSpecies allele1;
    IAllele[] template;
    private float minTemperature = 0.0f;
    private float maxTemperature = 2.0f;
    private float minRainfall = 0.0f;
    private float maxRainfall = 2.0f;
    private float height = -1.0f;

    public ExtraTreeMutation(IAlleleSpecies allele0, IAlleleSpecies allele1, IAlleleSpecies result, int chance) {
        this((IAllele)allele0, (IAllele)allele1, TreeManager.treeRoot.getTemplate(result), chance);
    }

    public ExtraTreeMutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        this.allele0 = (IAlleleTreeSpecies)allele0;
        this.allele1 = (IAlleleTreeSpecies)allele1;
        this.template = template;
        this.chance = chance;
        TreeManager.treeRoot.registerMutation((IMutation)this);
    }

    public static void init() {
        IAlleleTreeSpecies lemon = (IAlleleTreeSpecies)ExtraTreeMutation.getVanilla("Lemon");
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)lemon, (IAlleleSpecies)ETTreeDefinition.KeyLime.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.KeyLime.getSpecies(), (IAlleleSpecies)lemon, (IAlleleSpecies)ETTreeDefinition.FingerLime.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)lemon, (IAlleleSpecies)ETTreeDefinition.Pomelo.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Pomelo.getSpecies(), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.Manderin.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Pomelo.getSpecies(), (IAlleleSpecies)lemon, (IAlleleSpecies)ETTreeDefinition.Citron.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Manderin.getSpecies(), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.Kumquat.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Pomelo.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Manderin.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Orange.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Citron.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Manderin.getSpecies(), (IAlleleSpecies)ETTreeDefinition.BuddhaHand.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Kumquat.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Manderin.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Tangerine.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Kumquat.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Manderin.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Satsuma.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Pomelo.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Orange.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Grapefruit.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Pomelo.getSpecies(), (IAlleleSpecies)ETTreeDefinition.KeyLime.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Lime.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Oak"), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.OrchardApple.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.OrchardApple.getSpecies(), ExtraTreeMutation.getVanilla("Maple"), (IAlleleSpecies)ETTreeDefinition.SweetCrabapple.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.OrchardApple.getSpecies(), (IAlleleSpecies)ETTreeDefinition.SweetCrabapple.getSpecies(), (IAlleleSpecies)ETTreeDefinition.FloweringCrabapple.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.OrchardApple.getSpecies(), ExtraTreeMutation.getVanilla("Birch"), (IAlleleSpecies)ETTreeDefinition.PrairieCrabapple.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), (IAlleleSpecies)ETTreeDefinition.OrchardApple.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Blackthorn.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.CherryPlum.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), ExtraTreeMutation.getVanilla("Chestnut"), (IAlleleSpecies)ETTreeDefinition.Peach.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), (IAlleleSpecies)ETTreeDefinition.Peach.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Nectarine.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), (IAlleleSpecies)ETTreeDefinition.Peach.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Apricot.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Plum"), ExtraTreeMutation.getVanilla("Walnut"), (IAlleleSpecies)ETTreeDefinition.Almond.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Lime"), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.WildCherry.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Willow"), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.SourCherry.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.BlackCherry.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Jungle"), (IAlleleSpecies)ETTreeDefinition.Banana.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Banana.getSpecies(), ExtraTreeMutation.getVanilla("Kapok"), (IAlleleSpecies)ETTreeDefinition.RedBanana.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Banana.getSpecies(), ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Plantain.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Birch"), ExtraTreeMutation.getVanilla("Oak"), (IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Birch"), (IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Aspen.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Aspen.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Rowan.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Aspen.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Hazel.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Rowan.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Hawthorn.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Aspen.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Elder.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Rowan.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Holly.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Willow"), (IAlleleSpecies)ETTreeDefinition.Aspen.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Sallow.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), ExtraTreeMutation.getVanilla("Birch"), (IAlleleSpecies)ETTreeDefinition.Pecan.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), ExtraTreeMutation.getVanilla("Spruce"), (IAlleleSpecies)ETTreeDefinition.CopperBeech.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Lime"), ExtraTreeMutation.getVanilla("Spruce"), (IAlleleSpecies)ETTreeDefinition.Ash.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Ash.getSpecies(), ExtraTreeMutation.getVanilla("Birch"), (IAlleleSpecies)ETTreeDefinition.Whitebeam.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Ash.getSpecies(), ExtraTreeMutation.getVanilla("Pine"), (IAlleleSpecies)ETTreeDefinition.Elm.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Ash.getSpecies(), ExtraTreeMutation.getVanilla("Larch"), (IAlleleSpecies)ETTreeDefinition.Hornbeam.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Ash.getSpecies(), ExtraTreeMutation.getVanilla("Maple"), (IAlleleSpecies)ETTreeDefinition.Sycamore.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Larch"), ExtraTreeMutation.getVanilla("Spruce"), (IAlleleSpecies)ETTreeDefinition.Yew.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Larch"), (IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.BalsamFir.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), (IAlleleSpecies)ETTreeDefinition.BalsamFir.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Fir.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), (IAlleleSpecies)ETTreeDefinition.Fir.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Hemlock.getSpecies(), 10).setHeight(80);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Fir.getSpecies(), ExtraTreeMutation.getVanilla("Larch"), (IAlleleSpecies)ETTreeDefinition.Cedar.getSpecies(), 10).setHeight(60);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Fir.getSpecies(), ExtraTreeMutation.getVanilla("Spruce"), (IAlleleSpecies)ETTreeDefinition.DouglasFir.getSpecies(), 10).setHeight(60);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), ExtraTreeMutation.getVanilla("Spruce"), (IAlleleSpecies)ETTreeDefinition.Cypress.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Pine"), ExtraTreeMutation.getVanilla("Spruce"), (IAlleleSpecies)ETTreeDefinition.LoblollyPine.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Walnut"), ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.Butternut.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Walnut"), ExtraTreeMutation.getVanilla("Oak"), (IAlleleSpecies)ETTreeDefinition.AcornOak.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Olive.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Maple"), ExtraTreeMutation.getVanilla("Lime"), (IAlleleSpecies)ETTreeDefinition.RedMaple.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Maple"), ExtraTreeMutation.getVanilla("Larch"), (IAlleleSpecies)ETTreeDefinition.Sweetgum.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Lime"), (IAlleleSpecies)ETTreeDefinition.Locust.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Iroko.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.OrchardApple.getSpecies(), ExtraTreeMutation.getVanilla("Birch"), (IAlleleSpecies)ETTreeDefinition.Pear.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.OldFustic.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.OldFustic.getSpecies(), ExtraTreeMutation.getVanilla("Kapok"), (IAlleleSpecies)ETTreeDefinition.OsangeOrange.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Brazilwood.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Brazilwood.getSpecies(), ExtraTreeMutation.getVanilla("Kapok"), (IAlleleSpecies)ETTreeDefinition.Purpleheart.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Ebony"), ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Rosewood.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Rosewood.getSpecies(), ExtraTreeMutation.getVanilla("Kapok"), (IAlleleSpecies)ETTreeDefinition.Logwood.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Wenge"), ExtraTreeMutation.getVanilla("Lime"), (IAlleleSpecies)ETTreeDefinition.Gingko.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Beech.getSpecies(), ExtraTreeMutation.getVanilla("Jungle"), (IAlleleSpecies)ETTreeDefinition.Brazilnut.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), ExtraTreeMutation.getVanilla("Jungle"), (IAlleleSpecies)ETTreeDefinition.RoseGum.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.RoseGum.getSpecies(), ExtraTreeMutation.getVanilla("Mahogony"), (IAlleleSpecies)ETTreeDefinition.SwampGum.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Coffee.getSpecies(), ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Clove.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), ExtraTreeMutation.getVanilla("Jungle"), (IAlleleSpecies)ETTreeDefinition.Coffee.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Holly.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Box.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Hemlock.getSpecies(), ExtraTreeMutation.getVanilla("Jungle"), (IAlleleSpecies)ETTreeDefinition.MonkeyPuzzle.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.RoseGum.getSpecies(), ExtraTreeMutation.getVanilla("Balsa"), (IAlleleSpecies)ETTreeDefinition.RainbowGum.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.RoseGum.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Brazilwood.getSpecies(), (IAlleleSpecies)ETTreeDefinition.PinkIvory.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.Elder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Raspberry.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Cherry"), (IAlleleSpecies)ETTreeDefinition.Elder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Redcurrant.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.BlackCherry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Redcurrant.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Blackcurrant.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.BlackCherry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Raspberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Blackberry.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Blackberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Raspberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Blueberry.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Blackberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.CherryPlum.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Cranberry.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Raspberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Fir.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Juniper.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Raspberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Lime.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Gooseberry.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Raspberry.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Orange.getSpecies(), (IAlleleSpecies)ETTreeDefinition.GoldenRaspberry.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Rosewood.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Cinnamon.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Balsa"), (IAlleleSpecies)ETTreeDefinition.Brazilnut.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Coconut.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), ExtraTreeMutation.getVanilla("Oak"), (IAlleleSpecies)ETTreeDefinition.Cashew.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Wenge"), ExtraTreeMutation.getVanilla("Oak"), (IAlleleSpecies)ETTreeDefinition.Avacado.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Clove.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Nutmeg.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Teak"), (IAlleleSpecies)ETTreeDefinition.Clove.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Allspice.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Allspice.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Clove.getSpecies(), (IAlleleSpecies)ETTreeDefinition.StarAnise.getSpecies(), 10);
        new ExtraTreeMutation(ExtraTreeMutation.getVanilla("Jungle"), (IAlleleSpecies)ETTreeDefinition.Orange.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Mango.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.StarAnise.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Mango.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Starfruit.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Hazel.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Gingko.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Candlenut.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Hazel.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Gingko.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Chilli.getSpecies(), 10);
        new ExtraTreeMutation((IAlleleSpecies)ETTreeDefinition.Hazel.getSpecies(), (IAlleleSpecies)ETTreeDefinition.Alder.getSpecies(), (IAlleleSpecies)ETTreeDefinition.DwarfHazel.getSpecies(), 10);
    }

    public static IAlleleSpecies getVanilla(String uid) {
        String forestryUid = "forestry.tree" + uid;
        IAllele allele = AlleleManager.alleleRegistry.getAllele(forestryUid);
        Preconditions.checkArgument((allele != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(allele instanceof IAlleleSpecies), (String)"No Forestry species with uid: %s", (Object)forestryUid);
        return (IAlleleSpecies)allele;
    }

    public ExtraTreeMutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public ExtraTreeMutation setTemperature(float minTemperature, float maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        return this;
    }

    public ExtraTreeMutation setRainfall(float minRainfall, float maxRainfall) {
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public ExtraTreeMutation setTemperatureRainfall(float minTemperature, float maxTemperature, float minRainfall, float maxRainfall) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public ExtraTreeMutation setHeight(int minHeight) {
        this.height = minHeight;
        return this;
    }

    public IAlleleTreeSpecies getAllele0() {
        return this.allele0;
    }

    public IAlleleTreeSpecies getAllele1() {
        return this.allele1;
    }

    public float getBaseChance() {
        return this.chance;
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public boolean isPartner(IAllele allele) {
        return this.allele0.getUID().equals(allele.getUID()) || this.allele1.getUID().equals(allele.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        if (this.allele0.getUID().equals(allele.getUID())) {
            return this.allele1;
        }
        return this.allele0;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public Collection<String> getSpecialConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.height > 0.0f) {
            conditions.add("Minimum height from bedrock of " + this.height);
        }
        return conditions;
    }

    public ITreeRoot getRoot() {
        return TreeManager.treeRoot;
    }

    public float getChance(World world, BlockPos pos, IAlleleTreeSpecies allele0, IAlleleTreeSpecies allele1, ITreeGenome genome0, ITreeGenome genome1) {
        int processedChance = this.chance;
        Biome biome = world.func_180494_b(pos);
        if (biome.func_185353_n() < this.minTemperature || biome.func_185353_n() > this.maxTemperature) {
            return 0.0f;
        }
        if (biome.func_76727_i() < this.minRainfall || biome.func_76727_i() > this.maxRainfall) {
            return 0.0f;
        }
        if (this.height > 0.0f && (float)pos.func_177956_o() < this.height) {
            return 0.0f;
        }
        if (this.allele0.getUID().equals(allele0.getUID()) && this.allele1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.allele1.getUID().equals(allele0.getUID()) && this.allele0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }
}

