/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.storage.CompartmentTab;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

class ComponentCompartmentInventory
extends ComponentInventorySlots
implements INetwork.GuiNBT {
    private int numberOfTabs;
    private int slotsPerPage;
    private Map<Integer, CompartmentTab> tabs = new HashMap<Integer, CompartmentTab>();

    public ComponentCompartmentInventory(IMachine machine, int tabs, int pageSize) {
        super(machine);
        this.numberOfTabs = tabs;
        this.slotsPerPage = pageSize;
        for (int i = 0; i < this.numberOfTabs * this.slotsPerPage; ++i) {
            this.addSlot(i, "compartment");
        }
    }

    public int getPageSize() {
        return this.slotsPerPage;
    }

    public int getTabNumber() {
        return this.numberOfTabs;
    }

    public int[] getSlotsForTab(int currentTab) {
        int[] slots = new int[this.slotsPerPage];
        for (int i = 0; i < this.slotsPerPage; ++i) {
            slots[i] = i + currentTab * this.slotsPerPage;
        }
        return slots;
    }

    public CompartmentTab getTab(int i) {
        if (!this.tabs.containsKey(i)) {
            this.tabs.put(i, new CompartmentTab(i));
        }
        return this.tabs.get(i);
    }

    @Override
    public void sendGuiNBTToClient(Map<String, NBTTagCompound> nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.numberOfTabs; ++i) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.getTab(i).writeToNBT(nbt2);
            list.func_74742_a((NBTBase)nbt2);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tabs", (NBTBase)list);
        nbt.put("comp-tabs", tag);
    }

    @Override
    public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("comp-tabs")) {
            NBTTagList tags = nbt.func_150295_c("tabs", 10);
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound tag = tags.func_150305_b(i);
                CompartmentTab tab = new CompartmentTab(0);
                tab.readFromNBT(tag);
                this.tabs.put(tab.getId(), tab);
            }
        }
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("comp-change-tab")) {
            CompartmentTab tab2 = new CompartmentTab(0);
            tab2.readFromNBT(nbt);
            this.tabs.put(tab2.getId(), tab2);
            this.getMachine().getTileEntity().func_70296_d();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList tags = nbt.func_150295_c("tabs", 10);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound tag = tags.func_150305_b(i);
            CompartmentTab tab = new CompartmentTab(0);
            tab.readFromNBT(tag);
            this.tabs.put(tab.getId(), tab);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt4) {
        NBTTagCompound nbt = super.writeToNBT(nbt4);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.numberOfTabs; ++i) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.getTab(i).writeToNBT(nbt2);
            list.func_74742_a((NBTBase)nbt2);
        }
        nbt.func_74782_a("tabs", (NBTBase)list);
        return nbt;
    }
}

