/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidStackUtil {
    public static String toString(FluidStack fluidStack) {
        if (fluidStack == null) {
            return "null";
        }
        NBTTagCompound tag = fluidStack.tag;
        return fluidStack.getFluid().getName() + ":" + fluidStack.amount + (tag != null ? ":" + fluidStack.tag : "");
    }

    public static NonNullList<FluidStack> removeEqualFluids(Collection<FluidStack> fluidsStacks) {
        NonNullList dedupedFluidStacks = NonNullList.func_191196_a();
        for (FluidStack fluidStack : fluidsStacks) {
            if (FluidStackUtil.containsEqualFluid((NonNullList<FluidStack>)dedupedFluidStacks, fluidStack)) continue;
            dedupedFluidStacks.add((Object)fluidStack);
        }
        return dedupedFluidStacks;
    }

    public static boolean containsEqualFluid(NonNullList<FluidStack> fluidStacks, FluidStack query) {
        for (FluidStack fluidStack : fluidStacks) {
            if (!fluidStack.isFluidEqual(query)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemStack getContainer(FluidStack fluidStack) {
        ItemStack[] containers;
        for (ItemStack container : containers = new ItemStack[]{new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151133_ar)}) {
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
            if (fluidHandler == null || fluidHandler.fill(fluidStack, true) <= 0) continue;
            return fluidHandler.getContainer();
        }
        return null;
    }
}

