/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineGroup;
import binnie.core.util.I18N;
import net.minecraft.tileentity.TileEntity;

public abstract class MachinePackage {
    boolean powered;
    private String uid;
    private boolean active = true;
    private int metadata = -1;
    private MachineGroup group;

    protected MachinePackage(String uid, boolean powered) {
        this.uid = uid;
        this.powered = powered;
    }

    public String getUID() {
        return this.uid;
    }

    public abstract void createMachine(Machine var1);

    public abstract TileEntity createTileEntity();

    public abstract void register();

    public final String getDisplayName() {
        return I18N.localise(this.group.getMod().getModId() + '.' + "machine." + this.group.getShortUID() + "." + this.getUID());
    }

    public final Integer getMetadata() {
        return this.metadata;
    }

    public void assignMetadata(int meta) {
        this.metadata = meta;
    }

    public MachineGroup getGroup() {
        return this.group;
    }

    public void setGroup(MachineGroup group) {
        this.group = group;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public final String getInformation() {
        return I18N.localise(this.group.getMod().getModId() + '.' + "machine." + this.group.getShortUID() + "." + this.getUID() + ".info");
    }
}

