/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ComponentInventorySlots
extends ComponentInventory
implements IInventoryMachine,
IInventorySlots {
    private Map<Integer, InventorySlot> inventory = new LinkedHashMap<Integer, InventorySlot>();

    public ComponentInventorySlots(IMachine machine) {
        super(machine);
    }

    @Override
    public void func_174888_l() {
        for (InventorySlot slot : this.inventory.values()) {
            slot.setContent(ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_174885_b(int id, int value) {
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        InventorySlot inventorySlot = this.inventory.get(index);
        ItemStack content = inventorySlot.getItemStack();
        inventorySlot.setContent(ItemStack.field_190927_a);
        return content;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("");
    }

    @Override
    public int func_70302_i_() {
        int size = 0;
        for (Integer index : this.inventory.keySet()) {
            size = Math.max(size, index + 1);
        }
        return size;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index).getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70298_a(int index, int amount) {
        if (this.inventory.containsKey(index)) {
            ItemStack stack = this.inventory.get(index).decrStackSize(amount);
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int index, ItemStack itemStack) {
        if (this.inventory.containsKey(index) && (itemStack.func_190926_b() || this.inventory.get(index).isValid(itemStack))) {
            this.inventory.get(index).setContent(itemStack);
        }
        this.func_70296_d();
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    @Override
    public String func_70005_c_() {
        return "";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("inventory")) {
            NBTTagList inventoryNBT = nbttagcompound.func_150295_c("inventory", 10);
            for (int i = 0; i < inventoryNBT.func_74745_c(); ++i) {
                NBTTagCompound slotNBT = inventoryNBT.func_150305_b(i);
                int index = slotNBT.func_74762_e("id");
                if (slotNBT.func_74764_b("Slot")) {
                    index = slotNBT.func_74771_c("Slot") & 0xFF;
                }
                if (!this.inventory.containsKey(index)) continue;
                this.inventory.get(index).readFromNBT(slotNBT);
            }
        }
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound2) {
        NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
        NBTTagList inventoryNBT = new NBTTagList();
        for (Map.Entry<Integer, InventorySlot> entry : this.inventory.entrySet()) {
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74768_a("id", entry.getKey().intValue());
            entry.getValue().writeToNBT(slotNBT);
            inventoryNBT.func_74742_a((NBTBase)slotNBT);
        }
        nbttagcompound.func_74782_a("inventory", (NBTBase)inventoryNBT);
        return nbttagcompound;
    }

    public final InventorySlot addSlot(int index, String unlocName) {
        InventorySlot slot = new InventorySlot(index, unlocName);
        this.inventory.put(index, slot);
        return slot;
    }

    public final InventorySlot[] addSlotArray(int[] indexes, String unlocName) {
        for (int k : indexes) {
            this.addSlot(k, unlocName);
        }
        return this.getSlots(indexes);
    }

    @Override
    @Nullable
    public InventorySlot getSlot(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index);
        }
        return null;
    }

    public InventorySlot[] getSlots(int[] indexes) {
        ArrayList<InventorySlot> list = new ArrayList<InventorySlot>();
        for (int i : indexes) {
            if (this.getSlot(i) == null) continue;
            list.add(this.getSlot(i));
        }
        return list.toArray(new InventorySlot[0]);
    }

    private boolean isReadOnly(int slot) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot == null || iSlot.isReadOnly();
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot != null && iSlot.isValid(itemStack) && !this.isReadOnly(slot);
    }

    @Override
    public void onDestruction() {
        for (InventorySlot slot : this.inventory.values()) {
            ItemStack stack = slot.getItemStack();
            if (slot.isRecipe() || stack.func_190926_b()) continue;
            float f = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f3 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
            if (stack.func_190916_E() == 0) {
                stack.func_190920_e(1);
            }
            EntityItem entityitem = new EntityItem(this.getMachine().getWorld(), (double)((float)this.getMachine().getTileEntity().func_174877_v().func_177958_n() + f), (double)((float)this.getMachine().getTileEntity().func_174877_v().func_177956_o() + f2), (double)((float)this.getMachine().getTileEntity().func_174877_v().func_177952_p() + f3), stack.func_77946_l());
            float accel = 0.05f;
            entityitem.field_70159_w = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * 0.05f;
            entityitem.field_70181_x = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * 0.05f + 0.2f;
            entityitem.field_70179_y = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * 0.05f;
            this.getMachine().getWorld().func_72838_d((Entity)entityitem);
        }
    }

    public int[] func_180463_a(EnumFacing facing) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (InventorySlot slot : this.inventory.values()) {
            if (!slot.canInsert() && !slot.canExtract()) continue;
            slots.add(slot.getIndex());
        }
        int[] ids = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            ids[i] = (Integer)slots.get(i);
        }
        return ids;
    }

    public boolean func_180462_a(int index, ItemStack itemstack, EnumFacing direction) {
        InventorySlot slot;
        return this.func_94041_b(index, itemstack) && (slot = this.getSlot(index)) != null && slot.canInsert(direction);
    }

    public boolean func_180461_b(int index, ItemStack itemstack, EnumFacing direction) {
        InventorySlot slot = this.getSlot(index);
        return slot != null && slot.canExtract(direction);
    }
}

