/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlMutation;
import binnie.genetics.item.ModuleItems;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlResultantMutation
extends ControlMutation {
    public ControlResultantMutation(IWidget parent, int x, int y, IMutation mutation, float specificChance, IBreedingSystem system, IAlleleSpecies firstSpecies, IAlleleSpecies secondSpecies) {
        super(parent, x, y, mutation, specificChance, system, firstSpecies, secondSpecies);
        String comb = firstSpecies.getAlleleName() + " + " + secondSpecies.getAlleleName();
        this.addTooltip(comb);
        String chance = this.getMutationColour(mutation.getBaseChance()).getCode() + (int)mutation.getBaseChance() + "% " + I18N.localise("genetics.gui.analyst.mutations.chance");
        if (specificChance != mutation.getBaseChance()) {
            chance = chance + this.getMutationColour(specificChance).getCode() + " (" + (int)specificChance + "% " + I18N.localise("genetics.gui.analyst.mutations.currently") + ")";
        }
        this.addTooltip(chance);
        for (String condition : mutation.getSpecialConditions()) {
            this.addTooltip(condition);
        }
    }

    @Override
    public void initialise() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        GlStateManager.func_179147_l();
        RenderUtil.drawItem(Point.ZERO, this.system.getDefaultMember(this.firstSpecies.getUID()));
        RenderUtil.drawItem(new Point(28, 0), this.system.getDefaultMember(this.secondSpecies.getUID()));
        GlStateManager.func_179084_k();
        if (this.specificChance != this.mutation.getBaseChance()) {
            RenderUtil.setColour(this.getMutationColour(this.mutation.getBaseChance()).getColor());
            this.drawSprite(ModuleItems.iconAdd0);
            RenderUtil.setColour(this.getMutationColour(this.specificChance).getColor());
            this.drawSprite(ModuleItems.iconAdd1);
        } else {
            RenderUtil.setColour(this.getMutationColour(this.mutation.getBaseChance()).getColor());
            this.drawSprite(ModuleItems.iconAdd);
        }
    }
}

